/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification.provider;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.google.firebase.messaging.AndroidConfig;
import com.google.firebase.messaging.ApnsConfig;
import com.google.firebase.messaging.Aps;
import com.google.firebase.messaging.FirebaseMessagingException;
import com.google.firebase.messaging.Message;
import com.google.firebase.messaging.Notification;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.rule.engine.api.notification.FirebaseService;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.service.notification.provider.DefaultFirebaseService;

@Service
public class DefaultFirebaseService
implements FirebaseService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultFirebaseService.class);
    private final Cache<String, FirebaseContext> contexts = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).removalListener((key, context, cause) -> {
        if (cause == RemovalCause.EXPIRED && context != null) {
            context.destroy();
        }
    }).build();

    public void sendMessage(TenantId tenantId, String credentials, String fcmToken, String title, String body, Map<String, String> data, Integer badge) throws FirebaseMessagingException {
        FirebaseContext firebaseContext = this.contexts.asMap().compute(tenantId.toString(), (key, context) -> {
            if (context == null) {
                return new FirebaseContext(key, credentials);
            }
            context.check(credentials);
            return context;
        });
        Aps.Builder apsConfig = Aps.builder().setSound("default");
        if (badge != null) {
            apsConfig.setBadge(badge.intValue());
        }
        Message message = Message.builder().setToken(fcmToken).setNotification(Notification.builder().setTitle(title).setBody(body).build()).setAndroidConfig(AndroidConfig.builder().setPriority(AndroidConfig.Priority.HIGH).build()).setApnsConfig(ApnsConfig.builder().setAps(apsConfig.build()).build()).putAllData(data).build();
        try {
            firebaseContext.getMessaging().send(message);
            log.trace("[{}] Sent message for FCM token {}", (Object)tenantId, (Object)fcmToken);
        }
        catch (Throwable t) {
            log.debug("[{}] Failed to send message for FCM token {}", new Object[]{tenantId, fcmToken, t});
            throw t;
        }
    }
}

