/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification.channels;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.thingsboard.rule.engine.api.notification.SlackService;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;
import org.thingsboard.server.common.data.notification.NotificationRequestConfig;
import org.thingsboard.server.common.data.notification.settings.NotificationSettings;
import org.thingsboard.server.common.data.notification.settings.SlackNotificationDeliveryMethodConfig;
import org.thingsboard.server.common.data.notification.targets.slack.SlackConversation;
import org.thingsboard.server.common.data.notification.targets.slack.SlackFile;
import org.thingsboard.server.common.data.notification.template.SlackDeliveryMethodNotificationTemplate;
import org.thingsboard.server.common.data.report.Report;
import org.thingsboard.server.common.data.util.CollectionsUtil;
import org.thingsboard.server.dao.notification.NotificationSettingsService;
import org.thingsboard.server.dao.report.ReportService;
import org.thingsboard.server.service.notification.NotificationProcessingContext;
import org.thingsboard.server.service.notification.channels.NotificationChannel;

@Component
public class SlackNotificationChannel
implements NotificationChannel<SlackConversation, SlackDeliveryMethodNotificationTemplate> {
    private final SlackService slackService;
    private final NotificationSettingsService notificationSettingsService;
    private final ReportService reportService;

    public void sendNotification(SlackConversation conversation, SlackDeliveryMethodNotificationTemplate processedTemplate, NotificationProcessingContext ctx) throws Exception {
        SlackNotificationDeliveryMethodConfig config = (SlackNotificationDeliveryMethodConfig)ctx.getDeliveryMethodConfig(NotificationDeliveryMethod.SLACK);
        List<SlackFile> files = null;
        NotificationRequestConfig requestConfig = ctx.getRequest().getAdditionalConfig();
        if (requestConfig != null && CollectionsUtil.isNotEmpty((Collection)requestConfig.getReports())) {
            files = requestConfig.getReports().stream().map(reportId -> {
                Report report = this.reportService.findReportById(ctx.getTenantId(), reportId);
                return SlackFile.builder().name(report.getName()).data(this.reportService.getReportData(ctx.getTenantId(), reportId)).build();
            }).toList();
        }
        this.slackService.sendMessage(ctx.getTenantId(), config.getBotToken(), conversation.getId(), processedTemplate.getBody(), files);
    }

    public void check(TenantId tenantId) throws Exception {
        NotificationSettings notificationSettings = this.notificationSettingsService.findNotificationSettings(tenantId);
        if (!notificationSettings.getDeliveryMethodsConfigs().containsKey(NotificationDeliveryMethod.SLACK)) {
            throw new RuntimeException("Slack API token is not configured");
        }
    }

    public NotificationDeliveryMethod getDeliveryMethod() {
        return NotificationDeliveryMethod.SLACK;
    }

    @ConstructorProperties(value={"slackService", "notificationSettingsService", "reportService"})
    @Generated
    public SlackNotificationChannel(SlackService slackService, NotificationSettingsService notificationSettingsService, ReportService reportService) {
        this.slackService = slackService;
        this.notificationSettingsService = notificationSettingsService;
        this.reportService = reportService;
    }
}

