/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification.channels;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import com.google.firebase.messaging.FirebaseMessagingException;
import com.google.firebase.messaging.MessagingErrorCode;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.notification.FirebaseService;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.id.NotificationRequestId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.Notification;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;
import org.thingsboard.server.common.data.notification.NotificationRequest;
import org.thingsboard.server.common.data.notification.NotificationStatus;
import org.thingsboard.server.common.data.notification.info.NotificationInfo;
import org.thingsboard.server.common.data.notification.settings.MobileAppNotificationDeliveryMethodConfig;
import org.thingsboard.server.common.data.notification.settings.NotificationSettings;
import org.thingsboard.server.common.data.notification.template.MobileAppDeliveryMethodNotificationTemplate;
import org.thingsboard.server.dao.notification.NotificationService;
import org.thingsboard.server.dao.notification.NotificationSettingsService;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.service.notification.NotificationProcessingContext;
import org.thingsboard.server.service.notification.channels.MobileAppNotificationChannel;
import org.thingsboard.server.service.notification.channels.NotificationChannel;

@Component
public class MobileAppNotificationChannel
implements NotificationChannel<User, MobileAppDeliveryMethodNotificationTemplate> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MobileAppNotificationChannel.class);
    private final FirebaseService firebaseService;
    private final UserService userService;
    private final NotificationService notificationService;
    private final NotificationSettingsService notificationSettingsService;

    public void sendNotification(User recipient, MobileAppDeliveryMethodNotificationTemplate processedTemplate, NotificationProcessingContext ctx) throws Exception {
        NotificationRequest request = ctx.getRequest();
        NotificationInfo info = request.getInfo();
        if (info != null && info.getDashboardId() != null) {
            ObjectNode additionalConfig = JacksonUtil.asObject((JsonNode)processedTemplate.getAdditionalConfig());
            ObjectNode onClick = JacksonUtil.asObject((JsonNode)additionalConfig.get("onClick"));
            if (onClick.get("enabled") == null || !Boolean.parseBoolean(onClick.get("enabled").asText())) {
                onClick.put("enabled", true);
                onClick.put("linkType", "DASHBOARD");
                onClick.put("setEntityIdInState", true);
                onClick.put("dashboardId", info.getDashboardId().toString());
                additionalConfig.set("onClick", (JsonNode)onClick);
            }
            processedTemplate.setAdditionalConfig((JsonNode)additionalConfig);
        }
        Notification notification = Notification.builder().requestId((NotificationRequestId)request.getId()).recipientId(recipient.getId()).type(ctx.getNotificationType()).deliveryMethod(NotificationDeliveryMethod.MOBILE_APP).subject(processedTemplate.getSubject()).text(processedTemplate.getBody()).additionalConfig(processedTemplate.getAdditionalConfig()).info(info).status(NotificationStatus.SENT).build();
        this.notificationService.saveNotification(recipient.getTenantId(), notification);
        Map mobileSessions = this.userService.findMobileSessions(recipient.getTenantId(), recipient.getId());
        if (mobileSessions.isEmpty()) {
            throw new IllegalArgumentException("User doesn't use the mobile app");
        }
        MobileAppNotificationDeliveryMethodConfig config = (MobileAppNotificationDeliveryMethodConfig)ctx.getDeliveryMethodConfig(NotificationDeliveryMethod.MOBILE_APP);
        String credentials = config.getFirebaseServiceAccountCredentials();
        HashSet validTokens = new HashSet(mobileSessions.keySet());
        String subject = processedTemplate.getSubject();
        String body = processedTemplate.getBody();
        Map data = this.getNotificationData(processedTemplate, ctx);
        int unreadCount = this.notificationService.countUnreadNotificationsByRecipientId(ctx.getTenantId(), NotificationDeliveryMethod.MOBILE_APP, recipient.getId());
        for (String token : mobileSessions.keySet()) {
            try {
                this.firebaseService.sendMessage(ctx.getTenantId(), credentials, token, subject, body, data, Integer.valueOf(unreadCount));
            }
            catch (FirebaseMessagingException e) {
                MessagingErrorCode errorCode = e.getMessagingErrorCode();
                if (errorCode == MessagingErrorCode.UNREGISTERED || errorCode == MessagingErrorCode.INVALID_ARGUMENT || errorCode == MessagingErrorCode.SENDER_ID_MISMATCH) {
                    validTokens.remove(token);
                    this.userService.removeMobileSession(recipient.getTenantId(), token);
                    log.debug("[{}][{}] Removed invalid FCM token due to {} {} ({})", new Object[]{recipient.getTenantId(), recipient.getId(), errorCode, e.getMessage(), token});
                    continue;
                }
                throw new RuntimeException("Failed to send message via FCM: " + e.getMessage(), e);
            }
        }
        if (validTokens.isEmpty()) {
            throw new IllegalArgumentException("User doesn't use the mobile app");
        }
    }

    private Map<String, String> getNotificationData(MobileAppDeliveryMethodNotificationTemplate processedTemplate, NotificationProcessingContext ctx) {
        Map data = Optional.ofNullable(processedTemplate.getAdditionalConfig()).filter(JsonNode::isObject).map(JacksonUtil::toFlatMap).orElseGet(HashMap::new);
        NotificationInfo info = ctx.getRequest().getInfo();
        if (info == null) {
            return data;
        }
        Optional.ofNullable(info.getStateEntityId()).ifPresent(stateEntityId -> {
            data.put("stateEntityId", stateEntityId.getId().toString());
            data.put("stateEntityType", stateEntityId.getEntityType().name());
        });
        data.put("notificationType", ctx.getNotificationType().name());
        switch (1.$SwitchMap$org$thingsboard$server$common$data$notification$NotificationType[ctx.getNotificationType().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                info.getTemplateData().forEach((key, value) -> data.put("info." + key, value));
            }
        }
        data.replaceAll((key, value) -> Strings.nullToEmpty((String)value));
        return data;
    }

    public void check(TenantId tenantId) throws Exception {
        MobileAppNotificationDeliveryMethodConfig config;
        NotificationSettings settings = this.notificationSettingsService.findNotificationSettings(tenantId);
        if (!tenantId.isSysTenantId() && ((config = (MobileAppNotificationDeliveryMethodConfig)settings.getDeliveryMethodsConfigs().get(NotificationDeliveryMethod.MOBILE_APP)) == null || config.isUseSystemSettings())) {
            settings = this.notificationSettingsService.findNotificationSettings(TenantId.SYS_TENANT_ID);
        }
        if (!settings.getDeliveryMethodsConfigs().containsKey(NotificationDeliveryMethod.MOBILE_APP)) {
            throw new RuntimeException("Push-notifications to mobile app are not configured");
        }
    }

    public NotificationDeliveryMethod getDeliveryMethod() {
        return NotificationDeliveryMethod.MOBILE_APP;
    }

    @ConstructorProperties(value={"firebaseService", "userService", "notificationService", "notificationSettingsService"})
    @Generated
    public MobileAppNotificationChannel(FirebaseService firebaseService, UserService userService, NotificationService notificationService, NotificationSettingsService notificationSettingsService) {
        this.firebaseService = firebaseService;
        this.userService = userService;
        this.notificationService = notificationService;
        this.notificationSettingsService = notificationSettingsService;
    }
}

