/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.mail;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.RefreshTokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.time.Duration;
import java.time.Instant;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.thingsboard.server.common.data.AdminSettings;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.mail.MailOauth2Provider;
import org.thingsboard.server.dao.exception.IncorrectParameterException;
import org.thingsboard.server.service.mail.TbMailContextComponent;

public class TbMailSender
extends JavaMailSenderImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbMailSender.class);
    private static final String MAIL_PROP = "mail.";
    private final TbMailContextComponent ctx;
    private final Lock lock = new ReentrantLock();
    private final Boolean oauth2Enabled;
    private volatile String accessToken;
    private volatile long tokenExpires = 0L;
    private final TenantId tenantId;

    public TbMailSender(TbMailContextComponent ctx, TenantId tenantId, JsonNode jsonConfig) {
        this.ctx = ctx;
        this.tenantId = tenantId;
        this.oauth2Enabled = jsonConfig.has("enableOauth2") && jsonConfig.get("enableOauth2").asBoolean();
        this.setHost(jsonConfig.get("smtpHost").asText());
        this.setPort(this.parsePort(jsonConfig.get("smtpPort").asText()));
        this.setUsername(jsonConfig.get("username").asText());
        if (jsonConfig.has("password")) {
            this.setPassword(jsonConfig.get("password").asText());
        }
        this.setJavaMailProperties(this.createJavaMailProperties(jsonConfig));
    }

    protected void doSend(MimeMessage[] mimeMessages, @Nullable Object[] originalMessages) throws MailException {
        this.updateOauth2PasswordIfExpired();
        this.doSendSuper(mimeMessages, originalMessages);
    }

    public void doSendSuper(MimeMessage[] mimeMessages, Object[] originalMessages) {
        super.doSend(mimeMessages, originalMessages);
    }

    public void testConnection() throws MessagingException {
        this.updateOauth2PasswordIfExpired();
        this.testConnectionSuper();
    }

    public void testConnectionSuper() throws MessagingException {
        super.testConnection();
    }

    public void updateOauth2PasswordIfExpired() {
        if (this.getOauth2Enabled().booleanValue() && System.currentTimeMillis() > this.getTokenExpires()) {
            this.refreshAccessToken(this.tenantId);
            this.setPassword(this.accessToken);
        }
    }

    private Properties createJavaMailProperties(JsonNode jsonConfig) {
        boolean enableProxy;
        String tlsVersion;
        Properties javaMailProperties = new Properties();
        String protocol = jsonConfig.get("smtpProtocol").asText();
        javaMailProperties.put("mail.transport.protocol", protocol);
        javaMailProperties.put(MAIL_PROP + protocol + ".host", jsonConfig.get("smtpHost").asText());
        javaMailProperties.put(MAIL_PROP + protocol + ".port", jsonConfig.get("smtpPort").asText());
        javaMailProperties.put(MAIL_PROP + protocol + ".timeout", jsonConfig.get("timeout").asText());
        javaMailProperties.put(MAIL_PROP + protocol + ".auth", String.valueOf(StringUtils.isNotEmpty((String)jsonConfig.get("username").asText())));
        boolean enableTls = false;
        if (jsonConfig.has("enableTls")) {
            if (jsonConfig.get("enableTls").isBoolean() && jsonConfig.get("enableTls").booleanValue()) {
                enableTls = true;
            } else if (jsonConfig.get("enableTls").isTextual()) {
                enableTls = "true".equalsIgnoreCase(jsonConfig.get("enableTls").asText());
            }
        }
        javaMailProperties.put(MAIL_PROP + protocol + ".starttls.enable", (Object)enableTls);
        if (enableTls && jsonConfig.has("tlsVersion") && !jsonConfig.get("tlsVersion").isNull() && StringUtils.isNoneEmpty((String)(tlsVersion = jsonConfig.get("tlsVersion").asText()))) {
            javaMailProperties.put(MAIL_PROP + protocol + ".ssl.protocols", tlsVersion);
        }
        boolean bl = enableProxy = jsonConfig.has("enableProxy") && jsonConfig.get("enableProxy").asBoolean();
        if (enableProxy) {
            String proxyPassword;
            javaMailProperties.put(MAIL_PROP + protocol + ".proxy.host", jsonConfig.get("proxyHost").asText());
            javaMailProperties.put(MAIL_PROP + protocol + ".proxy.port", jsonConfig.get("proxyPort").asText());
            String proxyUser = jsonConfig.get("proxyUser").asText();
            if (StringUtils.isNoneEmpty((String)proxyUser)) {
                javaMailProperties.put(MAIL_PROP + protocol + ".proxy.user", proxyUser);
            }
            if (StringUtils.isNoneEmpty((String)(proxyPassword = jsonConfig.get("proxyPassword").asText()))) {
                javaMailProperties.put(MAIL_PROP + protocol + ".proxy.password", proxyPassword);
            }
        }
        if (this.oauth2Enabled.booleanValue()) {
            javaMailProperties.put(MAIL_PROP + protocol + ".auth.mechanisms", "XOAUTH2");
        }
        return javaMailProperties;
    }

    public void refreshAccessToken(TenantId tenantId) {
        this.lock.lock();
        try {
            if (System.currentTimeMillis() > this.getTokenExpires()) {
                AdminSettings settings = this.getMailSettings(tenantId);
                JsonNode jsonValue = settings.getJsonValue().deepCopy();
                this.ctx.getSecretConfigurationService().replaceSecretUsages(tenantId, jsonValue);
                String clientId = jsonValue.get("clientId").asText();
                String clientSecret = jsonValue.get("clientSecret").asText();
                String refreshToken = jsonValue.get("refreshToken").asText();
                String tokenUri = jsonValue.get("tokenUri").asText();
                String providerId = jsonValue.get("providerId").asText();
                TokenResponse tokenResponse = new RefreshTokenRequest((HttpTransport)new NetHttpTransport(), (JsonFactory)new GsonFactory(), new GenericUrl(tokenUri), refreshToken).setClientAuthentication((HttpExecuteInterceptor)new ClientParametersAuthentication(clientId, clientSecret)).execute();
                if (MailOauth2Provider.OFFICE_365.name().equals(providerId)) {
                    ((ObjectNode)settings.getJsonValue()).put("refreshToken", tokenResponse.getRefreshToken());
                    ((ObjectNode)settings.getJsonValue()).put("refreshTokenExpires", Instant.now().plus(Duration.ofDays(90L)).toEpochMilli());
                    this.ctx.getAdminSettingsService().saveAdminSettings(tenantId, settings);
                }
                this.accessToken = tokenResponse.getAccessToken();
                this.tokenExpires = System.currentTimeMillis() + (long)(tokenResponse.getExpiresInSeconds().intValue() * 1000);
            }
        }
        catch (Exception e) {
            log.error("Unable to retrieve access token: {}", (Object)e.getMessage());
            throw new RuntimeException("Error while retrieving access token: " + e.getMessage());
        }
        finally {
            this.lock.unlock();
        }
    }

    public AdminSettings getMailSettings(TenantId tenantId) {
        JsonNode useSystemMailSettingsNode;
        if (TenantId.SYS_TENANT_ID.equals((Object)tenantId)) {
            return this.getAdminMailSettings(TenantId.SYS_TENANT_ID);
        }
        AdminSettings adminSettings = this.getAdminMailSettings(tenantId);
        JsonNode jsonConfig = null;
        if (adminSettings != null && ((useSystemMailSettingsNode = (jsonConfig = adminSettings.getJsonValue()).get("useSystemMailSettings")) == null || useSystemMailSettingsNode.asBoolean())) {
            jsonConfig = null;
        }
        if (jsonConfig == null) {
            if (!this.isAllowSystemMailService()) {
                throw new RuntimeException("Access to System Mail Service is forbidden!");
            }
            return this.getAdminMailSettings(TenantId.SYS_TENANT_ID);
        }
        return adminSettings;
    }

    public boolean isAllowSystemMailService() {
        return this.ctx.isAllowSystemMailService();
    }

    public AdminSettings getAdminMailSettings(TenantId tenantId) {
        return this.ctx.getAdminSettingsService().findAdminSettingsByTenantIdAndKey(tenantId, "mail");
    }

    private int parsePort(String strPort) {
        try {
            return Integer.parseInt(strPort);
        }
        catch (NumberFormatException e) {
            throw new IncorrectParameterException(String.format("Invalid smtp port value: %s", strPort));
        }
    }

    @Generated
    public Boolean getOauth2Enabled() {
        return this.oauth2Enabled;
    }

    @Generated
    public long getTokenExpires() {
        return this.tokenExpires;
    }
}

