/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.mail;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.RefreshTokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.AdminSettings;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.mail.MailOauth2Provider;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.secret.SecretConfigurationService;
import org.thingsboard.server.dao.settings.AdminSettingsService;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.queue.util.TbCoreComponent;

@TbCoreComponent
@Service
public class RefreshTokenExpCheckService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RefreshTokenExpCheckService.class);
    public static final int AZURE_DEFAULT_REFRESH_TOKEN_LIFETIME_IN_DAYS = 90;
    private final TenantService tenantService;
    private final AdminSettingsService adminSettingsService;
    private final SecretConfigurationService secretConfigurationService;

    @Scheduled(initialDelayString="#{T(org.apache.commons.lang3.RandomUtils).nextLong(0, ${mail.oauth2.refreshTokenCheckingInterval})}", fixedDelayString="${mail.oauth2.refreshTokenCheckingInterval}", timeUnit=TimeUnit.SECONDS)
    public void check() throws Exception {
        PageData tenantIds;
        PageLink pageLink = new PageLink(1000);
        do {
            tenantIds = this.tenantService.findTenantsIds(pageLink);
            for (TenantId tenantId : tenantIds.getData()) {
                try {
                    AdminSettings tenantMailSettings = this.adminSettingsService.findAdminSettingsByTenantIdAndKey(tenantId, "mail");
                    this.refreshTokenIfExpires(tenantId, tenantMailSettings, (arg_0, arg_1) -> ((AdminSettingsService)this.adminSettingsService).saveAdminSettings(arg_0, arg_1));
                }
                catch (Exception e) {
                    log.error("[{}] Error occurred while checking token", (Object)tenantId, (Object)e);
                }
            }
            pageLink = pageLink.nextPageLink();
        } while (tenantIds.hasNext());
        AdminSettings systemMailSettings = this.adminSettingsService.findAdminSettingsByKey(TenantId.SYS_TENANT_ID, "mail");
        this.refreshTokenIfExpires(TenantId.SYS_TENANT_ID, systemMailSettings, (arg_0, arg_1) -> ((AdminSettingsService)this.adminSettingsService).saveAdminSettings(arg_0, arg_1));
    }

    private void refreshTokenIfExpires(TenantId tenantId, AdminSettings adminSettings, BiConsumer<TenantId, AdminSettings> saveFunction) throws Exception {
        if (adminSettings != null) {
            JsonNode jsonValue = adminSettings.getJsonValue().deepCopy();
            this.secretConfigurationService.replaceSecretUsages(tenantId, jsonValue);
            if (jsonValue != null && jsonValue.has("useSystemMailSettings") && !jsonValue.get("useSystemMailSettings").asBoolean() && jsonValue.has("enableOauth2") && jsonValue.get("enableOauth2").asBoolean() && MailOauth2Provider.OFFICE_365.name().equals(jsonValue.get("providerId").asText()) && jsonValue.has("refreshToken") && jsonValue.has("refreshTokenExpires")) {
                long expiresIn = jsonValue.get("refreshTokenExpires").longValue();
                long tokenLifeDuration = expiresIn - System.currentTimeMillis();
                if (tokenLifeDuration < 0L) {
                    ((ObjectNode)adminSettings.getJsonValue()).put("tokenGenerated", false);
                    ((ObjectNode)adminSettings.getJsonValue()).remove("refreshToken");
                    ((ObjectNode)adminSettings.getJsonValue()).remove("refreshTokenExpires");
                    saveFunction.accept(tenantId, adminSettings);
                } else if (tokenLifeDuration < 604800000L) {
                    log.info("Trying to refresh refresh token.");
                    String clientId = jsonValue.get("clientId").asText();
                    String clientSecret = jsonValue.get("clientSecret").asText();
                    String refreshToken = jsonValue.get("refreshToken").asText();
                    String tokenUri = jsonValue.get("tokenUri").asText();
                    TokenResponse tokenResponse = new RefreshTokenRequest((HttpTransport)new NetHttpTransport(), (JsonFactory)new GsonFactory(), new GenericUrl(tokenUri), refreshToken).setClientAuthentication((HttpExecuteInterceptor)new ClientParametersAuthentication(clientId, clientSecret)).execute();
                    ((ObjectNode)adminSettings.getJsonValue()).put("refreshToken", tokenResponse.getRefreshToken());
                    ((ObjectNode)adminSettings.getJsonValue()).put("refreshTokenExpires", Instant.now().plus(Duration.ofDays(90L)).toEpochMilli());
                    saveFunction.accept(tenantId, adminSettings);
                }
            }
        }
    }

    @ConstructorProperties(value={"tenantService", "adminSettingsService", "secretConfigurationService"})
    @Generated
    public RefreshTokenExpCheckService(TenantService tenantService, AdminSettingsService adminSettingsService, SecretConfigurationService secretConfigurationService) {
        this.tenantService = tenantService;
        this.adminSettingsService = adminSettingsService;
        this.secretConfigurationService = secretConfigurationService;
    }
}

