/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.mail;

import com.fasterxml.jackson.databind.JsonNode;
import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.thingsboard.server.dao.exception.IncorrectParameterException;

/*
 * Exception performing whole class analysis ignored.
 */
public class MailTemplates {
    public static final String TEST = "test";
    public static final String ACTIVATION = "activation";
    public static final String ACCOUNT_ACTIVATED = "accountActivated";
    public static final String ACCOUNT_LOCKOUT = "accountLockout";
    public static final String API_USAGE_STATE_ENABLED = "apiUsageStateEnabled";
    public static final String API_USAGE_STATE_WARNING = "apiUsageStateWarning";
    public static final String API_USAGE_STATE_DISABLED = "apiUsageStateDisabled";
    public static final String RESET_PASSWORD = "resetPassword";
    public static final String PASSWORD_WAS_RESET = "passwordWasReset";
    public static final String TWO_FA_VERIFICATION = "twoFaVerification";
    private static final String SUBJECT = "subject";
    private static final String BODY = "body";

    public static String subject(JsonNode config, String template) {
        JsonNode templateNode = MailTemplates.getTemplate((JsonNode)config, (String)template);
        if (templateNode.has("subject")) {
            return templateNode.get("subject").asText();
        }
        throw new IncorrectParameterException("Template '" + template + "' doesn't have subject field.");
    }

    public static String body(JsonNode config, String template, Map<String, Object> model) throws IOException, TemplateException {
        JsonNode templateNode = MailTemplates.getTemplate((JsonNode)config, (String)template);
        if (templateNode.has("body")) {
            String bodyTemplate = templateNode.get("body").asText();
            Configuration configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
            configuration.setNewBuiltinClassResolver(TemplateClassResolver.SAFER_RESOLVER);
            Template freeMakerTemplate = new Template(template, (Reader)new StringReader(bodyTemplate), configuration);
            StringWriter out = new StringWriter();
            freeMakerTemplate.process(model, (Writer)out);
            return out.toString();
        }
        throw new IncorrectParameterException("Template '" + template + "' doesn't have body field.");
    }

    public static JsonNode getTemplate(JsonNode config, String template) {
        JsonNode templateNode = config.get(template);
        if (templateNode == null) {
            throw new IncorrectParameterException("Can't find template with name '" + template + "'.");
        }
        return templateNode;
    }
}

