/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.license;

import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.util.CollectionsUtil;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.dao.instance.registry.InstanceRegistryService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.TbApplicationEventListener;
import org.thingsboard.server.queue.discovery.event.ServiceListChangedEvent;

@Service
@ConditionalOnProperty(prefix="zk", value={"enabled"}, havingValue="true")
public class InstanceRegistryCleanUpService
extends TbApplicationEventListener<ServiceListChangedEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstanceRegistryCleanUpService.class);
    private final InstanceRegistryService instanceRegistryService;
    private final PartitionService partitionService;
    private Set<String> currentIds = new HashSet();

    protected void onTbApplicationEvent(ServiceListChangedEvent event) {
        List otherServices = event.getOtherServices().stream().filter(serviceInfo -> serviceInfo.getServiceTypesList().contains((Object)"TB_CORE") || serviceInfo.getServiceTypesList().contains((Object)"TB_RULE_ENGINE")).collect(Collectors.toList());
        Set serviceTypes = otherServices.stream().flatMap(s -> s.getServiceTypesList().stream()).collect(Collectors.toSet());
        serviceTypes.addAll(event.getCurrentService().getServiceTypesList());
        ServiceType serviceType = serviceTypes.contains("TB_CORE") ? ServiceType.TB_CORE : ServiceType.TB_RULE_ENGINE;
        Set newIds = otherServices.stream().map(TransportProtos.ServiceInfo::getServiceId).collect(Collectors.toSet());
        Set toRemove = CollectionsUtil.diffSets(newIds, (Set)this.currentIds);
        this.currentIds = newIds;
        if (!toRemove.isEmpty() && this.partitionService.isSystemTenantPartitionMine(serviceType)) {
            log.debug("Going to remove outdated instance registries: {}", (Object)toRemove);
            toRemove.forEach(arg_0 -> ((InstanceRegistryService)this.instanceRegistryService).deleteByServiceId(arg_0));
        }
    }

    @ConstructorProperties(value={"instanceRegistryService", "partitionService"})
    @Generated
    public InstanceRegistryCleanUpService(InstanceRegistryService instanceRegistryService, PartitionService partitionService) {
        this.instanceRegistryService = instanceRegistryService;
        this.partitionService = partitionService;
    }
}

