/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.integration.rpc;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.thingsboard.integration.api.data.IntegrationDownlinkMsg;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.service.integration.RemoteIntegrationRpcService;
import org.thingsboard.server.service.integration.rpc.IntegrationSession;
import org.thingsboard.server.service.integration.rpc.RemoteIntegrationSessionService;

@Service
@ConditionalOnExpression(value="'${service.type:null}'=='tb-rule-engine' && '${integrations.rpc.enabled:false}'=='true'")
public class TbRuleEngineRemoteIntegrationRpcService
implements RemoteIntegrationRpcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbRuleEngineRemoteIntegrationRpcService.class);
    private final TbServiceInfoProvider serviceInfoProvider;
    private final RemoteIntegrationSessionService sessionsCache;
    private final TbClusterService clusterService;

    public void updateIntegration(Integration configuration) {
    }

    public void updateConverter(Converter converter) {
    }

    public boolean handleRemoteDownlink(IntegrationDownlinkMsg msg) {
        IntegrationSession remoteSession = this.sessionsCache.findIntegrationSession(msg.getIntegrationId());
        if (remoteSession != null && !remoteSession.getServiceId().equals(this.serviceInfoProvider.getServiceId())) {
            log.debug("[{}] Remote integration session found for [{}] downlink @ Server [{}].", new Object[]{msg.getIntegrationId(), msg.getEntityId(), remoteSession.getServiceId()});
            this.clusterService.pushNotificationToCore(remoteSession.getServiceId(), msg, null);
            return true;
        }
        return false;
    }

    @ConstructorProperties(value={"serviceInfoProvider", "sessionsCache", "clusterService"})
    @Generated
    public TbRuleEngineRemoteIntegrationRpcService(TbServiceInfoProvider serviceInfoProvider, RemoteIntegrationSessionService sessionsCache, TbClusterService clusterService) {
        this.serviceInfoProvider = serviceInfoProvider;
        this.sessionsCache = sessionsCache;
        this.clusterService = clusterService;
    }
}

