/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.integration.rpc;

import com.google.common.io.Resources;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.thingsboard.integration.api.data.IntegrationDownlinkMsg;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.common.data.event.Event;
import org.thingsboard.server.common.data.event.LifecycleEvent;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.gen.integration.IntegrationTransportGrpc;
import org.thingsboard.server.gen.integration.RequestMsg;
import org.thingsboard.server.gen.integration.ResponseMsg;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.service.integration.IntegrationContextComponent;
import org.thingsboard.server.service.integration.RemoteIntegrationRpcService;
import org.thingsboard.server.service.integration.rpc.IntegrationGrpcSession;
import org.thingsboard.server.service.integration.rpc.IntegrationSession;
import org.thingsboard.server.service.integration.rpc.RemoteIntegrationSessionService;

@Service
@ConditionalOnExpression(value="('${service.type:null}'=='monolith' || '${service.type:null}'=='tb-core') && ('${integrations.rpc.enabled:false}'=='true')")
public class TbCoreRemoteIntegrationRpcService
extends IntegrationTransportGrpc.IntegrationTransportImplBase
implements RemoteIntegrationRpcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbCoreRemoteIntegrationRpcService.class);
    private final Map<IntegrationId, IntegrationGrpcSession> sessions = new ConcurrentHashMap();
    @Value(value="${integrations.rpc.port}")
    private int rpcPort;
    @Value(value="${integrations.rpc.ssl.enabled}")
    private boolean sslEnabled;
    @Value(value="${integrations.rpc.ssl.cert}")
    private String certFileResource;
    @Value(value="${integrations.rpc.ssl.privateKey}")
    private String privateKeyResource;
    @Value(value="${integrations.rpc.client_max_keep_alive_time_sec:300}")
    private int clientMaxKeepAliveTimeSec;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final IntegrationContextComponent ctx;
    private final RemoteIntegrationSessionService sessionsCache;
    private final TbClusterService clusterService;
    private final DeviceService deviceService;
    private Server server;

    public TbCoreRemoteIntegrationRpcService(TbServiceInfoProvider serviceInfoProvider, IntegrationContextComponent ctx, RemoteIntegrationSessionService sessionsCache, TbClusterService clusterService, DeviceService deviceService) {
        this.serviceInfoProvider = serviceInfoProvider;
        this.ctx = ctx;
        this.sessionsCache = sessionsCache;
        this.clusterService = clusterService;
        this.deviceService = deviceService;
    }

    @PostConstruct
    public void init() {
        log.info("Initializing RPC service!");
        NettyServerBuilder builder = (NettyServerBuilder)NettyServerBuilder.forPort((int)this.rpcPort).permitKeepAliveTime((long)this.clientMaxKeepAliveTimeSec, TimeUnit.SECONDS).addService((BindableService)this);
        if (this.sslEnabled) {
            try {
                File certFile = new File(Resources.getResource((String)this.certFileResource).toURI());
                File privateKeyFile = new File(Resources.getResource((String)this.privateKeyResource).toURI());
                builder.useTransportSecurity(certFile, privateKeyFile);
            }
            catch (Exception e) {
                log.error("Unable to set up SSL context. Reason: " + e.getMessage(), (Throwable)e);
                throw new RuntimeException("Unable to set up SSL context!", e);
            }
        }
        this.server = builder.build();
        log.info("Going to start RPC server using port: {}", (Object)this.rpcPort);
        try {
            this.server.start();
        }
        catch (IOException e) {
            log.error("Failed to start RPC server!", (Throwable)e);
            throw new RuntimeException("Failed to start RPC server!", e);
        }
        log.info("RPC service initialized!");
    }

    @PreDestroy
    public void destroy() {
        if (this.server != null) {
            this.server.shutdownNow();
        }
    }

    public StreamObserver<RequestMsg> handleMsgs(StreamObserver<ResponseMsg> responseObserver) {
        return new IntegrationGrpcSession(this.ctx, responseObserver, (arg_0, arg_1) -> this.onIntegrationConnect(arg_0, arg_1), arg_0 -> this.onIntegrationDisconnect(arg_0)).getInputStream();
    }

    public void updateIntegration(Integration configuration) {
        IntegrationGrpcSession session = (IntegrationGrpcSession)this.sessions.get(configuration.getId());
        if (session != null && session.isConnected()) {
            session.onConfigurationUpdate(configuration);
        }
    }

    public void updateConverter(Converter converter) {
        for (Map.Entry entry : this.sessions.entrySet()) {
            Integration configuration = ((IntegrationGrpcSession)entry.getValue()).getConfiguration();
            if (!((IntegrationGrpcSession)entry.getValue()).isConnected() || !configuration.getDefaultConverterId().equals((Object)converter.getId()) && !converter.getId().equals((Object)configuration.getDownlinkConverterId())) continue;
            try {
                ((IntegrationGrpcSession)entry.getValue()).onConverterUpdate(converter);
            }
            catch (Exception e) {
                log.error("Failed to update integration [{}] with converter [{}]", new Object[]{((IntegrationId)entry.getKey()).getId(), converter, e});
            }
        }
    }

    public boolean handleRemoteDownlink(IntegrationDownlinkMsg msg) {
        boolean sessionFound = false;
        IntegrationGrpcSession session = (IntegrationGrpcSession)this.sessions.get(msg.getIntegrationId());
        if (session != null) {
            log.debug("[{}] Remote integration session found for [{}] downlink.", (Object)msg.getIntegrationId(), (Object)msg.getEntityId());
            Device device = this.deviceService.findDeviceById(msg.getTenantId(), new DeviceId(msg.getEntityId().getId()));
            if (device != null) {
                session.onDownlink(device, msg);
            } else {
                log.debug("[{}] device [{}] not found.", (Object)msg.getIntegrationId(), (Object)msg.getEntityId());
            }
            sessionFound = true;
        } else {
            IntegrationSession remoteSession = this.sessionsCache.findIntegrationSession(msg.getIntegrationId());
            if (remoteSession != null && !remoteSession.getServiceId().equals(this.serviceInfoProvider.getServiceId())) {
                log.debug("[{}] Remote integration session found for [{}] downlink @ Server [{}].", new Object[]{msg.getIntegrationId(), msg.getEntityId(), remoteSession.getServiceId()});
                this.clusterService.pushNotificationToCore(remoteSession.getServiceId(), msg, null);
                sessionFound = true;
            }
        }
        return sessionFound;
    }

    private void onIntegrationConnect(IntegrationId integrationId, IntegrationGrpcSession integrationGrpcSession) {
        this.sessions.put(integrationId, integrationGrpcSession);
        this.sessionsCache.putIntegrationSession(integrationId, new IntegrationSession(this.serviceInfoProvider.getServiceId()));
    }

    private void onIntegrationDisconnect(IntegrationId integrationId) {
        IntegrationGrpcSession integrationGrpcSession = (IntegrationGrpcSession)this.sessions.get(integrationId);
        if (integrationGrpcSession != null) {
            TenantId tenantId = integrationGrpcSession.getConfiguration().getTenantId();
            LifecycleEvent event = LifecycleEvent.builder().tenantId(tenantId).entityId(integrationId.getId()).success(true).lcEventType("STOPPED").serviceId(integrationGrpcSession.getServiceId()).build();
            ListenableFuture future = this.ctx.getEventService().saveAsync((Event)event);
            Futures.transform((ListenableFuture)future, r -> {
                String key = "integration_status_" + event.getServiceId().toLowerCase();
                this.ctx.getAttributesService().removeAll(tenantId, (EntityId)integrationId, AttributeScope.SERVER_SCOPE, Collections.singletonList(key));
                return null;
            }, (Executor)MoreExecutors.directExecutor());
            this.sessions.remove(integrationId);
        }
        this.sessionsCache.removeIntegrationSession(integrationId);
    }
}

