/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.integration;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.common.data.id.ConverterId;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.common.data.integration.IntegrationInfo;
import org.thingsboard.server.common.data.integration.IntegrationType;
import org.thingsboard.server.dao.converter.ConverterService;
import org.thingsboard.server.dao.integration.IntegrationService;
import org.thingsboard.server.dao.secret.SecretConfigurationService;
import org.thingsboard.server.dao.tenant.TbTenantProfileCache;
import org.thingsboard.server.service.integration.IntegrationConfigurationService;

@Service
public class TbCoreIntegrationConfigurationService
implements IntegrationConfigurationService {
    private final ConverterService converterService;
    private final IntegrationService integrationService;
    private final TbTenantProfileCache tenantProfileCache;
    private final SecretConfigurationService secretConfigurationService;

    public List<IntegrationInfo> getActiveIntegrationList(IntegrationType type, boolean remote) {
        return this.integrationService.findAllCoreIntegrationInfos(type, remote, true);
    }

    public Integration getIntegration(TenantId tenantId, IntegrationId integrationId) {
        Integration integration = this.integrationService.findIntegrationById(tenantId, integrationId);
        return this.replaceSecretUsages(tenantId, integration);
    }

    public Integration getIntegration(TenantId tenantId, String routingKey) {
        Optional integrationOpt = this.integrationService.findIntegrationByRoutingKey(tenantId, routingKey);
        return this.replaceSecretUsages(tenantId, (Integration)integrationOpt.orElse(null));
    }

    private Integration replaceSecretUsages(TenantId tenantId, Integration integration) {
        if (integration == null) {
            return null;
        }
        Integration copy = new Integration(integration);
        this.secretConfigurationService.replaceSecretUsages(tenantId, copy.getConfiguration());
        return copy;
    }

    public Converter getConverter(TenantId tenantId, ConverterId converterId) {
        return this.converterService.findConverterById(tenantId, converterId);
    }

    public TenantProfile getTenantProfile(TenantId tenantId) {
        return this.tenantProfileCache.get(tenantId);
    }

    @ConstructorProperties(value={"converterService", "integrationService", "tenantProfileCache", "secretConfigurationService"})
    @Generated
    public TbCoreIntegrationConfigurationService(ConverterService converterService, IntegrationService integrationService, TbTenantProfileCache tenantProfileCache, SecretConfigurationService secretConfigurationService) {
        this.converterService = converterService;
        this.integrationService = integrationService;
        this.tenantProfileCache = tenantProfileCache;
        this.secretConfigurationService = secretConfigurationService;
    }
}

