/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.integration;

import com.google.common.util.concurrent.FutureCallback;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.integration.api.IntegrationStatistics;
import org.thingsboard.rule.engine.api.TimeseriesSaveRequest;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.common.data.event.Event;
import org.thingsboard.server.common.data.event.StatisticsEvent;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.dao.event.EventService;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.integration.EventStorageService;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;

@TbCoreComponent
@Service
public class TbCoreEventStorageService
implements EventStorageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbCoreEventStorageService.class);
    private final TbServiceInfoProvider serviceInfoProvider;
    private final ActorSystemContext actorSystemContext;
    private final TelemetrySubscriptionService telemetrySubscriptionService;
    private final EventService eventService;

    public void persistLifecycleEvent(TenantId tenantId, EntityId entityId, ComponentLifecycleEvent lcEvent, Exception e) {
        this.actorSystemContext.persistLifecycleEvent(tenantId, entityId, lcEvent, e);
    }

    public void persistStatistics(TenantId tenantId, IntegrationId id, long ts, IntegrationStatistics statistics, ComponentLifecycleEvent currentState) {
        String serviceId = this.serviceInfoProvider.getServiceId();
        this.eventService.saveAsync((Event)StatisticsEvent.builder().tenantId(tenantId).entityId(id.getId()).serviceId(this.serviceInfoProvider.getServiceId()).messagesProcessed(statistics.getMessagesProcessed()).errorsOccurred(statistics.getErrorsOccurred()).build());
        ArrayList<BasicTsKvEntry> statsTs = new ArrayList<BasicTsKvEntry>();
        statsTs.add(new BasicTsKvEntry(ts, (KvEntry)new LongDataEntry(serviceId + "_messagesCount", Long.valueOf(statistics.getMessagesProcessed()))));
        statsTs.add(new BasicTsKvEntry(ts, (KvEntry)new LongDataEntry(serviceId + "_errorsCount", Long.valueOf(statistics.getErrorsOccurred()))));
        statsTs.add(new BasicTsKvEntry(ts, (KvEntry)new StringDataEntry(serviceId + "_state", currentState != null ? currentState.name() : "N/A")));
        this.telemetrySubscriptionService.saveTimeseriesInternal(TimeseriesSaveRequest.builder().tenantId(tenantId).entityId((EntityId)id).entries(statsTs).callback((FutureCallback)new /* Unavailable Anonymous Inner Class!! */).build());
    }

    @ConstructorProperties(value={"serviceInfoProvider", "actorSystemContext", "telemetrySubscriptionService", "eventService"})
    @Generated
    public TbCoreEventStorageService(TbServiceInfoProvider serviceInfoProvider, ActorSystemContext actorSystemContext, TelemetrySubscriptionService telemetrySubscriptionService, EventService eventService) {
        this.serviceInfoProvider = serviceInfoProvider;
        this.actorSystemContext = actorSystemContext;
        this.telemetrySubscriptionService = telemetrySubscriptionService;
        this.eventService = eventService;
    }
}

