/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.integration;

import com.google.common.util.concurrent.ListenableFuture;
import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.integration.api.IntegrationCallback;
import org.thingsboard.integration.api.IntegrationRateLimitService;
import org.thingsboard.integration.api.converter.ConverterContext;
import org.thingsboard.server.common.data.event.Event;
import org.thingsboard.server.common.data.id.ConverterId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.service.integration.ConverterContextComponent;

public class LocalConverterContext
implements ConverterContext {
    private final ConverterContextComponent ctx;
    private final TenantId tenantId;
    private final ConverterId converterId;

    public String getServiceId() {
        return this.ctx.getServiceInfoProvider().getServiceId();
    }

    public void saveEvent(Event event, IntegrationCallback<Void> callback) {
        DonAsynchron.withCallback((ListenableFuture)this.ctx.getEventService().saveAsync(event), res -> callback.onSuccess(null), arg_0 -> callback.onError(arg_0));
    }

    public Optional<IntegrationRateLimitService> getRateLimitService() {
        return Optional.of(this.ctx.getRateLimitService());
    }

    @ConstructorProperties(value={"ctx", "tenantId", "converterId"})
    @Generated
    public LocalConverterContext(ConverterContextComponent ctx, TenantId tenantId, ConverterId converterId) {
        this.ctx = ctx;
        this.tenantId = tenantId;
        this.converterId = converterId;
    }

    @Generated
    public ConverterContextComponent getCtx() {
        return this.ctx;
    }

    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public ConverterId getConverterId() {
        return this.converterId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalConverterContext)) {
            return false;
        }
        LocalConverterContext other = (LocalConverterContext)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ConverterContextComponent this$ctx = this.getCtx();
        ConverterContextComponent other$ctx = other.getCtx();
        if (this$ctx == null ? other$ctx != null : !this$ctx.equals(other$ctx)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        ConverterId this$converterId = this.getConverterId();
        ConverterId other$converterId = other.getConverterId();
        return !(this$converterId == null ? other$converterId != null : !this$converterId.equals(other$converterId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LocalConverterContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConverterContextComponent $ctx = this.getCtx();
        result = result * 59 + ($ctx == null ? 43 : $ctx.hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        ConverterId $converterId = this.getConverterId();
        result = result * 59 + ($converterId == null ? 43 : $converterId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LocalConverterContext(ctx=" + String.valueOf(this.getCtx()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", converterId=" + String.valueOf(this.getConverterId()) + ")";
    }
}

