/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.integration;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import java.beans.ConstructorProperties;
import java.util.UUID;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.integration.api.data.DefaultIntegrationDownlinkMsg;
import org.thingsboard.integration.api.data.IntegrationDownlinkMsg;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.gen.MsgProtos;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.common.msg.queue.TbMsgCallback;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.dao.integration.IntegrationService;
import org.thingsboard.server.gen.integration.ToIntegrationExecutorDownlinkMsg;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.TopicService;
import org.thingsboard.server.queue.provider.TbQueueProducerProvider;
import org.thingsboard.server.queue.settings.TbQueueIntegrationExecutorSettings;
import org.thingsboard.server.service.integration.RemoteIntegrationRpcService;
import org.thingsboard.server.service.integration.TbIntegrationDownlinkService;

@Service
public class DefaultTbIntegrationDownlinkService
implements TbIntegrationDownlinkService {
    private final PartitionService partitionService;
    private final IntegrationService integrationService;
    private final RemoteIntegrationRpcService remoteRpcService;
    private final TbQueueProducerProvider producerProvider;
    private final TbQueueIntegrationExecutorSettings integrationExecutorSettings;
    private final TopicService topicService;

    public void onRuleEngineDownlinkMsg(TenantId tenantId, IntegrationId integrationId, TransportProtos.IntegrationDownlinkMsgProto downlinkMsg, TbCallback callback) {
        Integration integration = this.integrationService.findIntegrationById(tenantId, integrationId);
        if (integration == null) {
            callback.onFailure((Throwable)new TbNodeException("Integration is missing!"));
        } else if (!integration.isEnabled().booleanValue()) {
            callback.onFailure((Throwable)new TbNodeException("Integration is disabled!"));
        } else if (integration.isRemote().booleanValue()) {
            this.onDownlinkToRemoteIntegrationMsg(tenantId, integrationId, downlinkMsg);
            callback.onSuccess();
        } else {
            TbQueueProducer producer = this.producerProvider.getTbIntegrationExecutorDownlinkMsgProducer();
            TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TB_INTEGRATION_EXECUTOR, integration.getType().name(), tenantId, (EntityId)integrationId).withTopic(this.topicService.buildTopicName(this.integrationExecutorSettings.getIntegrationDownlinkTopic(integration.getType())));
            producer.send(tpi, (TbQueueMsg)new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)ToIntegrationExecutorDownlinkMsg.newBuilder().setDownlinkMsg(downlinkMsg).build()), (TbQueueCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void onDownlinkToRemoteIntegrationMsg(TransportProtos.IntegrationDownlinkMsgProto msgProto, TbCallback callback) {
        TenantId tenantId = new TenantId(new UUID(msgProto.getTenantIdMSB(), msgProto.getTenantIdLSB()));
        IntegrationId integrationId = new IntegrationId(new UUID(msgProto.getIntegrationIdMSB(), msgProto.getIntegrationIdLSB()));
        this.onDownlinkToRemoteIntegrationMsg(tenantId, integrationId, msgProto);
        callback.onSuccess();
    }

    private void onDownlinkToRemoteIntegrationMsg(TenantId tenantId, IntegrationId integrationId, TransportProtos.IntegrationDownlinkMsgProto downlinkMsg) {
        DefaultIntegrationDownlinkMsg msg = new DefaultIntegrationDownlinkMsg(tenantId, integrationId, TbMsg.fromProto(null, (MsgProtos.TbMsgProto)downlinkMsg.getDataProto(), (ByteString)downlinkMsg.getData(), (TbMsgCallback)TbMsgCallback.EMPTY), null);
        this.remoteRpcService.handleRemoteDownlink((IntegrationDownlinkMsg)msg);
    }

    @ConstructorProperties(value={"partitionService", "integrationService", "remoteRpcService", "producerProvider", "integrationExecutorSettings", "topicService"})
    @Generated
    public DefaultTbIntegrationDownlinkService(PartitionService partitionService, IntegrationService integrationService, RemoteIntegrationRpcService remoteRpcService, TbQueueProducerProvider producerProvider, TbQueueIntegrationExecutorSettings integrationExecutorSettings, TopicService topicService) {
        this.partitionService = partitionService;
        this.integrationService = integrationService;
        this.remoteRpcService = remoteRpcService;
        this.producerProvider = producerProvider;
        this.integrationExecutorSettings = integrationExecutorSettings;
        this.topicService = topicService;
    }
}

