/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.integration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.integration.api.IntegrationCallback;
import org.thingsboard.rule.engine.api.TimeseriesSaveRequest;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.JavaSerDesUtil;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.event.Event;
import org.thingsboard.server.common.data.event.EventType;
import org.thingsboard.server.common.data.event.LifecycleEvent;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.AssetProfileId;
import org.thingsboard.server.common.data.id.ConverterId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.integration.AbstractIntegration;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.JsonDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.objects.TelemetryEntityView;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.common.stats.TbApiUsageReportClient;
import org.thingsboard.server.common.transport.util.JsonUtils;
import org.thingsboard.server.common.util.KvProtoUtil;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.entityview.EntityViewService;
import org.thingsboard.server.dao.event.EventService;
import org.thingsboard.server.dao.group.EntityGroupService;
import org.thingsboard.server.dao.integration.IntegrationService;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.exception.ThingsboardRuntimeException;
import org.thingsboard.server.gen.integration.AssetUplinkDataProto;
import org.thingsboard.server.gen.integration.DeviceUplinkDataProto;
import org.thingsboard.server.gen.integration.EntityViewDataProto;
import org.thingsboard.server.gen.integration.TbEventSource;
import org.thingsboard.server.gen.integration.TbIntegrationEventProto;
import org.thingsboard.server.gen.integration.TbIntegrationTsDataProto;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.common.TbRuleEngineProducerService;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.provider.TbQueueProducerProvider;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.converter.DataConverterService;
import org.thingsboard.server.service.executors.DbCallbackExecutorService;
import org.thingsboard.server.service.integration.DefaultPlatformIntegrationService;
import org.thingsboard.server.service.integration.IntegrationActivityKey;
import org.thingsboard.server.service.integration.IntegrationActivityManager;
import org.thingsboard.server.service.integration.IntegrationApiCallback;
import org.thingsboard.server.service.integration.IntegrationContextComponent;
import org.thingsboard.server.service.integration.PlatformIntegrationService;
import org.thingsboard.server.service.integration.RemoteIntegrationRpcService;
import org.thingsboard.server.service.profile.DefaultTbAssetProfileCache;
import org.thingsboard.server.service.profile.DefaultTbDeviceProfileCache;
import org.thingsboard.server.service.state.DeviceStateService;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;

/*
 * Exception performing whole class analysis ignored.
 */
@TbCoreComponent
@Service
public class DefaultPlatformIntegrationService
extends IntegrationActivityManager
implements PlatformIntegrationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultPlatformIntegrationService.class);
    private static final ReentrantLock entityCreationLock = new ReentrantLock();
    @Autowired
    private TbClusterService clusterService;
    @Autowired
    private TbServiceInfoProvider serviceInfoProvider;
    @Autowired
    private IntegrationService integrationService;
    @Autowired
    private DataConverterService dataConverterService;
    @Autowired
    protected IntegrationContextComponent contextComponent;
    @Autowired
    private EventService eventService;
    @Autowired
    @Lazy
    private TbQueueProducerProvider producerProvider;
    @Autowired
    private TbRuleEngineProducerService ruleEngineProducerService;
    @Autowired
    @Lazy
    private ActorSystemContext actorContext;
    @Autowired
    private TelemetrySubscriptionService telemetrySubscriptionService;
    @Autowired
    private AttributesService attributesService;
    @Autowired
    private RemoteIntegrationRpcService remoteIntegrationRpcService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private AssetService assetService;
    @Autowired
    private EntityViewService entityViewService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private RelationService relationService;
    @Autowired
    private DeviceStateService deviceStateService;
    @Autowired
    private EntityGroupService entityGroupService;
    @Autowired
    private DbCallbackExecutorService callbackExecutorService;
    @Autowired
    private TbApiUsageReportClient apiUsageReportClient;
    @Autowired
    private DefaultTbDeviceProfileCache deviceProfileCache;
    @Autowired
    private DefaultTbAssetProfileCache assetProfileCache;
    @Value(value="${integrations.reinit.enabled:false}")
    private boolean reinitEnabled;
    @Value(value="${integrations.reinit.frequency:3600000}")
    private long reinitFrequency;
    @Value(value="${integrations.statistics.enabled}")
    private boolean statisticsEnabled;
    @Value(value="${integrations.statistics.persist_frequency}")
    private long statisticsPersistFrequency;
    @Value(value="${integrations.allow_Local_network_hosts:true}")
    private boolean allowLocalNetworkHosts;
    private ExecutorService callbackExecutor;
    private final Gson gson = new Gson();
    private volatile Set<TopicPartitionInfo> myPartitions = ConcurrentHashMap.newKeySet();
    private boolean initialized;
    protected TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> integrationRuleEngineMsgProducer;

    @PostConstruct
    public void init() {
        super.init();
        this.integrationRuleEngineMsgProducer = this.producerProvider.getIntegrationRuleEngineMsgProducer();
        this.callbackExecutor = ThingsBoardExecutors.newWorkStealingPool((int)20, (String)"default-integration-callback");
    }

    @PreDestroy
    public void destroy() {
        if (this.callbackExecutor != null) {
            this.callbackExecutor.shutdownNow();
        }
    }

    public Runnable processUplinkData(AbstractIntegration integration, DeviceUplinkDataProto data, IntegrationCallback<Void> callback) {
        return this.processUplinkData(integration, integration.getId().getId(), data, callback);
    }

    public Runnable processUplinkData(AbstractIntegration integration, UUID sessionId, DeviceUplinkDataProto data, IntegrationCallback<Void> callback) {
        Device device = this.getOrCreateDevice(integration, data.getDeviceName(), data.getDeviceType(), data.getDeviceLabel(), data.getCustomerName(), data.getGroupName());
        TransportProtos.SessionInfoProto.Builder builder = TransportProtos.SessionInfoProto.newBuilder().setSessionIdMSB(sessionId.getMostSignificantBits()).setSessionIdLSB(sessionId.getLeastSignificantBits()).setTenantIdMSB(device.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(device.getTenantId().getId().getLeastSignificantBits()).setDeviceIdMSB(device.getId().getId().getMostSignificantBits()).setDeviceIdLSB(device.getId().getId().getLeastSignificantBits()).setDeviceName(device.getName()).setDeviceType(device.getType()).setDeviceProfileIdMSB(device.getDeviceProfileId().getId().getMostSignificantBits()).setDeviceProfileIdLSB(device.getDeviceProfileId().getId().getLeastSignificantBits());
        if (device.getCustomerId() != null && !device.getCustomerId().isNullUid()) {
            builder.setCustomerIdMSB(device.getCustomerId().getId().getMostSignificantBits());
            builder.setCustomerIdLSB(device.getCustomerId().getId().getLeastSignificantBits());
        }
        TransportProtos.SessionInfoProto sessionInfo = builder.build();
        return () -> {
            if (data.hasPostTelemetryMsg()) {
                this.process(sessionInfo, data.getPostTelemetryMsg(), callback);
            }
            if (data.hasPostAttributesMsg()) {
                this.process(sessionInfo, data.getPostAttributesMsg(), callback);
            }
        };
    }

    public Runnable processUplinkData(AbstractIntegration configuration, AssetUplinkDataProto data, IntegrationCallback<Void> callback) {
        Asset asset = this.getOrCreateAsset(configuration, data.getAssetName(), data.getAssetType(), data.getAssetLabel(), data.getCustomerName(), data.getGroupName());
        return () -> {
            if (data.hasPostTelemetryMsg()) {
                this.process(asset, data.getPostTelemetryMsg(), callback);
            }
            if (data.hasPostAttributesMsg()) {
                this.process(asset, data.getPostAttributesMsg(), callback);
            }
        };
    }

    public Runnable processUplinkData(AbstractIntegration integrationInfo, EntityViewDataProto data, IntegrationCallback<Void> callback) {
        Device device = this.getOrCreateDevice(integrationInfo, data.getDeviceName(), data.getDeviceType(), null, null, null);
        this.getOrCreateEntityView(integrationInfo, device, data);
        return () -> callback.onSuccess(null);
    }

    public void processUplinkData(AbstractIntegration info, TbMsg data, IntegrationApiCallback callback) {
        this.process(info.getTenantId(), data, (IntegrationCallback)callback);
    }

    public void processUplinkData(TbIntegrationEventProto data, IntegrationApiCallback callback) {
        TenantId tenantId = TenantId.fromUUID((UUID)new UUID(data.getTenantIdMSB(), data.getTenantIdLSB()));
        TbEventSource eventSource = data.getSource();
        IntegrationId entityid = null;
        switch (2.$SwitchMap$org$thingsboard$server$gen$integration$TbEventSource[eventSource.ordinal()]) {
            case 1: {
                Device device = this.deviceService.findDeviceByTenantIdAndName(tenantId, data.getDeviceName());
                if (device == null) break;
                entityid = device.getId();
                break;
            }
            case 2: {
                entityid = new IntegrationId(new UUID(data.getEventSourceIdMSB(), data.getEventSourceIdLSB()));
                break;
            }
            case 3: 
            case 4: {
                entityid = new ConverterId(new UUID(data.getEventSourceIdMSB(), data.getEventSourceIdLSB()));
            }
        }
        if (entityid != null) {
            this.saveEvent(tenantId, entityid, data, callback);
        } else {
            callback.onSuccess(null);
        }
    }

    public void processUplinkData(TbIntegrationTsDataProto data, IntegrationApiCallback integrationApiCallback) {
        TenantId tenantId = TenantId.fromUUID((UUID)new UUID(data.getTenantIdMSB(), data.getTenantIdLSB()));
        TbEventSource eventSource = data.getSource();
        IntegrationId entityid = switch (2.$SwitchMap$org$thingsboard$server$gen$integration$TbEventSource[eventSource.ordinal()]) {
            case 2 -> new IntegrationId(new UUID(data.getEntityIdMSB(), data.getEntityIdLSB()));
            case 3, 4 -> new ConverterId(new UUID(data.getEntityIdMSB(), data.getEntityIdLSB()));
            default -> throw new RuntimeException("Not supported!");
        };
        List statistics = KvProtoUtil.fromTsValueProtoList((List)data.getTsDataList());
        this.telemetrySubscriptionService.saveTimeseriesInternal(TimeseriesSaveRequest.builder().tenantId(tenantId).entityId((EntityId)entityid).entries(statistics).callback((FutureCallback)new /* Unavailable Anonymous Inner Class!! */).build());
    }

    private void saveEvent(TenantId tenantId, EntityId entityId, TbIntegrationEventProto proto, IntegrationApiCallback callback) {
        try {
            Event event = (Event)JavaSerDesUtil.decode((byte[])proto.getEvent().toByteArray());
            event.setTenantId(tenantId);
            event.setEntityId(entityId.getId());
            ListenableFuture saveEventFuture = this.eventService.saveAsync(event);
            if (entityId.getEntityType().equals((Object)EntityType.INTEGRATION) && event.getType().equals((Object)EventType.LC_EVENT)) {
                LifecycleEvent lcEvent = (LifecycleEvent)event;
                String key = "integration_status_" + event.getServiceId().toLowerCase();
                if (lcEvent.getLcEventType().equals("STARTED") || lcEvent.getLcEventType().equals("UPDATED")) {
                    ObjectNode value = JacksonUtil.newObjectNode();
                    if (lcEvent.isSuccess()) {
                        value.put("success", true);
                    } else {
                        value.put("success", false);
                        value.put("serviceId", lcEvent.getServiceId());
                        value.put("error", lcEvent.getError());
                    }
                    BaseAttributeKvEntry attr = new BaseAttributeKvEntry((KvEntry)new JsonDataEntry(key, JacksonUtil.toString((Object)value)), event.getCreatedTime());
                    saveEventFuture = Futures.transformAsync((ListenableFuture)saveEventFuture, arg_0 -> this.lambda$saveEvent$3(tenantId, entityId, (AttributeKvEntry)attr, arg_0), (Executor)MoreExecutors.directExecutor());
                } else if (lcEvent.getLcEventType().equals("STOPPED")) {
                    saveEventFuture = Futures.transformAsync((ListenableFuture)saveEventFuture, v -> {
                        this.attributesService.removeAll(tenantId, entityId, AttributeScope.SERVER_SCOPE, Collections.singletonList(key));
                        return null;
                    }, (Executor)MoreExecutors.directExecutor());
                }
            }
            DonAsynchron.withCallback((ListenableFuture)saveEventFuture, arg_0 -> ((IntegrationApiCallback)callback).onSuccess(arg_0), arg_0 -> ((IntegrationApiCallback)callback).onError(arg_0));
        }
        catch (Exception t) {
            log.error("[{}][{}][{}] Failed to save event!", new Object[]{tenantId, entityId, proto.getEvent(), t});
            callback.onError((Throwable)t);
            throw t;
        }
    }

    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.PostTelemetryMsg msg, IntegrationCallback<Void> callback) {
        TenantId tenantId = TenantId.fromUUID((UUID)new UUID(sessionInfo.getTenantIdMSB(), sessionInfo.getTenantIdLSB()));
        DeviceId deviceId = new DeviceId(new UUID(sessionInfo.getDeviceIdMSB(), sessionInfo.getDeviceIdLSB()));
        this.onActivity((Object)new IntegrationActivityKey(tenantId, deviceId), null, this.getCurrentTimeMillis());
        int dataPoints = 0;
        for (TransportProtos.TsKvListProto tsKv : msg.getTsKvListList()) {
            dataPoints += tsKv.getKvCount();
        }
        MsgPackCallback packCallback = new MsgPackCallback(this, Integer.valueOf(msg.getTsKvListCount()), (IntegrationCallback)new ApiStatsProxyCallback(this, tenantId, DefaultPlatformIntegrationService.getCustomerId((TransportProtos.SessionInfoProto)sessionInfo), dataPoints, callback));
        for (TransportProtos.TsKvListProto tsKv : msg.getTsKvListList()) {
            TbMsgMetaData metaData = new TbMsgMetaData();
            metaData.putValue("deviceName", sessionInfo.getDeviceName());
            metaData.putValue("deviceType", sessionInfo.getDeviceType());
            metaData.putValue("ts", "" + tsKv.getTs());
            JsonObject json = JsonUtils.getJsonObject((List)tsKv.getKvList());
            this.sendToRuleEngine(tenantId, deviceId, sessionInfo, json, metaData, TbMsgType.POST_TELEMETRY_REQUEST, (TbQueueCallback)packCallback);
        }
    }

    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.PostAttributeMsg msg, IntegrationCallback<Void> callback) {
        TenantId tenantId = TenantId.fromUUID((UUID)new UUID(sessionInfo.getTenantIdMSB(), sessionInfo.getTenantIdLSB()));
        DeviceId deviceId = new DeviceId(new UUID(sessionInfo.getDeviceIdMSB(), sessionInfo.getDeviceIdLSB()));
        this.onActivity((Object)new IntegrationActivityKey(tenantId, deviceId), null, this.getCurrentTimeMillis());
        JsonObject json = JsonUtils.getJsonObject((List)msg.getKvList());
        TbMsgMetaData metaData = new TbMsgMetaData();
        metaData.putValue("deviceName", sessionInfo.getDeviceName());
        metaData.putValue("deviceType", sessionInfo.getDeviceType());
        this.sendToRuleEngine(tenantId, deviceId, sessionInfo, json, metaData, TbMsgType.POST_ATTRIBUTES_REQUEST, (TbQueueCallback)new IntegrationTbQueueCallback(this, (IntegrationCallback)new ApiStatsProxyCallback(this, tenantId, DefaultPlatformIntegrationService.getCustomerId((TransportProtos.SessionInfoProto)sessionInfo), msg.getKvList().size(), callback)));
    }

    public void process(TenantId tenantId, TbMsg tbMsg, IntegrationCallback<Void> callback) {
        this.sendToRuleEngine(tenantId, tbMsg, (TbQueueCallback)new IntegrationTbQueueCallback(this, (IntegrationCallback)new ApiStatsProxyCallback(this, tenantId, tbMsg.getCustomerId(), 1, callback)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Device getOrCreateDevice(AbstractIntegration integration, String deviceName, String deviceType, String deviceLabel, String customerName, String groupName) {
        Device device = this.deviceService.findDeviceByTenantIdAndName(integration.getTenantId(), deviceName);
        if (device == null) {
            entityCreationLock.lock();
            try {
                Device device2 = this.processGetOrCreateDevice(integration, deviceName, deviceType, deviceLabel, customerName, groupName);
                return device2;
            }
            finally {
                entityCreationLock.unlock();
            }
        }
        return device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Asset getOrCreateAsset(AbstractIntegration integration, String assetName, String assetType, String assetLabel, String customerName, String groupName) {
        Asset asset = this.assetService.findAssetByTenantIdAndName(integration.getTenantId(), assetName);
        if (asset == null) {
            entityCreationLock.lock();
            try {
                Asset asset2 = this.processGetOrCreateAsset(integration, assetName, assetType, assetLabel, customerName, groupName);
                return asset2;
            }
            finally {
                entityCreationLock.unlock();
            }
        }
        return asset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityView getOrCreateEntityView(AbstractIntegration configuration, Device device, EntityViewDataProto proto) {
        String entityViewName = proto.getViewName();
        EntityView entityView = this.entityViewService.findEntityViewByTenantIdAndName(configuration.getTenantId(), entityViewName);
        if (entityView == null) {
            entityCreationLock.lock();
            try {
                entityView = this.entityViewService.findEntityViewByTenantIdAndName(configuration.getTenantId(), entityViewName);
                if (entityView == null) {
                    entityView = new EntityView();
                    entityView.setName(entityViewName);
                    entityView.setType(proto.getViewType());
                    entityView.setTenantId(configuration.getTenantId());
                    entityView.setEntityId((EntityId)device.getId());
                    TelemetryEntityView telemetryEntityView = new TelemetryEntityView();
                    telemetryEntityView.setTimeseries((List)proto.getTelemetryKeysList());
                    entityView.setKeys(telemetryEntityView);
                    entityView = this.entityViewService.saveEntityView(entityView);
                    this.createRelationFromIntegration(configuration, (EntityId)entityView.getId());
                }
            }
            finally {
                entityCreationLock.unlock();
            }
        }
        return entityView;
    }

    private Device processGetOrCreateDevice(AbstractIntegration integration, String deviceName, String deviceType, String deviceLabel, String customerName, String groupName) {
        Device device = this.deviceService.findDeviceByTenantIdAndName(integration.getTenantId(), deviceName);
        if (device == null) {
            if (!integration.isAllowCreateDevicesOrAssets().booleanValue()) {
                throw new ThingsboardRuntimeException("Creating devices is forbidden!", ThingsboardErrorCode.PERMISSION_DENIED);
            }
            device = new Device();
            device.setName(deviceName);
            device.setType(deviceType);
            device.setTenantId(integration.getTenantId());
            if (!StringUtils.isEmpty((String)deviceLabel)) {
                device.setLabel(deviceLabel);
            }
            if (!StringUtils.isEmpty((String)customerName)) {
                Customer customer = this.getOrCreateCustomer(integration, customerName);
                device.setCustomerId(customer.getId());
            }
            device = this.deviceService.saveDevice(device);
            if (!StringUtils.isEmpty((String)groupName)) {
                this.addEntityToEntityGroup(groupName, integration, (EntityId)device.getId(), device.getOwnerId(), device.getEntityType());
            }
            this.createRelationFromIntegration(integration, (EntityId)device.getId());
            this.pushDeviceCreatedEventToRuleEngine(integration, device);
        }
        return device;
    }

    private Asset processGetOrCreateAsset(AbstractIntegration integration, String assetName, String assetType, String assetLabel, String customerName, String groupName) {
        Asset asset = this.assetService.findAssetByTenantIdAndName(integration.getTenantId(), assetName);
        if (asset == null) {
            if (!integration.isAllowCreateDevicesOrAssets().booleanValue()) {
                throw new ThingsboardRuntimeException("Creating assets is forbidden!", ThingsboardErrorCode.PERMISSION_DENIED);
            }
            asset = new Asset();
            asset.setName(assetName);
            asset.setType(assetType);
            asset.setTenantId(integration.getTenantId());
            if (!StringUtils.isEmpty((String)assetLabel)) {
                asset.setLabel(assetLabel);
            }
            if (!StringUtils.isEmpty((String)customerName)) {
                Customer customer = this.getOrCreateCustomer(integration, customerName);
                asset.setCustomerId(customer.getId());
            }
            asset = this.assetService.saveAsset(asset);
            if (!StringUtils.isEmpty((String)groupName)) {
                this.addEntityToEntityGroup(groupName, integration, (EntityId)asset.getId(), asset.getOwnerId(), asset.getEntityType());
            }
            this.createRelationFromIntegration(integration, (EntityId)asset.getId());
            this.pushAssetCreatedEventToRuleEngine(integration, asset);
        }
        return asset;
    }

    private Customer getOrCreateCustomer(AbstractIntegration integration, String customerName) {
        Optional customerOptional = this.customerService.findCustomerByTenantIdAndTitle(integration.getTenantId(), customerName);
        Customer customer = customerOptional.isPresent() ? (Customer)customerOptional.get() : new Customer();
        return customer;
    }

    private void addEntityToEntityGroup(String groupName, AbstractIntegration integration, EntityId entityId, EntityId parentId, EntityType entityType) {
        TenantId tenantId = integration.getTenantId();
        ListenableFuture futureEntityGroup = this.entityGroupService.findEntityGroupByTypeAndNameAsync(tenantId, parentId, entityType, groupName);
        DonAsynchron.withCallback((ListenableFuture)futureEntityGroup, optionalEntityGroup -> {
            if (optionalEntityGroup.isPresent()) {
                EntityGroup entityGroup = optionalEntityGroup.orElseGet(() -> this.createEntityGroup(groupName, parentId, entityType, tenantId));
                this.pushEntityGroupCreatedEventToRuleEngine(integration, entityGroup);
                this.entityGroupService.addEntityToEntityGroup(tenantId, entityGroup.getId(), entityId);
            } else {
                log.warn("[{}][{}] Entity group [{}] not found! Please create group on the cloud and assign it to the edge first!", new Object[]{tenantId, parentId, groupName});
            }
        }, throwable -> log.warn("[{}][{}] Failed to find entity group: {}:{}", new Object[]{tenantId, parentId, entityType, groupName, throwable}), (Executor)this.callbackExecutorService);
    }

    private EntityGroup createEntityGroup(String entityGroupName, EntityId parentEntityId, EntityType entityType, TenantId tenantId) {
        EntityGroup entityGroup = new EntityGroup();
        entityGroup.setName(entityGroupName);
        entityGroup.setType(entityType);
        return this.entityGroupService.saveEntityGroup(tenantId, parentEntityId, entityGroup);
    }

    private void createRelationFromIntegration(AbstractIntegration integration, EntityId entityId) {
        EntityRelation relation = new EntityRelation();
        relation.setFrom((EntityId)integration.getId());
        relation.setTo(entityId);
        relation.setTypeGroup(RelationTypeGroup.COMMON);
        relation.setType("ManagedByIntegration");
        this.relationService.saveRelation(integration.getTenantId(), relation);
    }

    private void pushDeviceCreatedEventToRuleEngine(AbstractIntegration integration, Device device) {
        try {
            String queueName;
            RuleChainId ruleChainId;
            DeviceProfile deviceProfile = this.deviceProfileCache.find(device.getDeviceProfileId());
            if (deviceProfile == null) {
                ruleChainId = null;
                queueName = null;
            } else {
                ruleChainId = deviceProfile.getDefaultRuleChainId();
                queueName = deviceProfile.getDefaultQueueName();
            }
            JsonNode entityNode = JacksonUtil.valueToTree((Object)device);
            TbMsg tbMsg = TbMsg.newMsg().queueName(queueName).type(TbMsgType.ENTITY_CREATED).originator((EntityId)device.getId()).metaData(this.deviceActionTbMsgMetaData(integration, device)).data(JacksonUtil.toString((Object)entityNode)).ruleChainId(ruleChainId).build();
            this.process(device.getTenantId(), tbMsg, null);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Failed to push device action to rule engine: {}", new Object[]{device.getId(), TbMsgType.ENTITY_CREATED.name(), e});
        }
    }

    private void pushAssetCreatedEventToRuleEngine(AbstractIntegration integration, Asset asset) {
        try {
            String queueName;
            RuleChainId ruleChainId;
            AssetProfile assetProfile = this.assetProfileCache.find(asset.getAssetProfileId());
            if (assetProfile == null) {
                ruleChainId = null;
                queueName = null;
            } else {
                ruleChainId = assetProfile.getDefaultRuleChainId();
                queueName = assetProfile.getDefaultQueueName();
            }
            JsonNode entityNode = JacksonUtil.valueToTree((Object)asset);
            TbMsg tbMsg = TbMsg.newMsg().queueName(queueName).type(TbMsgType.ENTITY_CREATED).originator((EntityId)asset.getId()).customerId(asset.getCustomerId()).copyMetaData(this.assetActionTbMsgMetaData(integration, asset)).data(JacksonUtil.toString((Object)entityNode)).ruleChainId(ruleChainId).build();
            this.process(integration.getTenantId(), tbMsg, null);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Failed to push asset action to rule engine: {}", new Object[]{asset.getId(), TbMsgType.ENTITY_CREATED.name(), e});
        }
    }

    private void pushEntityGroupCreatedEventToRuleEngine(AbstractIntegration integration, EntityGroup entityGroup) {
        try {
            JsonNode entityNode = JacksonUtil.valueToTree((Object)entityGroup);
            TbMsg tbMsg = TbMsg.newMsg().type(TbMsgType.ENTITY_CREATED).originator((EntityId)entityGroup.getId()).copyMetaData(this.getTbMsgMetaData(integration)).data(JacksonUtil.toString((Object)entityNode)).build();
            this.process(integration.getTenantId(), tbMsg, null);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Failed to push entityGroup action to rule engine: {}", new Object[]{entityGroup.getId(), TbMsgType.ENTITY_CREATED.name(), e});
        }
    }

    private void pushCustomerCreatedEventToRuleEngine(AbstractIntegration integration, Customer customer) {
        try {
            JsonNode entityNode = JacksonUtil.valueToTree((Object)customer);
            TbMsg tbMsg = TbMsg.newMsg().type(TbMsgType.ENTITY_CREATED).originator((EntityId)customer.getId()).customerId(customer.getParentCustomerId()).copyMetaData(this.getTbMsgMetaData(integration)).data(JacksonUtil.toString((Object)entityNode)).build();
            this.process(customer.getTenantId(), tbMsg, null);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Failed to push customer action to rule engine: {}", new Object[]{customer.getId(), TbMsgType.ENTITY_CREATED.name(), e});
        }
    }

    private TbMsgMetaData deviceActionTbMsgMetaData(AbstractIntegration integration, Device device) {
        return this.getActionTbMsgMetaData(integration, device.getCustomerId());
    }

    private TbMsgMetaData assetActionTbMsgMetaData(AbstractIntegration integration, Asset asset) {
        return this.getActionTbMsgMetaData(integration, asset.getCustomerId());
    }

    private TbMsgMetaData getActionTbMsgMetaData(AbstractIntegration integration, CustomerId customerId) {
        TbMsgMetaData metaData = this.getTbMsgMetaData(integration);
        if (customerId != null && !customerId.isNullUid()) {
            metaData.putValue("customerId", customerId.toString());
        }
        return metaData;
    }

    private TbMsgMetaData getTbMsgMetaData(AbstractIntegration integration) {
        TbMsgMetaData metaData = new TbMsgMetaData();
        metaData.putValue("integrationId", integration.getId().toString());
        metaData.putValue("integrationName", integration.getName());
        return metaData;
    }

    private void process(Asset asset, TransportProtos.PostTelemetryMsg msg, IntegrationCallback<Void> callback) {
        int dataPoints = 0;
        for (TransportProtos.TsKvListProto tsKv : msg.getTsKvListList()) {
            dataPoints += tsKv.getKvCount();
        }
        MsgPackCallback packCallback = new MsgPackCallback(this, Integer.valueOf(msg.getTsKvListCount()), (IntegrationCallback)new ApiStatsProxyCallback(this, asset.getTenantId(), asset.getCustomerId(), dataPoints, callback));
        for (TransportProtos.TsKvListProto tsKv : msg.getTsKvListList()) {
            TbMsgMetaData metaData = new TbMsgMetaData();
            metaData.putValue("assetName", asset.getName());
            metaData.putValue("assetType", asset.getType());
            metaData.putValue("ts", "" + tsKv.getTs());
            JsonObject json = JsonUtils.getJsonObject((List)tsKv.getKvList());
            this.sendToRuleEngine(asset.getTenantId(), asset.getId(), asset.getAssetProfileId(), asset.getCustomerId(), json, metaData, TbMsgType.POST_TELEMETRY_REQUEST, (TbQueueCallback)packCallback);
        }
    }

    private void process(Asset asset, TransportProtos.PostAttributeMsg msg, IntegrationCallback<Void> callback) {
        JsonObject json = JsonUtils.getJsonObject((List)msg.getKvList());
        TbMsgMetaData metaData = new TbMsgMetaData();
        metaData.putValue("assetName", asset.getName());
        metaData.putValue("assetType", asset.getType());
        this.sendToRuleEngine(asset.getTenantId(), asset.getId(), asset.getAssetProfileId(), asset.getCustomerId(), json, metaData, TbMsgType.POST_ATTRIBUTES_REQUEST, (TbQueueCallback)new IntegrationTbQueueCallback(this, (IntegrationCallback)new ApiStatsProxyCallback(this, asset.getTenantId(), asset.getCustomerId(), msg.getKvList().size(), callback)));
    }

    void sendToRuleEngine(TenantId tenantId, DeviceId deviceId, TransportProtos.SessionInfoProto sessionInfo, JsonObject json, TbMsgMetaData metaData, TbMsgType msgType, TbQueueCallback callback) {
        String queueName;
        RuleChainId ruleChainId;
        DeviceProfileId deviceProfileId = new DeviceProfileId(new UUID(sessionInfo.getDeviceProfileIdMSB(), sessionInfo.getDeviceProfileIdLSB()));
        DeviceProfile deviceProfile = this.deviceProfileCache.get(tenantId, deviceProfileId);
        if (deviceProfile == null) {
            log.warn("[{}] Device profile is null!", (Object)deviceProfileId);
            ruleChainId = null;
            queueName = null;
        } else {
            ruleChainId = deviceProfile.getDefaultRuleChainId();
            queueName = deviceProfile.getDefaultQueueName();
        }
        TbMsg tbMsg = TbMsg.newMsg().queueName(queueName).type(msgType).originator((EntityId)deviceId).customerId(DefaultPlatformIntegrationService.getCustomerId((TransportProtos.SessionInfoProto)sessionInfo)).copyMetaData(metaData).data(this.gson.toJson((JsonElement)json)).ruleChainId(ruleChainId).build();
        this.sendToRuleEngine(tenantId, tbMsg, callback);
    }

    private void sendToRuleEngine(TenantId tenantId, AssetId assetId, AssetProfileId assetProfileId, CustomerId customerId, JsonObject json, TbMsgMetaData metaData, TbMsgType msgType, TbQueueCallback callback) {
        String queueName;
        RuleChainId ruleChainId;
        AssetProfile assetProfile = this.assetProfileCache.get(tenantId, assetProfileId);
        if (assetProfile == null) {
            log.warn("[{}] Asset profile is null!", (Object)assetProfileId);
            ruleChainId = null;
            queueName = null;
        } else {
            ruleChainId = assetProfile.getDefaultRuleChainId();
            queueName = assetProfile.getDefaultQueueName();
        }
        TbMsg tbMsg = TbMsg.newMsg().queueName(queueName).type(msgType).originator((EntityId)assetId).customerId(customerId).copyMetaData(metaData).data(this.gson.toJson((JsonElement)json)).ruleChainId(ruleChainId).build();
        this.sendToRuleEngine(tenantId, tbMsg, callback);
    }

    private void sendToRuleEngine(TenantId tenantId, TbMsg tbMsg, TbQueueCallback callback) {
        this.ruleEngineProducerService.sendToRuleEngine(this.integrationRuleEngineMsgProducer, tenantId, tbMsg, callback);
    }

    protected UUID getRoutingKey(TransportProtos.SessionInfoProto sessionInfo) {
        return new UUID(sessionInfo.getDeviceIdMSB(), sessionInfo.getDeviceIdLSB());
    }

    protected TenantId getTenantId(TransportProtos.SessionInfoProto sessionInfo) {
        return TenantId.fromUUID((UUID)new UUID(sessionInfo.getTenantIdMSB(), sessionInfo.getTenantIdLSB()));
    }

    protected DeviceId getDeviceId(TransportProtos.SessionInfoProto sessionInfo) {
        return new DeviceId(new UUID(sessionInfo.getDeviceIdMSB(), sessionInfo.getDeviceIdLSB()));
    }

    private static CustomerId getCustomerId(TransportProtos.SessionInfoProto sessionInfo) {
        CustomerId customerId = sessionInfo.getCustomerIdMSB() > 0L && sessionInfo.getCustomerIdLSB() > 0L ? new CustomerId(new UUID(sessionInfo.getCustomerIdMSB(), sessionInfo.getCustomerIdLSB())) : null;
        return customerId;
    }

    @Generated
    public DefaultPlatformIntegrationService() {
    }

    @Generated
    public TbClusterService getClusterService() {
        return this.clusterService;
    }

    @Generated
    public TbServiceInfoProvider getServiceInfoProvider() {
        return this.serviceInfoProvider;
    }

    @Generated
    public IntegrationService getIntegrationService() {
        return this.integrationService;
    }

    @Generated
    public DataConverterService getDataConverterService() {
        return this.dataConverterService;
    }

    @Generated
    public IntegrationContextComponent getContextComponent() {
        return this.contextComponent;
    }

    @Generated
    public EventService getEventService() {
        return this.eventService;
    }

    @Lazy
    @Generated
    public TbQueueProducerProvider getProducerProvider() {
        return this.producerProvider;
    }

    @Generated
    public TbRuleEngineProducerService getRuleEngineProducerService() {
        return this.ruleEngineProducerService;
    }

    @Lazy
    @Generated
    public ActorSystemContext getActorContext() {
        return this.actorContext;
    }

    @Generated
    public TelemetrySubscriptionService getTelemetrySubscriptionService() {
        return this.telemetrySubscriptionService;
    }

    @Generated
    public AttributesService getAttributesService() {
        return this.attributesService;
    }

    @Generated
    public RemoteIntegrationRpcService getRemoteIntegrationRpcService() {
        return this.remoteIntegrationRpcService;
    }

    @Generated
    public DeviceService getDeviceService() {
        return this.deviceService;
    }

    @Generated
    public AssetService getAssetService() {
        return this.assetService;
    }

    @Generated
    public EntityViewService getEntityViewService() {
        return this.entityViewService;
    }

    @Generated
    public CustomerService getCustomerService() {
        return this.customerService;
    }

    @Generated
    public RelationService getRelationService() {
        return this.relationService;
    }

    @Generated
    public DeviceStateService getDeviceStateService() {
        return this.deviceStateService;
    }

    @Generated
    public EntityGroupService getEntityGroupService() {
        return this.entityGroupService;
    }

    @Generated
    public DbCallbackExecutorService getCallbackExecutorService() {
        return this.callbackExecutorService;
    }

    @Generated
    public TbApiUsageReportClient getApiUsageReportClient() {
        return this.apiUsageReportClient;
    }

    @Generated
    public DefaultTbDeviceProfileCache getDeviceProfileCache() {
        return this.deviceProfileCache;
    }

    @Generated
    public DefaultTbAssetProfileCache getAssetProfileCache() {
        return this.assetProfileCache;
    }

    @Generated
    public boolean isReinitEnabled() {
        return this.reinitEnabled;
    }

    @Generated
    public long getReinitFrequency() {
        return this.reinitFrequency;
    }

    @Generated
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Generated
    public long getStatisticsPersistFrequency() {
        return this.statisticsPersistFrequency;
    }

    @Generated
    public boolean isAllowLocalNetworkHosts() {
        return this.allowLocalNetworkHosts;
    }

    @Generated
    public ExecutorService getCallbackExecutor() {
        return this.callbackExecutor;
    }

    @Generated
    public Gson getGson() {
        return this.gson;
    }

    @Generated
    public Set<TopicPartitionInfo> getMyPartitions() {
        return this.myPartitions;
    }

    @Generated
    public boolean isInitialized() {
        return this.initialized;
    }

    @Generated
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> getIntegrationRuleEngineMsgProducer() {
        return this.integrationRuleEngineMsgProducer;
    }

    @Generated
    public void setClusterService(TbClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @Generated
    public void setServiceInfoProvider(TbServiceInfoProvider serviceInfoProvider) {
        this.serviceInfoProvider = serviceInfoProvider;
    }

    @Generated
    public void setIntegrationService(IntegrationService integrationService) {
        this.integrationService = integrationService;
    }

    @Generated
    public void setDataConverterService(DataConverterService dataConverterService) {
        this.dataConverterService = dataConverterService;
    }

    @Generated
    public void setContextComponent(IntegrationContextComponent contextComponent) {
        this.contextComponent = contextComponent;
    }

    @Generated
    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    @Generated
    public void setProducerProvider(@Lazy TbQueueProducerProvider producerProvider) {
        this.producerProvider = producerProvider;
    }

    @Generated
    public void setRuleEngineProducerService(TbRuleEngineProducerService ruleEngineProducerService) {
        this.ruleEngineProducerService = ruleEngineProducerService;
    }

    @Generated
    public void setActorContext(@Lazy ActorSystemContext actorContext) {
        this.actorContext = actorContext;
    }

    @Generated
    public void setTelemetrySubscriptionService(TelemetrySubscriptionService telemetrySubscriptionService) {
        this.telemetrySubscriptionService = telemetrySubscriptionService;
    }

    @Generated
    public void setAttributesService(AttributesService attributesService) {
        this.attributesService = attributesService;
    }

    @Generated
    public void setRemoteIntegrationRpcService(RemoteIntegrationRpcService remoteIntegrationRpcService) {
        this.remoteIntegrationRpcService = remoteIntegrationRpcService;
    }

    @Generated
    public void setDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    @Generated
    public void setAssetService(AssetService assetService) {
        this.assetService = assetService;
    }

    @Generated
    public void setEntityViewService(EntityViewService entityViewService) {
        this.entityViewService = entityViewService;
    }

    @Generated
    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    @Generated
    public void setRelationService(RelationService relationService) {
        this.relationService = relationService;
    }

    @Generated
    public void setDeviceStateService(DeviceStateService deviceStateService) {
        this.deviceStateService = deviceStateService;
    }

    @Generated
    public void setEntityGroupService(EntityGroupService entityGroupService) {
        this.entityGroupService = entityGroupService;
    }

    @Generated
    public void setCallbackExecutorService(DbCallbackExecutorService callbackExecutorService) {
        this.callbackExecutorService = callbackExecutorService;
    }

    @Generated
    public void setApiUsageReportClient(TbApiUsageReportClient apiUsageReportClient) {
        this.apiUsageReportClient = apiUsageReportClient;
    }

    @Generated
    public void setDeviceProfileCache(DefaultTbDeviceProfileCache deviceProfileCache) {
        this.deviceProfileCache = deviceProfileCache;
    }

    @Generated
    public void setAssetProfileCache(DefaultTbAssetProfileCache assetProfileCache) {
        this.assetProfileCache = assetProfileCache;
    }

    @Generated
    public void setReinitEnabled(boolean reinitEnabled) {
        this.reinitEnabled = reinitEnabled;
    }

    @Generated
    public void setReinitFrequency(long reinitFrequency) {
        this.reinitFrequency = reinitFrequency;
    }

    @Generated
    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    @Generated
    public void setStatisticsPersistFrequency(long statisticsPersistFrequency) {
        this.statisticsPersistFrequency = statisticsPersistFrequency;
    }

    @Generated
    public void setAllowLocalNetworkHosts(boolean allowLocalNetworkHosts) {
        this.allowLocalNetworkHosts = allowLocalNetworkHosts;
    }

    @Generated
    public void setCallbackExecutor(ExecutorService callbackExecutor) {
        this.callbackExecutor = callbackExecutor;
    }

    @Generated
    public void setMyPartitions(Set<TopicPartitionInfo> myPartitions) {
        this.myPartitions = myPartitions;
    }

    @Generated
    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Generated
    public void setIntegrationRuleEngineMsgProducer(TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> integrationRuleEngineMsgProducer) {
        this.integrationRuleEngineMsgProducer = integrationRuleEngineMsgProducer;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultPlatformIntegrationService)) {
            return false;
        }
        DefaultPlatformIntegrationService other = (DefaultPlatformIntegrationService)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isReinitEnabled() != other.isReinitEnabled()) {
            return false;
        }
        if (this.getReinitFrequency() != other.getReinitFrequency()) {
            return false;
        }
        if (this.isStatisticsEnabled() != other.isStatisticsEnabled()) {
            return false;
        }
        if (this.getStatisticsPersistFrequency() != other.getStatisticsPersistFrequency()) {
            return false;
        }
        if (this.isAllowLocalNetworkHosts() != other.isAllowLocalNetworkHosts()) {
            return false;
        }
        if (this.isInitialized() != other.isInitialized()) {
            return false;
        }
        TbClusterService this$clusterService = this.getClusterService();
        TbClusterService other$clusterService = other.getClusterService();
        if (this$clusterService == null ? other$clusterService != null : !this$clusterService.equals(other$clusterService)) {
            return false;
        }
        TbServiceInfoProvider this$serviceInfoProvider = this.getServiceInfoProvider();
        TbServiceInfoProvider other$serviceInfoProvider = other.getServiceInfoProvider();
        if (this$serviceInfoProvider == null ? other$serviceInfoProvider != null : !this$serviceInfoProvider.equals(other$serviceInfoProvider)) {
            return false;
        }
        IntegrationService this$integrationService = this.getIntegrationService();
        IntegrationService other$integrationService = other.getIntegrationService();
        if (this$integrationService == null ? other$integrationService != null : !this$integrationService.equals(other$integrationService)) {
            return false;
        }
        DataConverterService this$dataConverterService = this.getDataConverterService();
        DataConverterService other$dataConverterService = other.getDataConverterService();
        if (this$dataConverterService == null ? other$dataConverterService != null : !this$dataConverterService.equals(other$dataConverterService)) {
            return false;
        }
        IntegrationContextComponent this$contextComponent = this.getContextComponent();
        IntegrationContextComponent other$contextComponent = other.getContextComponent();
        if (this$contextComponent == null ? other$contextComponent != null : !this$contextComponent.equals(other$contextComponent)) {
            return false;
        }
        EventService this$eventService = this.getEventService();
        EventService other$eventService = other.getEventService();
        if (this$eventService == null ? other$eventService != null : !this$eventService.equals(other$eventService)) {
            return false;
        }
        TbQueueProducerProvider this$producerProvider = this.getProducerProvider();
        TbQueueProducerProvider other$producerProvider = other.getProducerProvider();
        if (this$producerProvider == null ? other$producerProvider != null : !this$producerProvider.equals(other$producerProvider)) {
            return false;
        }
        TbRuleEngineProducerService this$ruleEngineProducerService = this.getRuleEngineProducerService();
        TbRuleEngineProducerService other$ruleEngineProducerService = other.getRuleEngineProducerService();
        if (this$ruleEngineProducerService == null ? other$ruleEngineProducerService != null : !this$ruleEngineProducerService.equals(other$ruleEngineProducerService)) {
            return false;
        }
        ActorSystemContext this$actorContext = this.getActorContext();
        ActorSystemContext other$actorContext = other.getActorContext();
        if (this$actorContext == null ? other$actorContext != null : !this$actorContext.equals(other$actorContext)) {
            return false;
        }
        TelemetrySubscriptionService this$telemetrySubscriptionService = this.getTelemetrySubscriptionService();
        TelemetrySubscriptionService other$telemetrySubscriptionService = other.getTelemetrySubscriptionService();
        if (this$telemetrySubscriptionService == null ? other$telemetrySubscriptionService != null : !this$telemetrySubscriptionService.equals(other$telemetrySubscriptionService)) {
            return false;
        }
        AttributesService this$attributesService = this.getAttributesService();
        AttributesService other$attributesService = other.getAttributesService();
        if (this$attributesService == null ? other$attributesService != null : !this$attributesService.equals(other$attributesService)) {
            return false;
        }
        RemoteIntegrationRpcService this$remoteIntegrationRpcService = this.getRemoteIntegrationRpcService();
        RemoteIntegrationRpcService other$remoteIntegrationRpcService = other.getRemoteIntegrationRpcService();
        if (this$remoteIntegrationRpcService == null ? other$remoteIntegrationRpcService != null : !this$remoteIntegrationRpcService.equals(other$remoteIntegrationRpcService)) {
            return false;
        }
        DeviceService this$deviceService = this.getDeviceService();
        DeviceService other$deviceService = other.getDeviceService();
        if (this$deviceService == null ? other$deviceService != null : !this$deviceService.equals(other$deviceService)) {
            return false;
        }
        AssetService this$assetService = this.getAssetService();
        AssetService other$assetService = other.getAssetService();
        if (this$assetService == null ? other$assetService != null : !this$assetService.equals(other$assetService)) {
            return false;
        }
        EntityViewService this$entityViewService = this.getEntityViewService();
        EntityViewService other$entityViewService = other.getEntityViewService();
        if (this$entityViewService == null ? other$entityViewService != null : !this$entityViewService.equals(other$entityViewService)) {
            return false;
        }
        CustomerService this$customerService = this.getCustomerService();
        CustomerService other$customerService = other.getCustomerService();
        if (this$customerService == null ? other$customerService != null : !this$customerService.equals(other$customerService)) {
            return false;
        }
        RelationService this$relationService = this.getRelationService();
        RelationService other$relationService = other.getRelationService();
        if (this$relationService == null ? other$relationService != null : !this$relationService.equals(other$relationService)) {
            return false;
        }
        DeviceStateService this$deviceStateService = this.getDeviceStateService();
        DeviceStateService other$deviceStateService = other.getDeviceStateService();
        if (this$deviceStateService == null ? other$deviceStateService != null : !this$deviceStateService.equals(other$deviceStateService)) {
            return false;
        }
        EntityGroupService this$entityGroupService = this.getEntityGroupService();
        EntityGroupService other$entityGroupService = other.getEntityGroupService();
        if (this$entityGroupService == null ? other$entityGroupService != null : !this$entityGroupService.equals(other$entityGroupService)) {
            return false;
        }
        DbCallbackExecutorService this$callbackExecutorService = this.getCallbackExecutorService();
        DbCallbackExecutorService other$callbackExecutorService = other.getCallbackExecutorService();
        if (this$callbackExecutorService == null ? other$callbackExecutorService != null : !this$callbackExecutorService.equals(other$callbackExecutorService)) {
            return false;
        }
        TbApiUsageReportClient this$apiUsageReportClient = this.getApiUsageReportClient();
        TbApiUsageReportClient other$apiUsageReportClient = other.getApiUsageReportClient();
        if (this$apiUsageReportClient == null ? other$apiUsageReportClient != null : !this$apiUsageReportClient.equals(other$apiUsageReportClient)) {
            return false;
        }
        DefaultTbDeviceProfileCache this$deviceProfileCache = this.getDeviceProfileCache();
        DefaultTbDeviceProfileCache other$deviceProfileCache = other.getDeviceProfileCache();
        if (this$deviceProfileCache == null ? other$deviceProfileCache != null : !this$deviceProfileCache.equals(other$deviceProfileCache)) {
            return false;
        }
        DefaultTbAssetProfileCache this$assetProfileCache = this.getAssetProfileCache();
        DefaultTbAssetProfileCache other$assetProfileCache = other.getAssetProfileCache();
        if (this$assetProfileCache == null ? other$assetProfileCache != null : !this$assetProfileCache.equals(other$assetProfileCache)) {
            return false;
        }
        ExecutorService this$callbackExecutor = this.getCallbackExecutor();
        ExecutorService other$callbackExecutor = other.getCallbackExecutor();
        if (this$callbackExecutor == null ? other$callbackExecutor != null : !this$callbackExecutor.equals(other$callbackExecutor)) {
            return false;
        }
        Gson this$gson = this.getGson();
        Gson other$gson = other.getGson();
        if (this$gson == null ? other$gson != null : !this$gson.equals(other$gson)) {
            return false;
        }
        Set this$myPartitions = this.getMyPartitions();
        Set other$myPartitions = other.getMyPartitions();
        if (this$myPartitions == null ? other$myPartitions != null : !((Object)this$myPartitions).equals(other$myPartitions)) {
            return false;
        }
        TbQueueProducer this$integrationRuleEngineMsgProducer = this.getIntegrationRuleEngineMsgProducer();
        TbQueueProducer other$integrationRuleEngineMsgProducer = other.getIntegrationRuleEngineMsgProducer();
        return !(this$integrationRuleEngineMsgProducer == null ? other$integrationRuleEngineMsgProducer != null : !this$integrationRuleEngineMsgProducer.equals(other$integrationRuleEngineMsgProducer));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultPlatformIntegrationService;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReinitEnabled() ? 79 : 97);
        long $reinitFrequency = this.getReinitFrequency();
        result = result * 59 + (int)($reinitFrequency >>> 32 ^ $reinitFrequency);
        result = result * 59 + (this.isStatisticsEnabled() ? 79 : 97);
        long $statisticsPersistFrequency = this.getStatisticsPersistFrequency();
        result = result * 59 + (int)($statisticsPersistFrequency >>> 32 ^ $statisticsPersistFrequency);
        result = result * 59 + (this.isAllowLocalNetworkHosts() ? 79 : 97);
        result = result * 59 + (this.isInitialized() ? 79 : 97);
        TbClusterService $clusterService = this.getClusterService();
        result = result * 59 + ($clusterService == null ? 43 : $clusterService.hashCode());
        TbServiceInfoProvider $serviceInfoProvider = this.getServiceInfoProvider();
        result = result * 59 + ($serviceInfoProvider == null ? 43 : $serviceInfoProvider.hashCode());
        IntegrationService $integrationService = this.getIntegrationService();
        result = result * 59 + ($integrationService == null ? 43 : $integrationService.hashCode());
        DataConverterService $dataConverterService = this.getDataConverterService();
        result = result * 59 + ($dataConverterService == null ? 43 : $dataConverterService.hashCode());
        IntegrationContextComponent $contextComponent = this.getContextComponent();
        result = result * 59 + ($contextComponent == null ? 43 : $contextComponent.hashCode());
        EventService $eventService = this.getEventService();
        result = result * 59 + ($eventService == null ? 43 : $eventService.hashCode());
        TbQueueProducerProvider $producerProvider = this.getProducerProvider();
        result = result * 59 + ($producerProvider == null ? 43 : $producerProvider.hashCode());
        TbRuleEngineProducerService $ruleEngineProducerService = this.getRuleEngineProducerService();
        result = result * 59 + ($ruleEngineProducerService == null ? 43 : $ruleEngineProducerService.hashCode());
        ActorSystemContext $actorContext = this.getActorContext();
        result = result * 59 + ($actorContext == null ? 43 : $actorContext.hashCode());
        TelemetrySubscriptionService $telemetrySubscriptionService = this.getTelemetrySubscriptionService();
        result = result * 59 + ($telemetrySubscriptionService == null ? 43 : $telemetrySubscriptionService.hashCode());
        AttributesService $attributesService = this.getAttributesService();
        result = result * 59 + ($attributesService == null ? 43 : $attributesService.hashCode());
        RemoteIntegrationRpcService $remoteIntegrationRpcService = this.getRemoteIntegrationRpcService();
        result = result * 59 + ($remoteIntegrationRpcService == null ? 43 : $remoteIntegrationRpcService.hashCode());
        DeviceService $deviceService = this.getDeviceService();
        result = result * 59 + ($deviceService == null ? 43 : $deviceService.hashCode());
        AssetService $assetService = this.getAssetService();
        result = result * 59 + ($assetService == null ? 43 : $assetService.hashCode());
        EntityViewService $entityViewService = this.getEntityViewService();
        result = result * 59 + ($entityViewService == null ? 43 : $entityViewService.hashCode());
        CustomerService $customerService = this.getCustomerService();
        result = result * 59 + ($customerService == null ? 43 : $customerService.hashCode());
        RelationService $relationService = this.getRelationService();
        result = result * 59 + ($relationService == null ? 43 : $relationService.hashCode());
        DeviceStateService $deviceStateService = this.getDeviceStateService();
        result = result * 59 + ($deviceStateService == null ? 43 : $deviceStateService.hashCode());
        EntityGroupService $entityGroupService = this.getEntityGroupService();
        result = result * 59 + ($entityGroupService == null ? 43 : $entityGroupService.hashCode());
        DbCallbackExecutorService $callbackExecutorService = this.getCallbackExecutorService();
        result = result * 59 + ($callbackExecutorService == null ? 43 : $callbackExecutorService.hashCode());
        TbApiUsageReportClient $apiUsageReportClient = this.getApiUsageReportClient();
        result = result * 59 + ($apiUsageReportClient == null ? 43 : $apiUsageReportClient.hashCode());
        DefaultTbDeviceProfileCache $deviceProfileCache = this.getDeviceProfileCache();
        result = result * 59 + ($deviceProfileCache == null ? 43 : $deviceProfileCache.hashCode());
        DefaultTbAssetProfileCache $assetProfileCache = this.getAssetProfileCache();
        result = result * 59 + ($assetProfileCache == null ? 43 : $assetProfileCache.hashCode());
        ExecutorService $callbackExecutor = this.getCallbackExecutor();
        result = result * 59 + ($callbackExecutor == null ? 43 : $callbackExecutor.hashCode());
        Gson $gson = this.getGson();
        result = result * 59 + ($gson == null ? 43 : $gson.hashCode());
        Set $myPartitions = this.getMyPartitions();
        result = result * 59 + ($myPartitions == null ? 43 : ((Object)$myPartitions).hashCode());
        TbQueueProducer $integrationRuleEngineMsgProducer = this.getIntegrationRuleEngineMsgProducer();
        result = result * 59 + ($integrationRuleEngineMsgProducer == null ? 43 : $integrationRuleEngineMsgProducer.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DefaultPlatformIntegrationService(clusterService=" + String.valueOf(this.getClusterService()) + ", serviceInfoProvider=" + String.valueOf(this.getServiceInfoProvider()) + ", integrationService=" + String.valueOf(this.getIntegrationService()) + ", dataConverterService=" + String.valueOf(this.getDataConverterService()) + ", contextComponent=" + String.valueOf(this.getContextComponent()) + ", eventService=" + String.valueOf(this.getEventService()) + ", producerProvider=" + String.valueOf(this.getProducerProvider()) + ", ruleEngineProducerService=" + String.valueOf(this.getRuleEngineProducerService()) + ", actorContext=" + String.valueOf(this.getActorContext()) + ", telemetrySubscriptionService=" + String.valueOf(this.getTelemetrySubscriptionService()) + ", attributesService=" + String.valueOf(this.getAttributesService()) + ", remoteIntegrationRpcService=" + String.valueOf(this.getRemoteIntegrationRpcService()) + ", deviceService=" + String.valueOf(this.getDeviceService()) + ", assetService=" + String.valueOf(this.getAssetService()) + ", entityViewService=" + String.valueOf(this.getEntityViewService()) + ", customerService=" + String.valueOf(this.getCustomerService()) + ", relationService=" + String.valueOf(this.getRelationService()) + ", deviceStateService=" + String.valueOf(this.getDeviceStateService()) + ", entityGroupService=" + String.valueOf(this.getEntityGroupService()) + ", callbackExecutorService=" + String.valueOf(this.getCallbackExecutorService()) + ", apiUsageReportClient=" + String.valueOf(this.getApiUsageReportClient()) + ", deviceProfileCache=" + String.valueOf(this.getDeviceProfileCache()) + ", assetProfileCache=" + String.valueOf(this.getAssetProfileCache()) + ", reinitEnabled=" + this.isReinitEnabled() + ", reinitFrequency=" + this.getReinitFrequency() + ", statisticsEnabled=" + this.isStatisticsEnabled() + ", statisticsPersistFrequency=" + this.getStatisticsPersistFrequency() + ", allowLocalNetworkHosts=" + this.isAllowLocalNetworkHosts() + ", callbackExecutor=" + String.valueOf(this.getCallbackExecutor()) + ", gson=" + String.valueOf(this.getGson()) + ", myPartitions=" + String.valueOf(this.getMyPartitions()) + ", initialized=" + this.isInitialized() + ", integrationRuleEngineMsgProducer=" + String.valueOf(this.getIntegrationRuleEngineMsgProducer()) + ")";
    }

    private /* synthetic */ ListenableFuture lambda$saveEvent$3(TenantId tenantId, EntityId entityId, AttributeKvEntry attr, Void v) throws Exception {
        this.attributesService.save(tenantId, entityId, AttributeScope.SERVER_SCOPE, Collections.singletonList(attr));
        return null;
    }
}

