/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install.update;

import java.beans.ConstructorProperties;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.trendz.TrendzConfiguration;
import org.thingsboard.server.common.data.trendz.TrendzSettings;
import org.thingsboard.server.common.data.trendz.TrendzSynchronizationResult;
import org.thingsboard.server.common.data.trendz.TrendzSynchronizationResultType;
import org.thingsboard.server.common.data.trendz.TrendzSynchronizationStatus;
import org.thingsboard.server.dao.dashboard.DashboardDao;
import org.thingsboard.server.dao.resource.TbResourceDao;
import org.thingsboard.server.dao.service.Validator;
import org.thingsboard.server.dao.widget.WidgetTypeDao;

@Profile(value={"install"})
@Component
public class TrendzUpdater {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrendzUpdater.class);
    private final DashboardDao dashboardDao;
    private final WidgetTypeDao widgetTypeDao;
    private final TbResourceDao tbResourceDao;

    public void labelWidgetTypesAsDeprecatedByFqns(Set<String> fqns) {
        if (fqns.isEmpty()) {
            return;
        }
        fqns.forEach(fqn -> Validator.validateString((String)fqn, f -> "Incorrect fqn " + f));
        this.widgetTypeDao.labelWidgetTypesAsDeprecatedByFqns(fqns);
    }

    public Optional<URL> findUniqueTrendzBaseUrlFromWidgetTypes(Set<String> fqns) throws MalformedURLException {
        if (fqns.isEmpty()) {
            return Optional.empty();
        }
        fqns.forEach(fqn -> Validator.validateString((String)fqn, f -> "Incorrect fqn " + f));
        Set urls = this.widgetTypeDao.findUniqueExternalHostsInAnalyticsBundleByFqns(fqns);
        if (urls.size() != 1) {
            return Optional.empty();
        }
        String urlString = (String)urls.iterator().next();
        URL url = new URL(urlString);
        return Optional.of(url);
    }

    public void replaceWidgetTypeFullFqn(String pattern, String replacement) {
        this.dashboardDao.replaceWidgetTypeFullFqn(pattern, replacement);
    }

    public void setTrendzWidgetsTypeLatestBySystemFqn(String systemFqn) {
        this.dashboardDao.setTrendzWidgetsTypeLatestBySystemFqn(systemFqn);
    }

    public void replacePatternInAllDashboardsConfigurations(String pattern, String replacement) {
        this.dashboardDao.replacePatternInAllDashboardsConfigurations(pattern, replacement);
    }

    public void deleteAllTenantResourcesByResourceKey(String resourceKey) {
        Validator.validateString((String)resourceKey, f -> "Incorrect resource key " + f);
        this.tbResourceDao.deleteAllTenantResourcesByResourceKey(resourceKey);
    }

    public TrendzSettings createSettings(String trendzUrl, String tbUrl) {
        TrendzConfiguration config = new TrendzConfiguration(trendzUrl, tbUrl);
        TrendzSynchronizationResult syncResult = new TrendzSynchronizationResult(null, Long.valueOf(0L), TrendzSynchronizationResultType.SYNC_NOT_INITIALIZED, TrendzSynchronizationStatus.NOT_AVAILABLE);
        return new TrendzSettings(config, syncResult);
    }

    @ConstructorProperties(value={"dashboardDao", "widgetTypeDao", "tbResourceDao"})
    @Generated
    public TrendzUpdater(DashboardDao dashboardDao, WidgetTypeDao widgetTypeDao, TbResourceDao tbResourceDao) {
        this.dashboardDao = dashboardDao;
        this.widgetTypeDao = widgetTypeDao;
        this.tbResourceDao = tbResourceDao;
    }
}

