/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install.update;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.HasImage;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.WidgetTypeId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.widget.WidgetTypeDetails;
import org.thingsboard.server.common.data.wl.WhiteLabeling;
import org.thingsboard.server.common.data.wl.WhiteLabelingType;
import org.thingsboard.server.dao.Dao;
import org.thingsboard.server.dao.asset.AssetProfileDao;
import org.thingsboard.server.dao.dashboard.DashboardDao;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.dao.device.DeviceProfileDao;
import org.thingsboard.server.dao.resource.ImageService;
import org.thingsboard.server.dao.resource.ResourceService;
import org.thingsboard.server.dao.tenant.TenantDao;
import org.thingsboard.server.dao.widget.WidgetTypeDao;
import org.thingsboard.server.dao.widget.WidgetTypeService;
import org.thingsboard.server.dao.widget.WidgetsBundleDao;
import org.thingsboard.server.dao.wl.WhiteLabelingDao;

@Component
public class ResourcesUpdater {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourcesUpdater.class);
    private final ImageService imageService;
    private final ResourceService resourceService;
    private final WidgetsBundleDao widgetsBundleDao;
    private final WidgetTypeDao widgetTypeDao;
    private final WidgetTypeService widgetTypeService;
    private final WhiteLabelingDao whiteLabelingDao;
    private final TenantDao tenantDao;
    private final DashboardDao dashboardDao;
    private final DashboardService dashboardService;
    private final DeviceProfileDao deviceProfileDao;
    private final AssetProfileDao assetProfileDao;

    public void updateWidgetsBundlesImages() {
        log.info("Updating widgets bundles images...");
        PageDataIterable widgetsBundles = new PageDataIterable(arg_0 -> ((WidgetsBundleDao)this.widgetsBundleDao).findAllWidgetsBundles(arg_0), 128);
        this.updateImages((Iterable)widgetsBundles, "bundle", (arg_0, arg_1) -> ((ImageService)this.imageService).replaceBase64WithImageUrl(arg_0, arg_1), (Dao)this.widgetsBundleDao);
    }

    public void updateWidgetTypesImages() {
        log.info("Updating widget types images...");
        PageDataIterable widgetTypesIds = new PageDataIterable(arg_0 -> ((WidgetTypeDao)this.widgetTypeDao).findAllWidgetTypesIds(arg_0), 1024);
        this.updateImages((Iterable)widgetTypesIds, "widget type", arg_0 -> ((ImageService)this.imageService).updateImagesUsage(arg_0), (Dao)this.widgetTypeDao);
    }

    public void updateWhiteLabelingImages() {
        log.info("Updating white-labeling images...");
        PageDataIterable whiteLabelingEntities = new PageDataIterable(pageLink -> this.whiteLabelingDao.findAllByType(pageLink, Set.of(WhiteLabelingType.GENERAL, WhiteLabelingType.LOGIN)), 64);
        int updatedCount = 0;
        int totalCount = 0;
        for (WhiteLabeling whiteLabeling : whiteLabelingEntities) {
            ++totalCount;
            try {
                boolean updated = this.imageService.replaceBase64WithImageUrl(whiteLabeling);
                if (updated) {
                    this.whiteLabelingDao.save(whiteLabeling.getTenantId(), whiteLabeling);
                    log.debug("[{}] Updated white-labeling images", (Object)whiteLabeling.getTenantId());
                    ++updatedCount;
                }
            }
            catch (Exception e) {
                log.error("[{}] Failed to update white-labeling images", (Object)whiteLabeling.getTenantId(), (Object)e);
            }
            if (totalCount % 100 != 0) continue;
            log.info("Processed {} white-labeling entities so far", (Object)totalCount);
        }
        log.info("Updated {} white-labeling entities out of {}", (Object)updatedCount, (Object)totalCount);
    }

    public void updateDashboardsImages() {
        log.info("Updating dashboards images...");
        this.updateImages("dashboard", (arg_0, arg_1) -> ((DashboardDao)this.dashboardDao).findIdsByTenantId(arg_0, arg_1), arg_0 -> ((ImageService)this.imageService).updateImagesUsage(arg_0), (Dao)this.dashboardDao);
    }

    public void createSystemImagesAndResources(Dashboard defaultDashboard) {
        defaultDashboard.setTenantId(TenantId.SYS_TENANT_ID);
        if (CollectionUtils.isNotEmpty((Collection)defaultDashboard.getResources())) {
            this.resourceService.importResources(defaultDashboard.getTenantId(), null, defaultDashboard.getResources());
        }
        this.imageService.updateImagesUsage(defaultDashboard);
        log.debug("Created/updated system images and resources for default dashboard '{}'", (Object)defaultDashboard.getTitle());
    }

    public void updateDashboardsResources() {
        log.info("Updating resources usage in dashboards");
        ExecutorService executor = ThingsBoardExecutors.newLimitedTasksExecutor((int)4, (int)4, (String)"dashboards-resources-upgrade");
        PageDataIterable dashboards = new PageDataIterable(arg_0 -> ((DashboardService)this.dashboardService).findAllDashboardsIds(arg_0), 512);
        AtomicInteger totalCount = new AtomicInteger();
        AtomicInteger updatedCount = new AtomicInteger();
        for (DashboardId dashboardId : dashboards) {
            executor.submit(() -> {
                Dashboard dashboard = this.dashboardService.findDashboardById(TenantId.SYS_TENANT_ID, dashboardId);
                boolean updated = this.resourceService.updateResourcesUsage(dashboard.getTenantId(), dashboard);
                if (updated) {
                    this.dashboardService.saveDashboard(dashboard);
                    updatedCount.incrementAndGet();
                }
                if (totalCount.incrementAndGet() % 1000 == 0) {
                    log.info("Processed {} dashboards, updated {}", (Object)totalCount, (Object)updatedCount);
                }
            });
        }
        executor.shutdown();
        if (!executor.awaitTermination(5L, TimeUnit.HOURS)) {
            throw new RuntimeException("Dashboards resources update timeout");
        }
        log.info("Updated {} dashboards", (Object)updatedCount);
    }

    public void updateWidgetsResources() {
        log.info("Updating resources usage in widgets");
        ExecutorService executor = ThingsBoardExecutors.newLimitedTasksExecutor((int)4, (int)4, (String)"widgets-resources-upgrade");
        AtomicInteger totalCount = new AtomicInteger();
        AtomicInteger updatedCount = new AtomicInteger();
        PageDataIterable widgets = new PageDataIterable(arg_0 -> ((WidgetTypeService)this.widgetTypeService).findAllWidgetTypesIds(arg_0), 512);
        for (WidgetTypeId widgetTypeId : widgets) {
            executor.submit(() -> {
                WidgetTypeDetails widgetTypeDetails = this.widgetTypeService.findWidgetTypeDetailsById(TenantId.SYS_TENANT_ID, widgetTypeId);
                boolean updated = this.resourceService.updateResourcesUsage(widgetTypeDetails.getTenantId(), widgetTypeDetails);
                if (updated) {
                    this.widgetTypeService.saveWidgetType(widgetTypeDetails);
                    updatedCount.incrementAndGet();
                }
                if (totalCount.incrementAndGet() % 200 == 0) {
                    log.info("Processed {} widgets, updated {}", (Object)totalCount, (Object)updatedCount);
                }
            });
        }
        executor.shutdown();
        if (!executor.awaitTermination(5L, TimeUnit.HOURS)) {
            throw new RuntimeException("Widgets resources update timeout");
        }
        log.info("Updated {} widgets", (Object)updatedCount);
    }

    public void updateDeviceProfilesImages() {
        log.info("Updating device profiles images...");
        PageDataIterable deviceProfiles = new PageDataIterable(arg_0 -> ((DeviceProfileDao)this.deviceProfileDao).findAllWithImages(arg_0), 256);
        this.updateImages((Iterable)deviceProfiles, "device profile", (arg_0, arg_1) -> ((ImageService)this.imageService).replaceBase64WithImageUrl(arg_0, arg_1), (Dao)this.deviceProfileDao);
    }

    public void updateAssetProfilesImages() {
        log.info("Updating asset profiles images...");
        PageDataIterable assetProfiles = new PageDataIterable(arg_0 -> ((AssetProfileDao)this.assetProfileDao).findAllWithImages(arg_0), 256);
        this.updateImages((Iterable)assetProfiles, "asset profile", (arg_0, arg_1) -> ((ImageService)this.imageService).replaceBase64WithImageUrl(arg_0, arg_1), (Dao)this.assetProfileDao);
    }

    private <E extends HasImage> void updateImages(Iterable<E> entities, String type, BiFunction<E, String, Boolean> updater, Dao<E> dao) {
        int updatedCount = 0;
        int totalCount = 0;
        for (HasImage entity : entities) {
            ++totalCount;
            try {
                boolean updated = updater.apply(entity, type);
                if (updated) {
                    dao.save(entity.getTenantId(), (Object)entity);
                    log.debug("[{}][{}] Updated {} images", new Object[]{entity.getTenantId(), entity.getName(), type});
                    ++updatedCount;
                }
            }
            catch (Exception e) {
                log.error("[{}][{}] Failed to update {} images", new Object[]{entity.getTenantId(), entity.getName(), type, e});
            }
            if (totalCount % 100 != 0) continue;
            log.info("Processed {} {}s so far", (Object)totalCount, (Object)type);
        }
        log.info("Updated {} {}s out of {}", new Object[]{updatedCount, type, totalCount});
    }

    private <E extends HasImage> void updateImages(Iterable<? extends EntityId> entitiesIds, String type, Function<E, Boolean> updater, Dao<E> dao) {
        int totalCount = 0;
        int updatedCount = 0;
        int[] counts = this.updateImages(entitiesIds, type, updater, dao, totalCount, updatedCount);
        totalCount = counts[0];
        updatedCount = counts[1];
        log.info("Updated {} {}s out of {}", new Object[]{updatedCount, type, totalCount});
    }

    private <E extends HasImage> void updateImages(String type, BiFunction<TenantId, PageLink, PageData<? extends EntityId>> entityIdsByTenantId, Function<E, Boolean> updater, Dao<E> dao) {
        int tenantCount = 0;
        int totalCount = 0;
        int updatedCount = 0;
        PageDataIterable tenantIds = new PageDataIterable(arg_0 -> ((TenantDao)this.tenantDao).findTenantsIds(arg_0), 128);
        for (TenantId tenantId : tenantIds) {
            PageDataIterable entitiesIds = new PageDataIterable(link -> (PageData)entityIdsByTenantId.apply(tenantId, link), 128);
            int[] counts = this.updateImages((Iterable)entitiesIds, type, updater, dao, totalCount, updatedCount);
            totalCount = counts[0];
            updatedCount = counts[1];
            if (++tenantCount % 100 != 0) continue;
            log.info("Update {}s images: processed {} tenants so far", (Object)type, (Object)tenantCount);
        }
        log.info("Updated {} {}s out of {}", new Object[]{updatedCount, type, totalCount});
    }

    private <E extends HasImage> int[] updateImages(Iterable<? extends EntityId> entitiesIds, String type, Function<E, Boolean> updater, Dao<E> dao, int totalCount, int updatedCount) {
        for (EntityId entityId : entitiesIds) {
            HasImage entity;
            ++totalCount;
            try {
                entity = (HasImage)dao.findById(TenantId.SYS_TENANT_ID, entityId.getId());
            }
            catch (Exception e) {
                log.error("Failed to update {} images: error fetching {} by id [{}]: {}", new Object[]{type, type, entityId.getId(), StringUtils.abbreviate((String)e.toString(), (int)1000)});
                continue;
            }
            try {
                boolean updated = updater.apply(entity);
                if (updated) {
                    dao.save(entity.getTenantId(), (Object)entity);
                    log.debug("[{}][{}] Updated {} images", new Object[]{entity.getTenantId(), entity.getName(), type});
                    ++updatedCount;
                }
            }
            catch (Exception e) {
                log.error("[{}][{}] Failed to update {} images", new Object[]{entity.getTenantId(), entity.getName(), type, e});
            }
            if (totalCount % 100 != 0) continue;
            log.info("Processed {} {}s so far", (Object)totalCount, (Object)type);
        }
        return new int[]{totalCount, updatedCount};
    }

    @ConstructorProperties(value={"imageService", "resourceService", "widgetsBundleDao", "widgetTypeDao", "widgetTypeService", "whiteLabelingDao", "tenantDao", "dashboardDao", "dashboardService", "deviceProfileDao", "assetProfileDao"})
    @Generated
    public ResourcesUpdater(ImageService imageService, ResourceService resourceService, WidgetsBundleDao widgetsBundleDao, WidgetTypeDao widgetTypeDao, WidgetTypeService widgetTypeService, WhiteLabelingDao whiteLabelingDao, TenantDao tenantDao, DashboardDao dashboardDao, DashboardService dashboardService, DeviceProfileDao deviceProfileDao, AssetProfileDao assetProfileDao) {
        this.imageService = imageService;
        this.resourceService = resourceService;
        this.widgetsBundleDao = widgetsBundleDao;
        this.widgetTypeDao = widgetTypeDao;
        this.widgetTypeService = widgetTypeService;
        this.whiteLabelingDao = whiteLabelingDao;
        this.tenantDao = tenantDao;
        this.dashboardDao = dashboardDao;
        this.dashboardService = dashboardService;
        this.deviceProfileDao = deviceProfileDao;
        this.assetProfileDao = assetProfileDao;
    }
}

