/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install.update;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.dao.tenant.TenantProfileService;
import org.thingsboard.server.service.install.update.PaginatedUpdater;

@Component
@Profile(value={"install"})
public class IntegrationRateLimitsUpdater
extends PaginatedUpdater<String, TenantProfile> {
    private final TenantProfileService tenantProfileService;
    @Value(value="#{ environment.getProperty('TB_INTEGRATION_RATE_LIMITS_ENABLED') ?: environment.getProperty('integrations.rate_limits.enabled') ?: 'false' }")
    protected boolean rateLimitsEnabled;
    @Value(value="#{ environment.getProperty('TB_INTEGRATION_RATE_LIMITS_TENANT') ?: environment.getProperty('integrations.rate_limits.tenant') ?: '1000:1,20000:60' }")
    protected String msgsPerTenantRateLimit;
    @Value(value="#{ environment.getProperty('TB_INTEGRATION_RATE_LIMITS_DEVICE') ?: environment.getProperty('integrations.rate_limits.device') ?: '10:1,300:60' }")
    protected String msgsPerDeviceRateLimit;

    protected PageData<TenantProfile> findEntities(String id, PageLink pageLink) {
        if (!this.rateLimitsEnabled) {
            return PageData.emptyPageData();
        }
        return this.tenantProfileService.findTenantProfiles(TenantId.SYS_TENANT_ID, pageLink);
    }

    protected void updateEntity(TenantProfile tenantProfile) {
        DefaultTenantProfileConfiguration profileConfiguration = tenantProfile.getDefaultProfileConfiguration();
        if (StringUtils.isNotEmpty((CharSequence)this.msgsPerTenantRateLimit)) {
            profileConfiguration.setIntegrationMsgsPerTenantRateLimit(this.msgsPerTenantRateLimit);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.msgsPerDeviceRateLimit)) {
            profileConfiguration.setIntegrationMsgsPerDeviceRateLimit(this.msgsPerDeviceRateLimit);
        }
        this.tenantProfileService.saveTenantProfile(TenantId.SYS_TENANT_ID, tenantProfile);
    }

    protected String getName() {
        return "Integration rate limits updater";
    }

    protected boolean forceReportTotal() {
        return true;
    }

    @ConstructorProperties(value={"tenantProfileService"})
    @Generated
    public IntegrationRateLimitsUpdater(TenantProfileService tenantProfileService) {
        this.tenantProfileService = tenantProfileService;
    }
}

