/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install.update;

import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.group.EntityGroupService;
import org.thingsboard.server.service.install.update.EntityGroupAllPaginatedUpdater;

class DevicesGroupAllUpdater
extends EntityGroupAllPaginatedUpdater<DeviceId, Device> {
    private final DeviceService deviceService;

    public DevicesGroupAllUpdater(DeviceService deviceService, CustomerService customerService, EntityGroupService entityGroupService, EntityGroup groupAll, boolean fetchAllTenantEntities) {
        super(customerService, entityGroupService, groupAll, fetchAllTenantEntities, (arg_0, arg_1) -> ((DeviceService)deviceService).findDevicesByTenantId(arg_0, arg_1), (arg_0, arg_1) -> ((DeviceService)deviceService).findDevicesByTenantIdAndIdsAsync(arg_0, arg_1), entityId -> new DeviceId(entityId.getId()), Device::getId);
        this.deviceService = deviceService;
    }

    protected void unassignFromCustomer(Device entity) {
        entity.setCustomerId(new CustomerId(CustomerId.NULL_UUID));
        this.deviceService.saveDevice(entity);
    }

    protected String getName() {
        return "Devices group all updater";
    }
}

