/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install.update;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.ObjectType;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.edqs.EdqsState;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.integration.AbstractIntegration;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.JsonDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.rule.RuleNode;
import org.thingsboard.server.common.data.trendz.TrendzSettings;
import org.thingsboard.server.common.data.widget.WidgetsBundle;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.cloud.EdgeSettingsService;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.dao.entityview.EntityViewService;
import org.thingsboard.server.dao.group.EntityGroupService;
import org.thingsboard.server.dao.integration.IntegrationService;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.dao.resource.ResourceService;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.dao.trendz.TrendzSettingsService;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.dao.widget.WidgetsBundleService;
import org.thingsboard.server.dao.wl.WhiteLabelingService;
import org.thingsboard.server.service.component.ComponentDiscoveryService;
import org.thingsboard.server.service.component.RuleNodeClassInfo;
import org.thingsboard.server.service.edqs.EdqsSyncState;
import org.thingsboard.server.service.install.DbUpgradeExecutorService;
import org.thingsboard.server.service.install.SystemDataLoaderService;
import org.thingsboard.server.service.install.update.DataUpdateService;
import org.thingsboard.server.service.install.update.PaginatedUpdater;
import org.thingsboard.server.service.install.update.TrendzUpdater;
import org.thingsboard.server.utils.TbNodeUpgradeUtils;

@Service
@Profile(value={"install"})
public class DefaultDataUpdateService
implements DataUpdateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultDataUpdateService.class);
    private static final int MAX_PENDING_SAVE_RULE_NODE_FUTURES = 256;
    private static final int DEFAULT_PAGE_SIZE = 1024;
    private static final int DEFAULT_LIMIT = 100;
    private final RelationService relationService;
    private final RuleChainService ruleChainService;
    private final IntegrationService integrationService;
    private final EntityGroupService entityGroupService;
    private final UserService userService;
    private final WhiteLabelingService whiteLabelingService;
    private final CustomerService customerService;
    private final AssetService assetService;
    private final DeviceService deviceService;
    private final AttributesService attributesService;
    private final DashboardService dashboardService;
    private final EntityViewService entityViewService;
    private final EdgeService edgeService;
    private final SystemDataLoaderService systemDataLoaderService;
    private final WidgetsBundleService widgetsBundleService;
    private final EdgeSettingsService edgeSettingsService;
    private final ComponentDiscoveryService componentDiscoveryService;
    private final DbUpgradeExecutorService executorService;
    private final ResourceService resourceService;
    private final TrendzUpdater trendzUpdater;
    private final TrendzSettingsService trendzSettingsService;
    private final TenantService tenantService;
    private PaginatedUpdater<String, Tenant> tenantsCustomersGroupAllUpdater = new /* Unavailable Anonymous Inner Class!! */;
    private PaginatedUpdater<String, Tenant> tenantEntitiesGroupAllUpdater = new /* Unavailable Anonymous Inner Class!! */;
    private PaginatedUpdater<String, Tenant> tenantIntegrationUpdater = new /* Unavailable Anonymous Inner Class!! */;
    private final PaginatedUpdater<String, Tenant> tenantsFullSyncRequiredUpdater = new /* Unavailable Anonymous Inner Class!! */;

    public void updateData(boolean fromCe) throws Exception {
        log.info("Updating data ...");
        if (fromCe) {
            this.updateDataFromCe();
        } else {
            EdqsSyncState state = ((Optional)this.attributesService.find(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, AttributeScope.SERVER_SCOPE, "edqsSyncState").get(15L, TimeUnit.SECONDS)).flatMap(KvEntry::getJsonValue).map(value -> (EdqsSyncState)JacksonUtil.fromString((String)value, EdqsSyncState.class)).orElse(null);
            if (state != null && state.getStatus() == EdqsState.EdqsSyncStatus.FINISHED) {
                EdqsSyncState edqsSyncState = new EdqsSyncState(EdqsState.EdqsSyncStatus.REQUESTED, Set.of(ObjectType.REPORT_TEMPLATE, ObjectType.REPORT));
                this.attributesService.save(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, AttributeScope.SERVER_SCOPE, (AttributeKvEntry)new BaseAttributeKvEntry((KvEntry)new JsonDataEntry("edqsSyncState", JacksonUtil.toString((Object)edqsSyncState)), System.currentTimeMillis())).get(15L, TimeUnit.SECONDS);
            }
        }
        this.tenantsFullSyncRequiredUpdater.updateEntities(null);
        log.info("Data updated.");
    }

    @Transactional
    public void postUpdateData() throws Exception {
        this.migrateTenantTrendzWidgetBundleToSysadminLevel();
        this.migrateTenantTrendzJsModuleToSysadminLevel();
    }

    private void updateDataFromCe() throws Exception {
        this.tenantsCustomersGroupAllUpdater.updateEntities();
        this.tenantEntitiesGroupAllUpdater.updateEntities();
        this.tenantIntegrationUpdater.updateEntities();
        JsonNode mailTemplatesSettings = this.whiteLabelingService.findMailTemplatesByTenantId(TenantId.SYS_TENANT_ID, TenantId.SYS_TENANT_ID);
        if (mailTemplatesSettings.isEmpty()) {
            this.systemDataLoaderService.loadMailTemplates();
        } else {
            this.systemDataLoaderService.updateMailTemplates(mailTemplatesSettings);
        }
    }

    public void upgradeRuleNodes() {
        int totalRuleNodesUpgraded = 0;
        log.info("Starting rule nodes upgrade ...");
        List nodeClassToVersionMap = this.componentDiscoveryService.getVersionedNodes();
        log.debug("Found {} versioned nodes to check for upgrade!", (Object)nodeClassToVersionMap.size());
        for (RuleNodeClassInfo ruleNodeClassInfo : nodeClassToVersionMap) {
            String ruleNodeTypeForLogs = ruleNodeClassInfo.getSimpleName();
            int toVersion = ruleNodeClassInfo.getCurrentVersion();
            try {
                log.debug("Going to check for nodes with type: {} to upgrade to version: {}.", (Object)ruleNodeTypeForLogs, (Object)toVersion);
                List ruleNodesIdsToUpgrade = this.getRuleNodesIdsWithTypeAndVersionLessThan(ruleNodeClassInfo.getClassName(), toVersion);
                if (ruleNodesIdsToUpgrade.isEmpty()) {
                    log.debug("There are no active nodes with type {}, or all nodes with this type already set to latest version!", (Object)ruleNodeTypeForLogs);
                    continue;
                }
                List ruleNodeIdsPartitions = Lists.partition((List)ruleNodesIdsToUpgrade, (int)256);
                for (List ruleNodePack : ruleNodeIdsPartitions) {
                    log.info("{} upgraded rule nodes so far ...", (Object)(totalRuleNodesUpgraded += this.processRuleNodePack(ruleNodePack, ruleNodeClassInfo)));
                }
            }
            catch (Exception e) {
                log.error("Unexpected error during {} rule nodes upgrade: ", (Object)ruleNodeTypeForLogs, (Object)e);
            }
        }
        log.info("Finished rule nodes upgrade. Upgraded rule nodes count: {}", (Object)totalRuleNodesUpgraded);
    }

    private void migrateTenantTrendzWidgetBundleToSysadminLevel() throws Exception {
        log.info("Starting Trendz widget bundle migration ...");
        String bundleAlias = "trendz_bundle";
        Set<String> fqns = Set.of("trendz_builder", "trendz_view_latest", "trendz_view_static", "trendz_view_latest_chat");
        Set fullFqns = fqns.stream().map(fqn -> bundleAlias + "." + fqn).collect(Collectors.toSet());
        Map<String, String> oldToNew = Map.of("trendz_bundle", "advanced_analytics", "trendz_builder", "advanced_analytics_builder", "trendz_view_latest", "advanced_analytics_view", "trendz_view_static", "advanced_analytics_view", "trendz_view_latest_chat", "advanced_analytics_chat_assistant");
        this.trendzUpdater.labelWidgetTypesAsDeprecatedByFqns(fullFqns);
        this.trendzUpdater.findUniqueTrendzBaseUrlFromWidgetTypes(fullFqns).ifPresentOrElse(baseUrl -> {
            String urlString = baseUrl.toString();
            log.info("Found unique Trendz URL '{}'. Migrating dashboards to use system Trendz widgets", (Object)urlString);
            TrendzSettings trendzSettings = this.trendzSettingsService.findTrendzSettings();
            if (trendzSettings == null) {
                TrendzSettings newSettings = this.trendzUpdater.createSettings(urlString, null);
                this.trendzSettingsService.saveTrendzSettings(newSettings);
                log.info("Trendz Setting is not found for Sysadmin, saving a new one: {}", (Object)newSettings);
            } else {
                log.info("Trendz Setting already present for Sysadmin, keep that setting without changes: {}", (Object)trendzSettings);
            }
            for (String fullFqn : fullFqns) {
                String fqn = StringUtils.substringAfterLast((String)fullFqn, (String)".");
                String tenantFqnOld = "tenant." + fullFqn;
                String tenantFqnNew = "tenant." + fqn;
                String systemFqn = "system." + oldToNew.getOrDefault(fqn, fqn);
                this.trendzUpdater.replaceWidgetTypeFullFqn(tenantFqnNew, systemFqn);
                this.trendzUpdater.replaceWidgetTypeFullFqn(tenantFqnOld, systemFqn);
                this.trendzUpdater.setTrendzWidgetsTypeLatestBySystemFqn(systemFqn);
            }
        }, () -> log.info("Couldn't find unique Trendz URL, skipping migration of dashboards to system Trendz widgets"));
        log.debug("Finished trendz widget bundle upgrade.");
    }

    private void migrateTenantTrendzJsModuleToSysadminLevel() {
        String resourceKey = "ai-summary-module.js";
        TbResource system = this.resourceService.findResourceByTenantIdAndKey(TenantId.SYS_TENANT_ID, ResourceType.JS_MODULE, resourceKey);
        if (system == null) {
            throw new RuntimeException("Can not find trendz js module as resource with key: " + resourceKey);
        }
        String systemLink = system.getLink();
        log.info("Migrating dashboards to use system ai-summary-module.js");
        this.trendzUpdater.replacePatternInAllDashboardsConfigurations("/api/resource/js_module/tenant/ai-summary-module.js", systemLink);
        this.trendzUpdater.deleteAllTenantResourcesByResourceKey(system.getResourceKey());
    }

    private int processRuleNodePack(List<RuleNodeId> ruleNodeIdsBatch, RuleNodeClassInfo ruleNodeClassInfo) {
        ArrayList<ListenableFuture> saveFutures = new ArrayList<ListenableFuture>(256);
        String ruleNodeType = ruleNodeClassInfo.getSimpleName();
        int toVersion = ruleNodeClassInfo.getCurrentVersion();
        List ruleNodesPack = this.ruleChainService.findAllRuleNodesByIds(ruleNodeIdsBatch);
        for (RuleNode ruleNode : ruleNodesPack) {
            if (ruleNode == null) continue;
            RuleNodeId ruleNodeId = ruleNode.getId();
            int fromVersion = ruleNode.getConfigurationVersion();
            log.debug("Going to upgrade rule node with id: {} type: {} fromVersion: {} toVersion: {}", new Object[]{ruleNodeId, ruleNodeType, fromVersion, toVersion});
            try {
                TbNodeUpgradeUtils.upgradeConfigurationAndVersion((RuleNode)ruleNode, (RuleNodeClassInfo)ruleNodeClassInfo);
                saveFutures.add(this.executorService.submit(() -> {
                    this.ruleChainService.saveRuleNode(TenantId.SYS_TENANT_ID, ruleNode);
                    log.debug("Successfully upgrade rule node with id: {} type: {} fromVersion: {} toVersion: {}", new Object[]{ruleNodeId, ruleNodeType, fromVersion, toVersion});
                }));
            }
            catch (Exception e) {
                log.warn("Failed to upgrade rule node with id: {} type: {} fromVersion: {} toVersion: {} due to: ", new Object[]{ruleNodeId, ruleNodeType, fromVersion, toVersion, e});
            }
        }
        try {
            return ((List)Futures.allAsList(saveFutures).get()).size();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Failed to process save rule nodes requests due to: ", e);
        }
    }

    private List<RuleNodeId> getRuleNodesIdsWithTypeAndVersionLessThan(String type, int toVersion) {
        ArrayList<RuleNodeId> ruleNodeIds = new ArrayList<RuleNodeId>();
        new PageDataIterable(pageLink -> this.ruleChainService.findAllRuleNodeIdsByTypeAndVersionLessThan(type, toVersion, pageLink), 1024).forEach(ruleNodeIds::add);
        return ruleNodeIds;
    }

    private void updateTenantIntegrations(TenantId tenantId) {
        PageLink pageLink = new PageLink(100);
        PageData pageData = this.integrationService.findTenantIntegrations(tenantId, pageLink);
        boolean hasNext = true;
        while (hasNext) {
            for (Integration integration : pageData.getData()) {
                try {
                    Field enabledField = AbstractIntegration.class.getDeclaredField("enabled");
                    enabledField.setAccessible(true);
                    Boolean booleanVal = (Boolean)enabledField.get(integration);
                    if (booleanVal != null) continue;
                    integration.setEnabled(Boolean.valueOf(true));
                    this.integrationService.saveIntegration(integration);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (pageData.hasNext()) {
                pageLink = pageLink.nextPageLink();
                pageData = this.integrationService.findTenantIntegrations(tenantId, pageLink);
                continue;
            }
            hasNext = false;
        }
    }

    public static boolean getEnv(String name, boolean defaultValue) {
        String env = System.getenv(name);
        if (env == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(env);
    }

    private void fixDuplicateSystemWidgetsBundles() {
        try {
            List systemWidgetsBundles = this.widgetsBundleService.findSystemWidgetsBundles(TenantId.SYS_TENANT_ID);
            for (WidgetsBundle widgetsBundle : systemWidgetsBundles) {
                try {
                    this.widgetsBundleService.findWidgetsBundleByTenantIdAndAlias(TenantId.SYS_TENANT_ID, widgetsBundle.getAlias());
                }
                catch (IncorrectResultSizeDataAccessException e) {
                    for (WidgetsBundle systemWidgetsBundle : systemWidgetsBundles) {
                        if (!systemWidgetsBundle.getAlias().equals(widgetsBundle.getAlias())) continue;
                        this.widgetsBundleService.deleteWidgetsBundle(TenantId.SYS_TENANT_ID, systemWidgetsBundle.getId());
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Unable to fix duplicate system widgets bundles", (Throwable)e);
        }
    }

    @ConstructorProperties(value={"relationService", "ruleChainService", "integrationService", "entityGroupService", "userService", "whiteLabelingService", "customerService", "assetService", "deviceService", "attributesService", "dashboardService", "entityViewService", "edgeService", "systemDataLoaderService", "widgetsBundleService", "edgeSettingsService", "componentDiscoveryService", "executorService", "resourceService", "trendzUpdater", "trendzSettingsService", "tenantService"})
    @Generated
    public DefaultDataUpdateService(RelationService relationService, RuleChainService ruleChainService, IntegrationService integrationService, EntityGroupService entityGroupService, UserService userService, WhiteLabelingService whiteLabelingService, CustomerService customerService, AssetService assetService, DeviceService deviceService, AttributesService attributesService, DashboardService dashboardService, EntityViewService entityViewService, EdgeService edgeService, SystemDataLoaderService systemDataLoaderService, WidgetsBundleService widgetsBundleService, EdgeSettingsService edgeSettingsService, ComponentDiscoveryService componentDiscoveryService, DbUpgradeExecutorService executorService, ResourceService resourceService, TrendzUpdater trendzUpdater, TrendzSettingsService trendzSettingsService, TenantService tenantService) {
        this.relationService = relationService;
        this.ruleChainService = ruleChainService;
        this.integrationService = integrationService;
        this.entityGroupService = entityGroupService;
        this.userService = userService;
        this.whiteLabelingService = whiteLabelingService;
        this.customerService = customerService;
        this.assetService = assetService;
        this.deviceService = deviceService;
        this.attributesService = attributesService;
        this.dashboardService = dashboardService;
        this.entityViewService = entityViewService;
        this.edgeService = edgeService;
        this.systemDataLoaderService = systemDataLoaderService;
        this.widgetsBundleService = widgetsBundleService;
        this.edgeSettingsService = edgeSettingsService;
        this.componentDiscoveryService = componentDiscoveryService;
        this.executorService = executorService;
        this.resourceService = resourceService;
        this.trendzUpdater = trendzUpdater;
        this.trendzSettingsService = trendzSettingsService;
        this.tenantService = tenantService;
    }
}

