/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install.migrate;

import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.postgresql.util.PSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.UUIDConverter;
import org.thingsboard.server.dao.cassandra.guava.GuavaSession;
import org.thingsboard.server.service.install.migrate.CassandraToSqlColumn;
import org.thingsboard.server.service.install.migrate.CassandraToSqlColumnData;
import org.thingsboard.server.service.install.migrate.CassandraToSqlColumnType;

public class CassandraToSqlTable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CassandraToSqlTable.class);
    private static final int DEFAULT_BATCH_SIZE = 10000;
    private String cassandraCf;
    private String sqlTableName;
    private List<CassandraToSqlColumn> columns;
    private int batchSize = 10000;
    private PreparedStatement sqlInsertStatement;

    public CassandraToSqlTable(String tableName, CassandraToSqlColumn ... columns) {
        this(tableName, tableName, 10000, columns);
    }

    public CassandraToSqlTable(String tableName, String sqlTableName, CassandraToSqlColumn ... columns) {
        this(tableName, sqlTableName, 10000, columns);
    }

    public CassandraToSqlTable(String tableName, int batchSize, CassandraToSqlColumn ... columns) {
        this(tableName, tableName, batchSize, columns);
    }

    public CassandraToSqlTable(String cassandraCf, String sqlTableName, int batchSize, CassandraToSqlColumn ... columns) {
        this.cassandraCf = cassandraCf;
        this.sqlTableName = sqlTableName;
        this.batchSize = batchSize;
        this.columns = Arrays.asList(columns);
        for (int i = 0; i < columns.length; ++i) {
            ((CassandraToSqlColumn)this.columns.get(i)).setIndex(i);
            ((CassandraToSqlColumn)this.columns.get(i)).setSqlIndex(i + 1);
        }
    }

    public void migrateToSql(GuavaSession session, Connection conn) throws SQLException {
        boolean hasNext;
        log.info("[{}] Migrating data from cassandra '{}' Column Family to '{}' SQL table...", new Object[]{this.sqlTableName, this.cassandraCf, this.sqlTableName});
        DatabaseMetaData metadata = conn.getMetaData();
        java.sql.ResultSet resultSet = metadata.getColumns(null, null, this.sqlTableName, null);
        while (resultSet.next()) {
            String name = resultSet.getString("COLUMN_NAME");
            int sqlType = resultSet.getInt("DATA_TYPE");
            int size = resultSet.getInt("COLUMN_SIZE");
            CassandraToSqlColumn column = this.getColumn(name);
            column.setSize(size);
            column.setSqlType(sqlType);
        }
        this.sqlInsertStatement = this.createSqlInsertStatement(conn);
        Statement cassandraSelectStatement = this.createCassandraSelectStatement();
        cassandraSelectStatement.setPageSize(100);
        ResultSet rs = session.execute(cassandraSelectStatement);
        Iterator iter = rs.iterator();
        int rowCounter = 0;
        do {
            List batchData;
            hasNext = (batchData = this.extractBatchData(iter)).size() == this.batchSize;
            this.batchInsert(batchData, conn);
            log.info("[{}] {} records migrated so far...", (Object)this.sqlTableName, (Object)(rowCounter += batchData.size()));
        } while (hasNext);
        this.sqlInsertStatement.close();
        log.info("[{}] {} total records migrated.", (Object)this.sqlTableName, (Object)rowCounter);
        log.info("[{}] Finished migration data from cassandra '{}' Column Family to '{}' SQL table.", new Object[]{this.sqlTableName, this.cassandraCf, this.sqlTableName});
    }

    private List<CassandraToSqlColumnData[]> extractBatchData(Iterator<Row> iter) {
        ArrayList<CassandraToSqlColumnData[]> batchData = new ArrayList<CassandraToSqlColumnData[]>();
        while (iter.hasNext() && batchData.size() < this.batchSize) {
            Row row = iter.next();
            if (row == null) continue;
            CassandraToSqlColumnData[] data = this.extractRowData(row);
            batchData.add(data);
        }
        return batchData;
    }

    private CassandraToSqlColumnData[] extractRowData(Row row) {
        CassandraToSqlColumnData[] data = new CassandraToSqlColumnData[this.columns.size()];
        for (CassandraToSqlColumn column : this.columns) {
            String value = column.getColumnValue(row);
            data[column.getIndex()] = new CassandraToSqlColumnData(value);
        }
        return this.validateColumnData(data);
    }

    protected CassandraToSqlColumnData[] validateColumnData(CassandraToSqlColumnData[] data) {
        for (int i = 0; i < data.length; ++i) {
            CassandraToSqlColumnData columnData;
            String value;
            CassandraToSqlColumn column = (CassandraToSqlColumn)this.columns.get(i);
            if (column.getType() != CassandraToSqlColumnType.STRING || (value = (columnData = data[i]).getValue()) == null || value.length() <= column.getSize()) continue;
            log.warn("[{}] Value size [{}] exceeds maximum size [{}] of column [{}] and will be truncated!", new Object[]{this.sqlTableName, value.length(), column.getSize(), column.getSqlColumnName()});
            log.warn("[{}] Affected data:\n{}", (Object)this.sqlTableName, (Object)this.dataToString(data));
            value = value.substring(0, column.getSize());
            columnData.setOriginalValue(value);
            columnData.setValue(value);
        }
        return data;
    }

    protected void batchInsert(List<CassandraToSqlColumnData[]> batchData, Connection conn) throws SQLException {
        boolean retry = false;
        for (CassandraToSqlColumnData[] data : batchData) {
            for (CassandraToSqlColumn column : this.columns) {
                column.setColumnValue(this.sqlInsertStatement, data[column.getIndex()].getValue());
            }
            try {
                this.sqlInsertStatement.executeUpdate();
            }
            catch (SQLException e) {
                if (this.handleInsertException(batchData, data, conn, e)) {
                    retry = true;
                    break;
                }
                throw e;
            }
        }
        if (retry) {
            this.batchInsert(batchData, conn);
        } else {
            conn.commit();
        }
    }

    private boolean handleInsertException(List<CassandraToSqlColumnData[]> batchData, CassandraToSqlColumnData[] data, Connection conn, SQLException ex) throws SQLException {
        conn.commit();
        String constraint = this.extractConstraintName(ex).orElse(null);
        if (constraint != null) {
            if (this.onConstraintViolation(batchData, data, constraint)) {
                return true;
            }
            log.error("[{}] Unhandled constraint violation [{}] during insert!", (Object)this.sqlTableName, (Object)constraint);
            log.error("[{}] Affected data:\n{}", (Object)this.sqlTableName, (Object)this.dataToString(data));
        } else {
            log.error("[{}] Unhandled exception during insert!", (Object)this.sqlTableName);
            log.error("[{}] Affected data:\n{}", (Object)this.sqlTableName, (Object)this.dataToString(data));
        }
        return false;
    }

    private String dataToString(CassandraToSqlColumnData[] data) {
        StringBuffer stringData = new StringBuffer("{\n");
        for (int i = 0; i < data.length; ++i) {
            String columnName = ((CassandraToSqlColumn)this.columns.get(i)).getSqlColumnName();
            String value = data[i].getLogValue();
            stringData.append("\"").append(columnName).append("\": ").append("[").append(value).append("]\n");
        }
        stringData.append("}");
        return stringData.toString();
    }

    protected boolean onConstraintViolation(List<CassandraToSqlColumnData[]> batchData, CassandraToSqlColumnData[] data, String constraint) {
        return false;
    }

    protected void handleUniqueNameViolation(CassandraToSqlColumnData[] data, String entityType) {
        CassandraToSqlColumn nameColumn = this.getColumn("name");
        CassandraToSqlColumn searchTextColumn = this.getColumn("search_text");
        CassandraToSqlColumnData nameColumnData = data[nameColumn.getIndex()];
        CassandraToSqlColumnData searchTextColumnData = data[searchTextColumn.getIndex()];
        String prevName = nameColumnData.getValue();
        String newName = nameColumnData.getNextConstraintStringValue(nameColumn);
        nameColumnData.setValue(newName);
        searchTextColumnData.setValue(searchTextColumnData.getNextConstraintStringValue(searchTextColumn));
        String id = UUIDConverter.fromString((String)this.getColumnData(data, "id").getValue()).toString();
        log.warn("Found {} with duplicate name [id:[{}]]. Attempting to rename {} from '{}' to '{}'...", new Object[]{entityType, id, entityType, prevName, newName});
    }

    protected void handleUniqueEmailViolation(CassandraToSqlColumnData[] data) {
        CassandraToSqlColumn emailColumn = this.getColumn("email");
        CassandraToSqlColumn searchTextColumn = this.getColumn("search_text");
        CassandraToSqlColumnData emailColumnData = data[emailColumn.getIndex()];
        CassandraToSqlColumnData searchTextColumnData = data[searchTextColumn.getIndex()];
        String prevEmail = emailColumnData.getValue();
        String newEmail = emailColumnData.getNextConstraintEmailValue(emailColumn);
        emailColumnData.setValue(newEmail);
        searchTextColumnData.setValue(searchTextColumnData.getNextConstraintEmailValue(searchTextColumn));
        String id = UUIDConverter.fromString((String)this.getColumnData(data, "id").getValue()).toString();
        log.warn("Found user with duplicate email [id:[{}]]. Attempting to rename email from '{}' to '{}'...", new Object[]{id, prevEmail, newEmail});
    }

    protected void ignoreRecord(List<CassandraToSqlColumnData[]> batchData, CassandraToSqlColumnData[] data) {
        log.warn("[{}] Affected data:\n{}", (Object)this.sqlTableName, (Object)this.dataToString(data));
        int index = batchData.indexOf(data);
        if (index > 0) {
            batchData.remove(index);
        }
    }

    protected CassandraToSqlColumn getColumn(String sqlColumnName) {
        return this.columns.stream().filter(col -> col.getSqlColumnName().equals(sqlColumnName)).findFirst().get();
    }

    protected CassandraToSqlColumnData getColumnData(CassandraToSqlColumnData[] data, String sqlColumnName) {
        CassandraToSqlColumn column = this.getColumn(sqlColumnName);
        return data[column.getIndex()];
    }

    private Optional<String> extractConstraintName(SQLException ex) {
        String sqlStateClassCode;
        String sqlState = JdbcExceptionHelper.extractSqlState((SQLException)ex);
        if (sqlState != null && (sqlStateClassCode = JdbcExceptionHelper.determineSqlStateClassCode((String)sqlState)) != null && Arrays.asList("23", "27", "44").contains(sqlStateClassCode) && ex instanceof PSQLException) {
            return Optional.of(((PSQLException)ex).getServerErrorMessage().getConstraint());
        }
        return Optional.empty();
    }

    protected Statement createCassandraSelectStatement() {
        StringBuilder selectStatementBuilder = new StringBuilder();
        selectStatementBuilder.append("SELECT ");
        for (CassandraToSqlColumn column : this.columns) {
            selectStatementBuilder.append(column.getCassandraColumnName()).append(",");
        }
        selectStatementBuilder.deleteCharAt(selectStatementBuilder.length() - 1);
        selectStatementBuilder.append(" FROM ").append(this.cassandraCf);
        return SimpleStatement.newInstance((String)selectStatementBuilder.toString());
    }

    private PreparedStatement createSqlInsertStatement(Connection conn) throws SQLException {
        StringBuilder insertStatementBuilder = new StringBuilder();
        insertStatementBuilder.append("INSERT INTO ").append(this.sqlTableName).append(" (");
        for (CassandraToSqlColumn column : this.columns) {
            insertStatementBuilder.append(column.getSqlColumnName()).append(",");
        }
        insertStatementBuilder.deleteCharAt(insertStatementBuilder.length() - 1);
        insertStatementBuilder.append(") VALUES (");
        for (CassandraToSqlColumn column : this.columns) {
            if (column.getType() == CassandraToSqlColumnType.JSON) {
                insertStatementBuilder.append("cast(? AS json)");
            } else {
                insertStatementBuilder.append("?");
            }
            insertStatementBuilder.append(",");
        }
        insertStatementBuilder.deleteCharAt(insertStatementBuilder.length() - 1);
        insertStatementBuilder.append(")");
        return conn.prepareStatement(insertStatementBuilder.toString());
    }

    @Generated
    public String getCassandraCf() {
        return this.cassandraCf;
    }

    @Generated
    public String getSqlTableName() {
        return this.sqlTableName;
    }

    @Generated
    public List<CassandraToSqlColumn> getColumns() {
        return this.columns;
    }

    @Generated
    public int getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public PreparedStatement getSqlInsertStatement() {
        return this.sqlInsertStatement;
    }

    @Generated
    public void setCassandraCf(String cassandraCf) {
        this.cassandraCf = cassandraCf;
    }

    @Generated
    public void setSqlTableName(String sqlTableName) {
        this.sqlTableName = sqlTableName;
    }

    @Generated
    public void setColumns(List<CassandraToSqlColumn> columns) {
        this.columns = columns;
    }

    @Generated
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Generated
    public void setSqlInsertStatement(PreparedStatement sqlInsertStatement) {
        this.sqlInsertStatement = sqlInsertStatement;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CassandraToSqlTable)) {
            return false;
        }
        CassandraToSqlTable other = (CassandraToSqlTable)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        String this$cassandraCf = this.getCassandraCf();
        String other$cassandraCf = other.getCassandraCf();
        if (this$cassandraCf == null ? other$cassandraCf != null : !this$cassandraCf.equals(other$cassandraCf)) {
            return false;
        }
        String this$sqlTableName = this.getSqlTableName();
        String other$sqlTableName = other.getSqlTableName();
        if (this$sqlTableName == null ? other$sqlTableName != null : !this$sqlTableName.equals(other$sqlTableName)) {
            return false;
        }
        List this$columns = this.getColumns();
        List other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        PreparedStatement this$sqlInsertStatement = this.getSqlInsertStatement();
        PreparedStatement other$sqlInsertStatement = other.getSqlInsertStatement();
        return !(this$sqlInsertStatement == null ? other$sqlInsertStatement != null : !this$sqlInsertStatement.equals(other$sqlInsertStatement));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CassandraToSqlTable;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBatchSize();
        String $cassandraCf = this.getCassandraCf();
        result = result * 59 + ($cassandraCf == null ? 43 : $cassandraCf.hashCode());
        String $sqlTableName = this.getSqlTableName();
        result = result * 59 + ($sqlTableName == null ? 43 : $sqlTableName.hashCode());
        List $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        PreparedStatement $sqlInsertStatement = this.getSqlInsertStatement();
        result = result * 59 + ($sqlInsertStatement == null ? 43 : $sqlInsertStatement.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CassandraToSqlTable(cassandraCf=" + this.getCassandraCf() + ", sqlTableName=" + this.getSqlTableName() + ", columns=" + String.valueOf(this.getColumns()) + ", batchSize=" + this.getBatchSize() + ", sqlInsertStatement=" + String.valueOf(this.getSqlInsertStatement()) + ")";
    }
}

