/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Profile;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.data.AdminSettings;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.alarm.rule.AlarmRule;
import org.thingsboard.server.common.data.alarm.rule.condition.AlarmCondition;
import org.thingsboard.server.common.data.alarm.rule.condition.AlarmConditionValue;
import org.thingsboard.server.common.data.alarm.rule.condition.SimpleAlarmCondition;
import org.thingsboard.server.common.data.alarm.rule.condition.expression.AlarmConditionExpression;
import org.thingsboard.server.common.data.alarm.rule.condition.expression.AlarmConditionFilter;
import org.thingsboard.server.common.data.alarm.rule.condition.expression.ComplexOperation;
import org.thingsboard.server.common.data.alarm.rule.condition.expression.SimpleAlarmConditionExpression;
import org.thingsboard.server.common.data.alarm.rule.condition.expression.predicate.BooleanFilterPredicate;
import org.thingsboard.server.common.data.alarm.rule.condition.expression.predicate.NumericFilterPredicate;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.AlarmCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.Argument;
import org.thingsboard.server.common.data.cf.configuration.ArgumentType;
import org.thingsboard.server.common.data.cf.configuration.CalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.ReferencedEntityKey;
import org.thingsboard.server.common.data.debug.DebugSettings;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.BooleanDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.menu.CMAssigneeType;
import org.thingsboard.server.common.data.menu.CMScope;
import org.thingsboard.server.common.data.menu.CustomMenu;
import org.thingsboard.server.common.data.menu.CustomMenuInfo;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.query.EntityKeyValueType;
import org.thingsboard.server.common.data.queue.ProcessingStrategy;
import org.thingsboard.server.common.data.queue.ProcessingStrategyType;
import org.thingsboard.server.common.data.queue.Queue;
import org.thingsboard.server.common.data.queue.SubmitStrategy;
import org.thingsboard.server.common.data.queue.SubmitStrategyType;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.common.data.security.UserCredentials;
import org.thingsboard.server.common.data.security.model.JwtSettings;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileConfiguration;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileData;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileQueueConfiguration;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.device.DeviceConnectivityConfiguration;
import org.thingsboard.server.dao.device.DeviceCredentialsService;
import org.thingsboard.server.dao.device.DeviceProfileService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.group.EntityGroupService;
import org.thingsboard.server.dao.menu.CustomMenuService;
import org.thingsboard.server.dao.mobile.MobileAppDao;
import org.thingsboard.server.dao.notification.NotificationSettingsService;
import org.thingsboard.server.dao.notification.NotificationTargetService;
import org.thingsboard.server.dao.queue.QueueService;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.dao.settings.AdminSettingsService;
import org.thingsboard.server.dao.tenant.TenantProfileService;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.exception.DataValidationException;
import org.thingsboard.server.service.install.DefaultSystemDataLoaderService;
import org.thingsboard.server.service.install.InstallScripts;
import org.thingsboard.server.service.install.SystemDataLoaderService;
import org.thingsboard.server.service.security.auth.jwt.settings.DefaultJwtSettingsService;
import org.thingsboard.server.service.security.auth.jwt.settings.JwtSettingsService;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Profile(value={"install"})
public class DefaultSystemDataLoaderService
implements SystemDataLoaderService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSystemDataLoaderService.class);
    public static final String CUSTOMER_CRED = "customer";
    public static final String ACTIVITY_STATE = "active";
    private final InstallScripts installScripts;
    private final UserService userService;
    private final AdminSettingsService adminSettingsService;
    private final TenantService tenantService;
    private final TenantProfileService tenantProfileService;
    private final CustomerService customerService;
    private final DeviceService deviceService;
    private final DeviceProfileService deviceProfileService;
    private final AttributesService attributesService;
    private final DeviceCredentialsService deviceCredentialsService;
    private final RuleChainService ruleChainService;
    private final TimeseriesService tsService;
    private final DeviceConnectivityConfiguration connectivityConfiguration;
    private final QueueService queueService;
    private final JwtSettingsService jwtSettingsService;
    private final MobileAppDao mobileAppDao;
    private final NotificationSettingsService notificationSettingsService;
    private final NotificationTargetService notificationTargetService;
    private final CalculatedFieldService calculatedFieldService;
    private final EntityGroupService entityGroupService;
    private final CustomMenuService customMenuService;
    @Autowired
    private BCryptPasswordEncoder passwordEncoder;
    @Value(value="${state.persistToTelemetry:false}")
    private boolean persistActivityToTelemetry;
    @Value(value="${security.jwt.tokenExpirationTime:9000}")
    private Integer tokenExpirationTime;
    @Value(value="${security.jwt.refreshTokenExpTime:604800}")
    private Integer refreshTokenExpTime;
    @Value(value="${security.jwt.tokenIssuer:thingsboard.io}")
    private String tokenIssuer;
    @Value(value="${security.jwt.tokenSigningKey:thingsboardDefaultSigningKey}")
    private String tokenSigningKey;
    private ExecutorService tsCallBackExecutor;

    @Bean
    protected BCryptPasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @PostConstruct
    public void initExecutor() {
        this.tsCallBackExecutor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"sys-loader-ts-callback"));
    }

    @PreDestroy
    public void shutdownExecutor() {
        if (this.tsCallBackExecutor != null) {
            this.tsCallBackExecutor.shutdownNow();
        }
    }

    public void createSysAdmin() {
        this.createUser(Authority.SYS_ADMIN, null, null, "sysadmin@thingsboard.org", "sysadmin");
    }

    public void createDefaultTenantProfiles() throws Exception {
        this.tenantProfileService.findOrCreateDefaultTenantProfile(TenantId.SYS_TENANT_ID);
        TenantProfileData isolatedRuleEngineTenantProfileData = new TenantProfileData();
        DefaultTenantProfileConfiguration configuration = new DefaultTenantProfileConfiguration();
        configuration.setMaxDebugModeDurationMinutes(15);
        isolatedRuleEngineTenantProfileData.setConfiguration((TenantProfileConfiguration)configuration);
        TenantProfileQueueConfiguration mainQueueConfiguration = new TenantProfileQueueConfiguration();
        mainQueueConfiguration.setName("Main");
        mainQueueConfiguration.setTopic("tb_rule_engine.main");
        mainQueueConfiguration.setPollInterval(25);
        mainQueueConfiguration.setPartitions(10);
        mainQueueConfiguration.setConsumerPerPartition(true);
        mainQueueConfiguration.setPackProcessingTimeout(2000L);
        SubmitStrategy mainQueueSubmitStrategy = new SubmitStrategy();
        mainQueueSubmitStrategy.setType(SubmitStrategyType.BURST);
        mainQueueSubmitStrategy.setBatchSize(1000);
        mainQueueConfiguration.setSubmitStrategy(mainQueueSubmitStrategy);
        ProcessingStrategy mainQueueProcessingStrategy = new ProcessingStrategy();
        mainQueueProcessingStrategy.setType(ProcessingStrategyType.SKIP_ALL_FAILURES);
        mainQueueProcessingStrategy.setRetries(3);
        mainQueueProcessingStrategy.setFailurePercentage(0.0);
        mainQueueProcessingStrategy.setPauseBetweenRetries(3L);
        mainQueueProcessingStrategy.setMaxPauseBetweenRetries(3L);
        mainQueueConfiguration.setProcessingStrategy(mainQueueProcessingStrategy);
        isolatedRuleEngineTenantProfileData.setQueueConfiguration(Collections.singletonList(mainQueueConfiguration));
        TenantProfile isolatedTbRuleEngineProfile = new TenantProfile();
        isolatedTbRuleEngineProfile.setDefault(false);
        isolatedTbRuleEngineProfile.setName("Isolated TB Rule Engine");
        isolatedTbRuleEngineProfile.setDescription("Isolated TB Rule Engine tenant profile");
        isolatedTbRuleEngineProfile.setIsolatedTbRuleEngine(true);
        isolatedTbRuleEngineProfile.setProfileData(isolatedRuleEngineTenantProfileData);
        try {
            this.tenantProfileService.saveTenantProfile(TenantId.SYS_TENANT_ID, isolatedTbRuleEngineProfile);
        }
        catch (DataValidationException e) {
            log.warn(e.getMessage());
        }
    }

    public void createAdminSettings() throws Exception {
        AdminSettings generalSettings = new AdminSettings();
        generalSettings.setTenantId(TenantId.SYS_TENANT_ID);
        generalSettings.setKey("general");
        ObjectNode node = JacksonUtil.newObjectNode();
        node.put("baseUrl", "http://localhost:8080");
        node.put("prohibitDifferentUrl", false);
        generalSettings.setJsonValue((JsonNode)node);
        this.adminSettingsService.saveAdminSettings(TenantId.SYS_TENANT_ID, generalSettings);
        AdminSettings mailSettings = new AdminSettings();
        mailSettings.setTenantId(TenantId.SYS_TENANT_ID);
        mailSettings.setKey("mail");
        node = JacksonUtil.newObjectNode();
        node.put("mailFrom", "ThingsBoard <sysadmin@localhost.localdomain>");
        node.put("smtpProtocol", "smtp");
        node.put("smtpHost", "localhost");
        node.put("smtpPort", "25");
        node.put("timeout", "10000");
        node.put("enableTls", false);
        node.put("username", "");
        node.put("password", "");
        node.put("tlsVersion", "TLSv1.2");
        node.put("enableProxy", false);
        node.put("showChangePassword", false);
        mailSettings.setJsonValue((JsonNode)node);
        this.adminSettingsService.saveAdminSettings(TenantId.SYS_TENANT_ID, mailSettings);
        AdminSettings connectivitySettings = new AdminSettings();
        connectivitySettings.setTenantId(TenantId.SYS_TENANT_ID);
        connectivitySettings.setKey("connectivity");
        connectivitySettings.setJsonValue(JacksonUtil.valueToTree((Object)this.connectivityConfiguration.getConnectivity()));
        this.adminSettingsService.saveAdminSettings(TenantId.SYS_TENANT_ID, connectivitySettings);
    }

    public void loadMailTemplates() throws Exception {
        this.installScripts.loadMailTemplates();
    }

    public void updateMailTemplates(JsonNode value) throws Exception {
    }

    public void createRandomJwtSettings() throws Exception {
        if (this.jwtSettingsService.getJwtSettings() == null) {
            log.info("Creating JWT admin settings...");
            JwtSettings jwtSettings = new JwtSettings(this.tokenExpirationTime, this.refreshTokenExpTime, this.tokenIssuer, this.tokenSigningKey);
            if (DefaultJwtSettingsService.isSigningKeyDefault((JwtSettings)jwtSettings) || !DefaultJwtSettingsService.validateKeyLength((String)jwtSettings.getTokenSigningKey())) {
                jwtSettings.setTokenSigningKey(this.generateRandomKey());
            }
            this.jwtSettingsService.saveJwtSettings(jwtSettings);
        } else {
            log.info("Skip creating JWT admin settings because they already exist.");
        }
    }

    public void updateSecuritySettings() {
        List mobiles;
        JwtSettings jwtSettings = this.jwtSettingsService.getJwtSettings();
        boolean invalidSignKey = false;
        String warningMessage = null;
        if (DefaultJwtSettingsService.isSigningKeyDefault((JwtSettings)jwtSettings)) {
            warningMessage = "The platform is using the default JWT Signing Key, which is a security risk.";
            invalidSignKey = true;
        } else if (!DefaultJwtSettingsService.validateKeyLength((String)jwtSettings.getTokenSigningKey())) {
            warningMessage = "The JWT Signing Key is shorter than 512 bits, which is a security risk.";
            invalidSignKey = true;
        }
        if (invalidSignKey) {
            log.warn("WARNING: {}. A new JWT Signing Key has been added automatically. You can change the JWT Signing Key using the Web UI: Navigate to \"System settings -> Security settings\" while logged in as a System Administrator.", (Object)warningMessage);
            jwtSettings.setTokenSigningKey(this.generateRandomKey());
            this.jwtSettingsService.saveJwtSettings(jwtSettings);
        }
        if (CollectionUtils.isNotEmpty((Collection)(mobiles = this.mobileAppDao.findByTenantId(TenantId.SYS_TENANT_ID, null, new PageLink(Integer.MAX_VALUE, 0)).getData()))) {
            mobiles.stream().filter(mobileApp -> !DefaultJwtSettingsService.validateKeyLength((String)mobileApp.getAppSecret())).forEach(mobileApp -> {
                log.warn("WARNING: The App secret is shorter than 512 bits, which is a security risk. A new Application Secret has been added automatically for Mobile Application [{}]. You can change the Application Secret using the Web UI: Navigate to \"Security settings -> OAuth2 -> Mobile applications\" while logged in as a System Administrator.", (Object)mobileApp.getPkgName());
                mobileApp.setAppSecret(this.generateRandomKey());
                this.mobileAppDao.save(TenantId.SYS_TENANT_ID, mobileApp);
            });
        }
    }

    private String generateRandomKey() {
        return Base64.getEncoder().encodeToString(RandomStringUtils.randomAlphanumeric((int)64).getBytes(StandardCharsets.UTF_8));
    }

    public void createOAuth2Templates() throws Exception {
        this.installScripts.createOAuth2Templates();
    }

    public void loadDemoData() throws Exception {
    }

    private void createAlarmRules(TenantId tenantId, DeviceProfileId deviceProfileId) {
        CalculatedField highTemperature = new CalculatedField();
        highTemperature.setName("High Temperature");
        highTemperature.setType(CalculatedFieldType.ALARM);
        highTemperature.setTenantId(tenantId);
        highTemperature.setEntityId((EntityId)deviceProfileId);
        highTemperature.setDebugSettings(DebugSettings.all());
        AlarmCalculatedFieldConfiguration highTemperatureConfig = new AlarmCalculatedFieldConfiguration();
        highTemperature.setConfiguration((CalculatedFieldConfiguration)highTemperatureConfig);
        Argument temperatureArgument = new Argument();
        temperatureArgument.setRefEntityKey(new ReferencedEntityKey("temperature", ArgumentType.TS_LATEST, null));
        Argument temperatureThresholdArgument = new Argument();
        temperatureThresholdArgument.setRefEntityKey(new ReferencedEntityKey("temperatureAlarmThreshold", ArgumentType.ATTRIBUTE, AttributeScope.SERVER_SCOPE));
        temperatureThresholdArgument.setDefaultValue("25");
        Argument temperatureAlarmFlagArgument = new Argument();
        temperatureAlarmFlagArgument.setRefEntityKey(new ReferencedEntityKey("temperatureAlarmFlag", ArgumentType.ATTRIBUTE, AttributeScope.SERVER_SCOPE));
        highTemperatureConfig.setArguments(Map.of("temperature", temperatureArgument, "temperatureAlarmThreshold", temperatureThresholdArgument, "temperatureAlarmFlag", temperatureAlarmFlagArgument));
        AlarmRule temperatureRule = new AlarmRule();
        SimpleAlarmCondition temperatureCondition = new SimpleAlarmCondition();
        AlarmConditionFilter temperatureAlarmFlagFilter = new AlarmConditionFilter();
        temperatureAlarmFlagFilter.setArgument("temperatureAlarmFlag");
        temperatureAlarmFlagFilter.setValueType(EntityKeyValueType.BOOLEAN);
        BooleanFilterPredicate temperatureAlarmFlagAttributePredicate = new BooleanFilterPredicate();
        temperatureAlarmFlagAttributePredicate.setOperation(BooleanFilterPredicate.BooleanOperation.EQUAL);
        temperatureAlarmFlagAttributePredicate.setValue(new AlarmConditionValue((Object)Boolean.TRUE, null));
        temperatureAlarmFlagFilter.setPredicates(List.of(temperatureAlarmFlagAttributePredicate));
        AlarmConditionFilter temperatureFilter = new AlarmConditionFilter();
        temperatureFilter.setArgument("temperature");
        temperatureFilter.setValueType(EntityKeyValueType.NUMERIC);
        NumericFilterPredicate temperatureFilterPredicate = new NumericFilterPredicate();
        temperatureFilterPredicate.setOperation(NumericFilterPredicate.NumericOperation.GREATER);
        temperatureFilterPredicate.setValue(new AlarmConditionValue(null, "temperatureAlarmThreshold"));
        temperatureFilter.setPredicates(List.of(temperatureFilterPredicate));
        temperatureCondition.setExpression((AlarmConditionExpression)new SimpleAlarmConditionExpression(List.of(temperatureAlarmFlagFilter, temperatureFilter), ComplexOperation.AND));
        temperatureRule.setCondition((AlarmCondition)temperatureCondition);
        temperatureRule.setAlarmDetails("Current temperature = ${temperature}");
        highTemperatureConfig.setCreateRules(Map.of(AlarmSeverity.MAJOR, temperatureRule));
        AlarmRule clearTemperatureRule = new AlarmRule();
        SimpleAlarmCondition clearTemperatureCondition = new SimpleAlarmCondition();
        AlarmConditionFilter clearTemperatureFilter = new AlarmConditionFilter();
        clearTemperatureFilter.setArgument("temperature");
        clearTemperatureFilter.setValueType(EntityKeyValueType.NUMERIC);
        NumericFilterPredicate clearTemperatureFilterPredicate = new NumericFilterPredicate();
        clearTemperatureFilterPredicate.setOperation(NumericFilterPredicate.NumericOperation.LESS_OR_EQUAL);
        clearTemperatureFilterPredicate.setValue(new AlarmConditionValue(null, "temperatureAlarmThreshold"));
        clearTemperatureFilter.setPredicates(List.of(clearTemperatureFilterPredicate));
        clearTemperatureCondition.setExpression((AlarmConditionExpression)new SimpleAlarmConditionExpression(List.of(clearTemperatureFilter), ComplexOperation.AND));
        clearTemperatureRule.setCondition((AlarmCondition)clearTemperatureCondition);
        clearTemperatureRule.setAlarmDetails("Current temperature = ${temperature}");
        highTemperatureConfig.setClearRule(clearTemperatureRule);
        this.calculatedFieldService.save(highTemperature);
        CalculatedField lowHumidity = new CalculatedField();
        lowHumidity.setName("Low Humidity");
        lowHumidity.setType(CalculatedFieldType.ALARM);
        lowHumidity.setTenantId(tenantId);
        lowHumidity.setEntityId((EntityId)deviceProfileId);
        lowHumidity.setDebugSettings(DebugSettings.all());
        AlarmCalculatedFieldConfiguration lowHumidityConfig = new AlarmCalculatedFieldConfiguration();
        lowHumidity.setConfiguration((CalculatedFieldConfiguration)lowHumidityConfig);
        Argument humidityArgument = new Argument();
        humidityArgument.setRefEntityKey(new ReferencedEntityKey("humidity", ArgumentType.TS_LATEST, null));
        Argument humidityThresholdArgument = new Argument();
        humidityThresholdArgument.setRefEntityKey(new ReferencedEntityKey("humidityAlarmThreshold", ArgumentType.ATTRIBUTE, AttributeScope.SERVER_SCOPE));
        humidityThresholdArgument.setDefaultValue("60");
        Argument humidityAlarmFlagArgument = new Argument();
        humidityAlarmFlagArgument.setRefEntityKey(new ReferencedEntityKey("humidityAlarmFlag", ArgumentType.ATTRIBUTE, AttributeScope.SERVER_SCOPE));
        lowHumidityConfig.setArguments(Map.of("humidity", humidityArgument, "humidityAlarmThreshold", humidityThresholdArgument, "humidityAlarmFlag", humidityAlarmFlagArgument));
        AlarmRule humidityRule = new AlarmRule();
        SimpleAlarmCondition humidityCondition = new SimpleAlarmCondition();
        AlarmConditionFilter humidityAlarmFlagAttributeFilter = new AlarmConditionFilter();
        humidityAlarmFlagAttributeFilter.setArgument("humidityAlarmFlag");
        humidityAlarmFlagAttributeFilter.setValueType(EntityKeyValueType.BOOLEAN);
        BooleanFilterPredicate humidityAlarmFlagPredicate = new BooleanFilterPredicate();
        humidityAlarmFlagPredicate.setOperation(BooleanFilterPredicate.BooleanOperation.EQUAL);
        humidityAlarmFlagPredicate.setValue(new AlarmConditionValue((Object)Boolean.TRUE, null));
        humidityAlarmFlagAttributeFilter.setPredicates(List.of(humidityAlarmFlagPredicate));
        AlarmConditionFilter humidityFilter = new AlarmConditionFilter();
        humidityFilter.setArgument("humidity");
        humidityFilter.setValueType(EntityKeyValueType.NUMERIC);
        NumericFilterPredicate humidityFilterPredicate = new NumericFilterPredicate();
        humidityFilterPredicate.setOperation(NumericFilterPredicate.NumericOperation.LESS);
        humidityFilterPredicate.setValue(new AlarmConditionValue(null, "humidityAlarmThreshold"));
        humidityFilter.setPredicates(List.of(humidityFilterPredicate));
        humidityCondition.setExpression((AlarmConditionExpression)new SimpleAlarmConditionExpression(List.of(humidityAlarmFlagAttributeFilter, humidityFilter), ComplexOperation.AND));
        humidityRule.setCondition((AlarmCondition)humidityCondition);
        humidityRule.setAlarmDetails("Current humidity = ${humidity}");
        lowHumidityConfig.setCreateRules(Map.of(AlarmSeverity.MINOR, humidityRule));
        AlarmRule clearHumidityRule = new AlarmRule();
        SimpleAlarmCondition clearHumidityCondition = new SimpleAlarmCondition();
        AlarmConditionFilter clearHumidityFilter = new AlarmConditionFilter();
        clearHumidityFilter.setArgument("humidity");
        clearHumidityFilter.setValueType(EntityKeyValueType.NUMERIC);
        NumericFilterPredicate clearHumidityFilterPredicate = new NumericFilterPredicate();
        clearHumidityFilterPredicate.setOperation(NumericFilterPredicate.NumericOperation.GREATER_OR_EQUAL);
        clearHumidityFilterPredicate.setValue(new AlarmConditionValue(null, "humidityAlarmThreshold"));
        clearHumidityFilter.setPredicates(List.of(clearHumidityFilterPredicate));
        clearHumidityCondition.setExpression((AlarmConditionExpression)new SimpleAlarmConditionExpression(List.of(clearHumidityFilter), ComplexOperation.AND));
        clearHumidityRule.setCondition((AlarmCondition)clearHumidityCondition);
        clearHumidityRule.setAlarmDetails("Current humidity = ${humidity}");
        lowHumidityConfig.setClearRule(clearHumidityRule);
        this.calculatedFieldService.save(lowHumidity);
    }

    public void loadSystemWidgets() throws Exception {
        this.installScripts.loadSystemWidgets();
    }

    private User createUser(Authority authority, TenantId tenantId, CustomerId customerId, String email, String password) {
        User user = new User();
        user.setAuthority(authority);
        user.setEmail(email);
        user.setTenantId(tenantId);
        user.setCustomerId(customerId);
        user = this.userService.saveUser(tenantId, user);
        UserCredentials userCredentials = this.userService.findUserCredentialsByUserId(TenantId.SYS_TENANT_ID, user.getId());
        userCredentials.setPassword(this.passwordEncoder.encode((CharSequence)password));
        userCredentials.setEnabled(true);
        userCredentials.setActivateToken(null);
        this.userService.saveUserCredentials(TenantId.SYS_TENANT_ID, userCredentials);
        if (Authority.TENANT_ADMIN.equals((Object)authority)) {
            EntityGroup admins = this.entityGroupService.findOrCreateTenantAdminsGroup(user.getTenantId());
            this.entityGroupService.addEntityToEntityGroup(TenantId.SYS_TENANT_ID, admins.getId(), (EntityId)user.getId());
        } else if (Authority.CUSTOMER_USER.equals((Object)authority)) {
            EntityGroup users = this.entityGroupService.findOrCreateCustomerUsersGroup(user.getTenantId(), user.getCustomerId(), null);
            this.entityGroupService.addEntityToEntityGroup(TenantId.SYS_TENANT_ID, users.getId(), (EntityId)user.getId());
        }
        return user;
    }

    private Device createDevice(TenantId tenantId, CustomerId customerId, DeviceProfileId deviceProfileId, String name, String accessToken, String description) {
        Device device = new Device();
        device.setTenantId(tenantId);
        device.setDeviceProfileId(deviceProfileId);
        device.setName(name);
        if (description != null) {
            ObjectNode additionalInfo = JacksonUtil.newObjectNode();
            additionalInfo.put("description", description);
            device.setAdditionalInfo((JsonNode)additionalInfo);
        }
        device = this.deviceService.saveDevice(device);
        this.save(device.getId(), "active", false);
        DeviceCredentials deviceCredentials = this.deviceCredentialsService.findDeviceCredentialsByDeviceId(TenantId.SYS_TENANT_ID, device.getId());
        deviceCredentials.setCredentialsId(accessToken);
        this.deviceCredentialsService.updateDeviceCredentials(TenantId.SYS_TENANT_ID, deviceCredentials);
        if (customerId != null && !customerId.isNullUid()) {
            EntityGroup deviceGroup = this.entityGroupService.findOrCreateReadOnlyEntityGroupForCustomer(tenantId, customerId, EntityType.DEVICE);
            this.entityGroupService.addEntityToEntityGroup(tenantId, deviceGroup.getId(), (EntityId)device.getId());
        }
        return device;
    }

    private void save(DeviceId deviceId, String key, boolean value) {
        if (this.persistActivityToTelemetry) {
            ListenableFuture saveFuture = this.tsService.save(TenantId.SYS_TENANT_ID, (EntityId)deviceId, Collections.singletonList(new BasicTsKvEntry(System.currentTimeMillis(), (KvEntry)new BooleanDataEntry(key, Boolean.valueOf(value)))), 0L);
            this.addTsCallback(saveFuture, (FutureCallback)new TelemetrySaveCallback(deviceId, key, (Object)value));
        } else {
            ListenableFuture saveFuture = this.attributesService.save(TenantId.SYS_TENANT_ID, (EntityId)deviceId, AttributeScope.SERVER_SCOPE, (AttributeKvEntry)new BaseAttributeKvEntry((KvEntry)new BooleanDataEntry(key, Boolean.valueOf(value)), System.currentTimeMillis()));
            this.addTsCallback(saveFuture, (FutureCallback)new TelemetrySaveCallback(deviceId, key, (Object)value));
        }
    }

    private <S> void addTsCallback(ListenableFuture<S> saveFuture, FutureCallback<S> callback) {
        Futures.addCallback(saveFuture, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)this.tsCallBackExecutor);
    }

    public void createQueues() {
        Queue mainQueue = this.queueService.findQueueByTenantIdAndName(TenantId.SYS_TENANT_ID, "Main");
        if (mainQueue == null) {
            mainQueue = new Queue();
            mainQueue.setTenantId(TenantId.SYS_TENANT_ID);
            mainQueue.setName("Main");
            mainQueue.setTopic("tb_rule_engine.tmp");
            mainQueue.setPollInterval(25);
            mainQueue.setPartitions(10);
            mainQueue.setConsumerPerPartition(true);
            mainQueue.setPackProcessingTimeout(2000L);
            SubmitStrategy mainQueueSubmitStrategy = new SubmitStrategy();
            mainQueueSubmitStrategy.setType(SubmitStrategyType.BURST);
            mainQueueSubmitStrategy.setBatchSize(1000);
            mainQueue.setSubmitStrategy(mainQueueSubmitStrategy);
            ProcessingStrategy mainQueueProcessingStrategy = new ProcessingStrategy();
            mainQueueProcessingStrategy.setType(ProcessingStrategyType.SKIP_ALL_FAILURES);
            mainQueueProcessingStrategy.setRetries(3);
            mainQueueProcessingStrategy.setFailurePercentage(0.0);
            mainQueueProcessingStrategy.setPauseBetweenRetries(3L);
            mainQueueProcessingStrategy.setMaxPauseBetweenRetries(3L);
            mainQueue.setProcessingStrategy(mainQueueProcessingStrategy);
            this.queueService.saveQueue(mainQueue);
        }
    }

    public void createDefaultNotificationConfigs() {
        log.info("Creating default notification configs for system admin");
        if (this.notificationTargetService.countNotificationTargetsByTenantId(TenantId.SYS_TENANT_ID) == 0L) {
            this.notificationSettingsService.createDefaultNotificationConfigs(TenantId.SYS_TENANT_ID);
        }
        PageDataIterable tenants = new PageDataIterable(arg_0 -> ((TenantService)this.tenantService).findTenantsIds(arg_0), 500);
        ExecutorService executor = Executors.newFixedThreadPool(Math.max(Runtime.getRuntime().availableProcessors(), 4));
        log.info("Creating default notification configs for all tenants");
        AtomicInteger count = new AtomicInteger();
        for (TenantId tenantId : tenants) {
            executor.submit(() -> {
                if (this.notificationTargetService.countNotificationTargetsByTenantId(tenantId) == 0L) {
                    this.notificationSettingsService.createDefaultNotificationConfigs(tenantId);
                    int n = count.incrementAndGet();
                    if (n % 500 == 0) {
                        log.info("{} tenants processed", (Object)n);
                    }
                }
            });
        }
        executor.shutdown();
        executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    public void updateDefaultNotificationConfigs(boolean updateTenants) {
        log.info("Updating notification configs...");
        this.notificationSettingsService.updateDefaultNotificationConfigs(TenantId.SYS_TENANT_ID);
        if (updateTenants) {
            PageDataIterable tenants = new PageDataIterable(arg_0 -> ((TenantService)this.tenantService).findTenantsIds(arg_0), 500);
            ExecutorService executor = Executors.newFixedThreadPool(Math.max(Runtime.getRuntime().availableProcessors(), 4));
            AtomicInteger count = new AtomicInteger();
            for (TenantId tenantId : tenants) {
                executor.submit(() -> {
                    this.notificationSettingsService.updateDefaultNotificationConfigs(tenantId);
                    int n = count.incrementAndGet();
                    if (n % 500 == 0) {
                        log.info("{} tenants processed", (Object)n);
                    }
                });
            }
            executor.shutdown();
            executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
        }
    }

    public void createDefaultCustomMenu() {
        CustomMenu defaultCustomerCustomMenu;
        CustomMenu defaultTenantCustomMenu;
        CustomMenu defaultSystemCustomMenu = this.customMenuService.findDefaultCustomMenuByScope(TenantId.SYS_TENANT_ID, new CustomerId(CustomerId.NULL_UUID), CMScope.SYSTEM);
        if (defaultSystemCustomMenu == null) {
            try {
                this.customMenuService.createCustomMenu(DefaultSystemDataLoaderService.createDefaultMenu((String)"System default menu", (CMScope)CMScope.SYSTEM), null, false);
            }
            catch (ThingsboardException e) {
                log.warn("Failed to create System default menu", (Throwable)e);
            }
        }
        if ((defaultTenantCustomMenu = this.customMenuService.findDefaultCustomMenuByScope(TenantId.SYS_TENANT_ID, new CustomerId(CustomerId.NULL_UUID), CMScope.TENANT)) == null) {
            try {
                this.customMenuService.createCustomMenu(DefaultSystemDataLoaderService.createDefaultMenu((String)"Tenant default menu", (CMScope)CMScope.TENANT), null, false);
            }
            catch (ThingsboardException e) {
                log.warn("Failed to create Tenant default menu", (Throwable)e);
            }
        }
        if ((defaultCustomerCustomMenu = this.customMenuService.findDefaultCustomMenuByScope(TenantId.SYS_TENANT_ID, new CustomerId(CustomerId.NULL_UUID), CMScope.CUSTOMER)) == null) {
            try {
                this.customMenuService.createCustomMenu(DefaultSystemDataLoaderService.createDefaultMenu((String)"Customer default menu", (CMScope)CMScope.CUSTOMER), null, false);
            }
            catch (ThingsboardException e) {
                log.warn("Failed to create Customer default menu", (Throwable)e);
            }
        }
    }

    private static CustomMenuInfo createDefaultMenu(String name, CMScope scope) {
        CustomMenuInfo customMenuInfo = new CustomMenuInfo();
        customMenuInfo.setTenantId(TenantId.SYS_TENANT_ID);
        customMenuInfo.setCustomerId(new CustomerId(CustomerId.NULL_UUID));
        customMenuInfo.setName(name);
        customMenuInfo.setScope(scope);
        customMenuInfo.setAssigneeType(CMAssigneeType.ALL);
        return customMenuInfo;
    }

    @ConstructorProperties(value={"installScripts", "userService", "adminSettingsService", "tenantService", "tenantProfileService", "customerService", "deviceService", "deviceProfileService", "attributesService", "deviceCredentialsService", "ruleChainService", "tsService", "connectivityConfiguration", "queueService", "jwtSettingsService", "mobileAppDao", "notificationSettingsService", "notificationTargetService", "calculatedFieldService", "entityGroupService", "customMenuService"})
    @Generated
    public DefaultSystemDataLoaderService(InstallScripts installScripts, UserService userService, AdminSettingsService adminSettingsService, TenantService tenantService, TenantProfileService tenantProfileService, CustomerService customerService, DeviceService deviceService, DeviceProfileService deviceProfileService, AttributesService attributesService, DeviceCredentialsService deviceCredentialsService, RuleChainService ruleChainService, TimeseriesService tsService, DeviceConnectivityConfiguration connectivityConfiguration, QueueService queueService, JwtSettingsService jwtSettingsService, MobileAppDao mobileAppDao, NotificationSettingsService notificationSettingsService, NotificationTargetService notificationTargetService, CalculatedFieldService calculatedFieldService, EntityGroupService entityGroupService, CustomMenuService customMenuService) {
        this.installScripts = installScripts;
        this.userService = userService;
        this.adminSettingsService = adminSettingsService;
        this.tenantService = tenantService;
        this.tenantProfileService = tenantProfileService;
        this.customerService = customerService;
        this.deviceService = deviceService;
        this.deviceProfileService = deviceProfileService;
        this.attributesService = attributesService;
        this.deviceCredentialsService = deviceCredentialsService;
        this.ruleChainService = ruleChainService;
        this.tsService = tsService;
        this.connectivityConfiguration = connectivityConfiguration;
        this.queueService = queueService;
        this.jwtSettingsService = jwtSettingsService;
        this.mobileAppDao = mobileAppDao;
        this.notificationSettingsService = notificationSettingsService;
        this.notificationTargetService = notificationTargetService;
        this.calculatedFieldService = calculatedFieldService;
        this.entityGroupService = entityGroupService;
        this.customMenuService = customMenuService;
    }

    @Generated
    public boolean isPersistActivityToTelemetry() {
        return this.persistActivityToTelemetry;
    }
}

