/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.thingsboard.server.dao.cassandra.CassandraInstallCluster;
import org.thingsboard.server.service.install.DatabaseSchemaService;
import org.thingsboard.server.service.install.InstallScripts;
import org.thingsboard.server.service.install.cql.CQLStatementsParser;

public abstract class CassandraAbstractDatabaseSchemaService
implements DatabaseSchemaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CassandraAbstractDatabaseSchemaService.class);
    private static final String CASSANDRA_DIR = "cassandra";
    private static final String CASSANDRA_STANDARD_KEYSPACE = "thingsboard";
    @Autowired
    @Qualifier(value="CassandraInstallCluster")
    private CassandraInstallCluster cluster;
    @Autowired
    private InstallScripts installScripts;
    @Value(value="${cassandra.keyspace_name}")
    private String keyspaceName;
    private final String schemaCql;

    protected CassandraAbstractDatabaseSchemaService(String schemaCql) {
        this.schemaCql = schemaCql;
    }

    public void createDatabaseSchema() throws Exception {
        this.createDatabaseSchema(true);
    }

    public void createDatabaseSchema(boolean createIndexes) throws Exception {
        log.info("Installing Cassandra DataBase schema part: " + this.schemaCql);
        Path schemaFile = Paths.get(this.installScripts.getDataDir(), CASSANDRA_DIR, this.schemaCql);
        this.loadCql(schemaFile);
    }

    public void createDatabaseIndexes() throws Exception {
    }

    private void loadCql(Path cql) throws Exception {
        List statements = new CQLStatementsParser(cql).getStatements();
        statements.forEach(statement -> this.cluster.getSession().execute(this.getCassandraKeyspaceName(statement)));
    }

    private String getCassandraKeyspaceName(String statement) {
        return statement.replaceFirst(CASSANDRA_STANDARD_KEYSPACE, this.keyspaceName);
    }
}

