/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.housekeeper.stats;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTaskType;
import org.thingsboard.server.common.stats.StatsFactory;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.service.housekeeper.stats.HousekeeperStatsService;

@Service
@ConditionalOnProperty(name={"queue.core.housekeeper.stats.enabled"}, havingValue="true", matchIfMissing=true)
public class HousekeeperStatsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HousekeeperStatsService.class);
    private final Map<HousekeeperTaskType, HousekeeperStats> stats = new EnumMap(HousekeeperTaskType.class);

    public HousekeeperStatsService(StatsFactory statsFactory) {
        for (HousekeeperTaskType taskType : HousekeeperTaskType.values()) {
            this.stats.put(taskType, new HousekeeperStats(taskType, statsFactory));
        }
    }

    @Scheduled(initialDelayString="${queue.core.housekeeper.stats.print-interval-ms:60000}", fixedDelayString="${queue.core.housekeeper.stats.print-interval-ms:60000}")
    private void reportStats() {
        String statsStr = this.stats.values().stream().map(stats -> {
            String countersStr = stats.getCounters().stream().filter(counter -> counter.get() > 0).map(counter -> counter.getName() + " = [" + counter.get() + "]").collect(Collectors.joining(" "));
            if (countersStr.isEmpty()) {
                return null;
            }
            return String.valueOf(stats.getTaskType()) + " " + countersStr + " avgProcessingTime [" + stats.getProcessingTimer().getAvg() + " ms]";
        }).filter(Objects::nonNull).collect(Collectors.joining(", "));
        if (!statsStr.isEmpty()) {
            this.stats.values().forEach(HousekeeperStats::reset);
            log.info("Housekeeper stats: {}", (Object)statsStr);
        }
    }

    public void reportProcessed(HousekeeperTaskType taskType, TransportProtos.ToHousekeeperServiceMsg msg, long timing) {
        HousekeeperStats stats = (HousekeeperStats)this.stats.get(taskType);
        if (msg.getTask().getErrorsCount() == 0) {
            stats.getProcessedCounter().increment();
        } else {
            stats.getReprocessedCounter().increment();
        }
        stats.getProcessingTimer().record(timing);
    }

    public void reportFailure(HousekeeperTaskType taskType, TransportProtos.ToHousekeeperServiceMsg msg) {
        HousekeeperStats stats = (HousekeeperStats)this.stats.get(taskType);
        if (msg.getTask().getErrorsCount() == 0) {
            stats.getFailedProcessingCounter().increment();
        } else {
            stats.getFailedReprocessingCounter().increment();
        }
    }
}

