/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.housekeeper.processor;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.event.EventType;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTaskType;
import org.thingsboard.server.dao.event.EventService;
import org.thingsboard.server.service.housekeeper.processor.HousekeeperTaskProcessor;

@Component
public class EventsDeletionTaskProcessor
extends HousekeeperTaskProcessor<HousekeeperTask> {
    private final EventService eventService;

    public void process(HousekeeperTask task) throws Exception {
        EventType[] nonDebugEventTypes = (EventType[])Arrays.stream(EventType.values()).filter(eventType -> !eventType.isDebug()).toArray(EventType[]::new);
        this.eventService.removeEvents(task.getTenantId(), task.getEntityId(), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()), nonDebugEventTypes);
    }

    public HousekeeperTaskType getTaskType() {
        return HousekeeperTaskType.DELETE_EVENTS;
    }

    @ConstructorProperties(value={"eventService"})
    @Generated
    public EventsDeletionTaskProcessor(EventService eventService) {
        this.eventService = eventService;
    }
}

