/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.housekeeper.processor;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.housekeeper.EntitiesCleanupHousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.EntitiesDeletionHousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTaskType;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.common.data.util.TbPair;
import org.thingsboard.server.dao.Dao;
import org.thingsboard.server.dao.entity.EntityDaoRegistry;
import org.thingsboard.server.dao.tenant.TenantProfileService;
import org.thingsboard.server.service.housekeeper.processor.EntitiesCleanupTaskProcessor;
import org.thingsboard.server.service.housekeeper.processor.HousekeeperTaskProcessor;

@Component
public class EntitiesCleanupTaskProcessor
extends HousekeeperTaskProcessor<EntitiesCleanupHousekeeperTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntitiesCleanupTaskProcessor.class);
    private final EntityType[] typesWithTtl = new EntityType[]{EntityType.BLOB_ENTITY, EntityType.REPORT};
    private final EntityDaoRegistry entityDaoRegistry;
    private final TenantProfileService tenantProfileService;
    @Value(value="${queue.core.housekeeper.entities-cleanup-frequency:3600}")
    private long frequency;
    private ScheduledExecutorService executor;

    @PostConstruct
    public void init() {
        this.executor = ThingsBoardExecutors.newSingleThreadScheduledExecutor((String)("housekeeper-scheduler-" + this.getTaskType().name()));
        for (EntityType entityType : this.typesWithTtl) {
            this.executor.scheduleAtFixedRate(() -> this.housekeeperClient.submitTask((HousekeeperTask)new EntitiesCleanupHousekeeperTask(entityType)), this.frequency, this.frequency, TimeUnit.SECONDS);
        }
    }

    public void process(EntitiesCleanupHousekeeperTask task) throws Exception {
        EntityType entityType = task.getEntityType();
        Dao entityDao = this.entityDaoRegistry.getDao(entityType);
        PageDataIterable profilesIterator = new PageDataIterable(page -> this.tenantProfileService.findTenantProfiles(TenantId.SYS_TENANT_ID, page), 128);
        for (TenantProfile tenantProfile : profilesIterator) {
            long ttl = this.getTtl(tenantProfile, entityType);
            if (ttl <= 0L) continue;
            this.process(tenantProfile.getUuidId(), entityType, entityDao, ttl);
        }
    }

    private void process(UUID tenantProfileId, EntityType entityType, Dao<?> entityDao, long ttl) {
        List pairs;
        UUID last = null;
        while (!(pairs = entityDao.findIdsByTenantProfileIdAndIdOffsetAndExpired(tenantProfileId, last, 128, ttl)).isEmpty()) {
            last = (UUID)((TbPair)pairs.get(pairs.size() - 1)).getSecond();
            pairs.stream().collect(Collectors.groupingBy(pair -> TenantId.fromUUID((UUID)((UUID)pair.getFirst())), Collectors.mapping(TbPair::getSecond, Collectors.toList()))).forEach((tenantId, entities) -> {
                this.housekeeperClient.submitTask((HousekeeperTask)new EntitiesDeletionHousekeeperTask(tenantId, entityType, entities));
                log.debug("[{}] Submitted task for deleting {} {}s", new Object[]{tenantId, entities.size(), entityType.getNormalName().toLowerCase()});
            });
        }
    }

    public HousekeeperTaskType getTaskType() {
        return HousekeeperTaskType.CLEANUP_ENTITIES;
    }

    @PreDestroy
    private void destroy() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public long getTtl(TenantProfile tenantProfile, EntityType entityType) {
        DefaultTenantProfileConfiguration configuration = tenantProfile.getDefaultProfileConfiguration();
        int ttlDays = switch (1.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityType.ordinal()]) {
            case 1 -> configuration.getBlobEntityTtlDays();
            case 2 -> configuration.getReportTtlDays();
            default -> 0;
        };
        return TimeUnit.DAYS.toMillis(ttlDays);
    }

    @ConstructorProperties(value={"entityDaoRegistry", "tenantProfileService"})
    @Generated
    public EntitiesCleanupTaskProcessor(EntityDaoRegistry entityDaoRegistry, TenantProfileService tenantProfileService) {
        this.entityDaoRegistry = entityDaoRegistry;
        this.tenantProfileService = tenantProfileService;
    }
}

