/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.executors;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.ExecutorProvider;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.server.queue.util.TbRuleEngineComponent;

@Lazy
@TbRuleEngineComponent
@Component
public class PubSubRuleNodeExecutorProvider
implements ExecutorProvider {
    @Value(value="${service.rule_engine.pubsub.executor_thread_pool_size}")
    private Integer threadPoolSize;
    private static final int THREADS_PER_CPU = 5;
    private ScheduledExecutorService executor;

    @PostConstruct
    public void init() {
        if (this.threadPoolSize == null) {
            this.threadPoolSize = 5 * Runtime.getRuntime().availableProcessors();
        }
        this.executor = ThingsBoardExecutors.newScheduledThreadPool((int)this.threadPoolSize, (String)"pubsub-rule-nodes");
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    @PreDestroy
    private void destroy() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }
}

