/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.user;

import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.thingsboard.rule.engine.api.MailService;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.UserActivationLink;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.security.UserCredentials;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.user.TbUserService;
import org.thingsboard.server.service.security.system.SystemSecurityService;

@Service
@TbCoreComponent
public class DefaultUserService
extends AbstractTbEntityService
implements TbUserService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultUserService.class);
    private final UserService userService;
    private final MailService mailService;
    private final SystemSecurityService systemSecurityService;

    public User save(TenantId tenantId, CustomerId customerId, Authority authority, User tbUser, boolean sendActivationMail, HttpServletRequest request, EntityGroup entityGroup, User user) throws ThingsboardException {
        return this.save(tenantId, customerId, authority, tbUser, sendActivationMail, request, entityGroup != null ? Collections.singletonList(entityGroup) : null, user);
    }

    public User save(TenantId tenantId, CustomerId customerId, Authority authority, User tbUser, boolean sendActivationMail, HttpServletRequest request, List<EntityGroup> entityGroups, User user) throws ThingsboardException {
        ActionType actionType = tbUser.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        try {
            boolean sendEmail = tbUser.getId() == null && sendActivationMail;
            User savedUser = (User)this.checkNotNull((Object)this.userService.saveUser(tenantId, tbUser));
            if (!tbUser.isSystemAdmin()) {
                if (tbUser.getId() == null && authority == Authority.SYS_ADMIN) {
                    EntityGroup admins = this.entityGroupService.findOrCreateTenantAdminsGroup(savedUser.getTenantId());
                    this.entityGroupService.addEntityToEntityGroup(savedUser.getTenantId(), admins.getId(), (EntityId)savedUser.getId());
                    this.logEntityActionService.logEntityAction(tenantId, (EntityId)savedUser.getId(), (HasName)savedUser, customerId, ActionType.ADDED_TO_ENTITY_GROUP, user, new Object[0]);
                } else if (!CollectionUtils.isEmpty(entityGroups) && tbUser.getId() == null) {
                    for (EntityGroup entityGroup : entityGroups) {
                        this.entityGroupService.addEntityToEntityGroup(savedUser.getTenantId(), entityGroup.getId(), (EntityId)savedUser.getId());
                        this.logEntityActionService.logEntityAction(tenantId, (EntityId)savedUser.getId(), (HasName)savedUser, customerId, ActionType.ADDED_TO_ENTITY_GROUP, user, new Object[]{savedUser.getId().toString(), entityGroup.getId().toString(), entityGroup.getName()});
                    }
                }
            }
            if (sendEmail) {
                UserActivationLink activationLink = this.getActivationLink(tenantId, customerId, authority, savedUser.getId(), request);
                try {
                    this.mailService.sendActivationEmail(tenantId, activationLink.value(), activationLink.ttlMs(), savedUser.getEmail());
                }
                catch (ThingsboardException e) {
                    this.userService.deleteUser(tenantId, savedUser);
                    throw new ThingsboardException("Couldn't send user activation email", ThingsboardErrorCode.GENERAL);
                }
            }
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)savedUser.getId(), (HasName)savedUser, customerId, actionType, user, new Object[0]);
            return savedUser;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.USER), (HasName)tbUser, actionType, user, e, new Object[0]);
            throw e;
        }
    }

    public void delete(TenantId tenantId, CustomerId customerId, User user, User responsibleUser) throws ThingsboardException {
        ActionType actionType = ActionType.DELETED;
        UserId userId = user.getId();
        try {
            this.userService.deleteUser(tenantId, user);
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)userId, (HasName)user, customerId, actionType, responsibleUser, new Object[]{customerId.toString()});
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.USER), actionType, responsibleUser, e, new Object[]{userId.toString()});
            throw e;
        }
    }

    public UserActivationLink getActivationLink(TenantId tenantId, CustomerId customerId, Authority authority, UserId userId, HttpServletRequest request) throws ThingsboardException {
        UserCredentials userCredentials = this.userService.findUserCredentialsByUserId(tenantId, userId);
        if (!userCredentials.isEnabled() && userCredentials.getActivateToken() != null) {
            userCredentials = this.userService.checkUserActivationToken(tenantId, userCredentials);
            String baseUrl = this.systemSecurityService.getBaseUrl(authority, tenantId, customerId, request);
            String link = baseUrl + "/api/noauth/activate?activateToken=" + userCredentials.getActivateToken();
            return new UserActivationLink(link, userCredentials.getActivationTokenTtl());
        }
        throw new ThingsboardException("User is already activated!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
    }

    @ConstructorProperties(value={"userService", "mailService", "systemSecurityService"})
    @Generated
    public DefaultUserService(UserService userService, MailService mailService, SystemSecurityService systemSecurityService) {
        this.userService = userService;
        this.mailService = mailService;
        this.systemSecurityService = systemSecurityService;
    }
}

