/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.secret;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.TbSecretDeleteResult;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.SecretId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.secret.Secret;
import org.thingsboard.server.common.data.secret.SecretInfo;
import org.thingsboard.server.dao.secret.SecretService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.secret.TbSecretService;

@Service
@TbCoreComponent
public class DefaultTbSecretService
extends AbstractTbEntityService
implements TbSecretService {
    private final SecretService secretService;

    public SecretInfo save(Secret secret, User user) throws ThingsboardException {
        ActionType actionType = secret.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = secret.getTenantId();
        try {
            SecretInfo savedSecret = new SecretInfo((SecretInfo)this.checkNotNull((Object)this.secretService.saveSecret(tenantId, secret)));
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)savedSecret.getId(), (HasName)savedSecret, actionType, user, new Object[0]);
            return savedSecret;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.SECRET), (HasName)secret, actionType, user, e, new Object[0]);
            throw e;
        }
    }

    public TbSecretDeleteResult delete(SecretInfo secretInfo, User user) {
        ActionType actionType = ActionType.DELETED;
        TenantId tenantId = secretInfo.getTenantId();
        SecretId secretId = secretInfo.getId();
        try {
            TbSecretDeleteResult result = this.secretService.deleteSecret(tenantId, secretInfo);
            if (result.isSuccess()) {
                this.logEntityActionService.logEntityAction(tenantId, (EntityId)secretId, (HasName)secretInfo, actionType, user, new Object[]{secretId.toString()});
            }
            return result;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.SECRET), actionType, user, e, new Object[]{secretId.toString()});
            throw e;
        }
    }

    @ConstructorProperties(value={"secretService"})
    @Generated
    public DefaultTbSecretService(SecretService secretService) {
        this.secretService = secretService;
    }
}

