/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.scheduler;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.SchedulerEventId;
import org.thingsboard.server.common.data.scheduler.SchedulerEvent;
import org.thingsboard.server.common.data.scheduler.SchedulerEventInfo;
import org.thingsboard.server.dao.scheduler.SchedulerEventService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.scheduler.TbSchedulerService;

@Service
@TbCoreComponent
public class DefaultTbSchedulerService
extends AbstractTbEntityService
implements TbSchedulerService {
    private final SchedulerEventService schedulerEventService;

    public SchedulerEvent save(SchedulerEvent schedulerEvent, User user) throws ThingsboardException {
        try {
            SchedulerEvent savedSchedulerEvent = (SchedulerEvent)this.checkNotNull((Object)this.schedulerEventService.saveSchedulerEvent(schedulerEvent));
            this.logEntityActionService.logEntityAction(user.getTenantId(), (EntityId)savedSchedulerEvent.getId(), (HasName)savedSchedulerEvent, savedSchedulerEvent.getCustomerId(), schedulerEvent.getId() == null ? ActionType.ADDED : ActionType.UPDATED, user, new Object[0]);
            return savedSchedulerEvent;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(user.getTenantId(), this.emptyId(EntityType.SCHEDULER_EVENT), (HasName)schedulerEvent, schedulerEvent.getId() == null ? ActionType.ADDED : ActionType.UPDATED, user, e, new Object[0]);
            throw e;
        }
    }

    public void delete(SchedulerEvent schedulerEvent, User user) throws ThingsboardException {
        ActionType actionType = ActionType.DELETED;
        SchedulerEventId schedulerEventId = schedulerEvent.getId();
        try {
            this.schedulerEventService.deleteSchedulerEvent(user.getTenantId(), schedulerEventId);
            this.logEntityActionService.logEntityAction(user.getTenantId(), (EntityId)schedulerEventId, (HasName)schedulerEvent, schedulerEvent.getCustomerId(), actionType, user, new Object[]{schedulerEventId.getId()});
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(user.getTenantId(), this.emptyId(EntityType.SCHEDULER_EVENT), actionType, user, e, new Object[]{schedulerEventId.getId()});
            throw e;
        }
    }

    public SchedulerEventInfo assignToEdge(SchedulerEventId schedulerEventId, Edge edge, User user) throws ThingsboardException {
        try {
            SchedulerEventInfo savedSchedulerEvent = (SchedulerEventInfo)this.checkNotNull((Object)this.schedulerEventService.assignSchedulerEventToEdge(user.getTenantId(), schedulerEventId, edge.getId()));
            this.logEntityActionService.logEntityAction(user.getTenantId(), (EntityId)schedulerEventId, (HasName)savedSchedulerEvent, ActionType.ASSIGNED_TO_EDGE, user, new Object[]{schedulerEventId.getId(), savedSchedulerEvent.getName(), edge.getId().getId(), edge.getName()});
            return savedSchedulerEvent;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(user.getTenantId(), this.emptyId(EntityType.SCHEDULER_EVENT), ActionType.ASSIGNED_TO_EDGE, user, e, new Object[]{schedulerEventId.getId(), edge.getId().getId()});
            throw e;
        }
    }

    public SchedulerEventInfo unassignFromEdge(SchedulerEventId schedulerEventId, Edge edge, User user) throws ThingsboardException {
        try {
            SchedulerEventInfo savedSchedulerEvent = (SchedulerEventInfo)this.checkNotNull((Object)this.schedulerEventService.unassignSchedulerEventFromEdge(user.getTenantId(), schedulerEventId, edge.getId()));
            this.logEntityActionService.logEntityAction(user.getTenantId(), (EntityId)schedulerEventId, (HasName)savedSchedulerEvent, ActionType.UNASSIGNED_FROM_EDGE, user, new Object[]{schedulerEventId.getId(), savedSchedulerEvent.getName(), edge.getId().getId(), edge.getName()});
            return savedSchedulerEvent;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(user.getTenantId(), this.emptyId(EntityType.SCHEDULER_EVENT), ActionType.UNASSIGNED_FROM_EDGE, user, e, new Object[]{schedulerEventId.getId()});
            throw e;
        }
    }

    @ConstructorProperties(value={"schedulerEventService"})
    @Generated
    public DefaultTbSchedulerService(SchedulerEventService schedulerEventService) {
        this.schedulerEventService = schedulerEventService;
    }
}

