/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.report;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.ReportTemplateId;
import org.thingsboard.server.common.data.report.ReportTemplate;
import org.thingsboard.server.dao.report.ReportTemplateService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.report.TbReportTemplateService;

@Service
@TbCoreComponent
public class DefaultTbReportTemplateService
extends AbstractTbEntityService
implements TbReportTemplateService {
    private final ReportTemplateService reportTemplateService;

    public ReportTemplate save(ReportTemplate reportTemplate, User user) throws Exception {
        try {
            ReportTemplate savedReportTemplate = (ReportTemplate)this.checkNotNull((Object)this.reportTemplateService.saveReportTemplate(reportTemplate));
            this.autoCommit(user, (EntityId)savedReportTemplate.getId());
            this.logEntityActionService.logEntityAction(user.getTenantId(), (EntityId)savedReportTemplate.getId(), (HasName)savedReportTemplate, savedReportTemplate.getCustomerId(), reportTemplate.getId() == null ? ActionType.ADDED : ActionType.UPDATED, user, new Object[0]);
            return savedReportTemplate;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(user.getTenantId(), this.emptyId(EntityType.REPORT_TEMPLATE), (HasName)reportTemplate, reportTemplate.getId() == null ? ActionType.ADDED : ActionType.UPDATED, user, e, new Object[0]);
            throw e;
        }
    }

    public void delete(ReportTemplate reportTemplate, User user) {
        ActionType actionType = ActionType.DELETED;
        ReportTemplateId reportTemplateId = reportTemplate.getId();
        try {
            this.reportTemplateService.deleteReportTemplate(user.getTenantId(), reportTemplateId);
            this.logEntityActionService.logEntityAction(user.getTenantId(), (EntityId)reportTemplateId, (HasName)reportTemplate, reportTemplate.getCustomerId(), actionType, user, new Object[]{reportTemplateId.getId().toString()});
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(user.getTenantId(), this.emptyId(EntityType.REPORT_TEMPLATE), actionType, user, e, new Object[]{reportTemplateId.getId().toString()});
            throw e;
        }
    }

    @ConstructorProperties(value={"reportTemplateService"})
    @Generated
    public DefaultTbReportTemplateService(ReportTemplateService reportTemplateService) {
        this.reportTemplateService = reportTemplateService;
    }
}

