/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.ota.group;

import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.ota.DeviceGroupOtaPackage;
import org.thingsboard.server.dao.ota.DeviceGroupOtaPackageService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.ota.group.TbDeviceGroupOtaPackageService;
import org.thingsboard.server.service.ota.OtaPackageStateService;

@Service
@TbCoreComponent
public class DefaultTbDeviceGroupOtaPackageService
extends AbstractTbEntityService
implements TbDeviceGroupOtaPackageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbDeviceGroupOtaPackageService.class);
    private final OtaPackageStateService otaPackageStateService;
    private final DeviceGroupOtaPackageService deviceGroupOtaPackageService;

    public DeviceGroupOtaPackage saveDeviceGroupOtaPackage(TenantId tenantId, DeviceGroupOtaPackage deviceGroupOtaPackage, User user) throws Exception {
        DeviceGroupOtaPackage oldDeviceGroupOtaPackage = Optional.ofNullable(deviceGroupOtaPackage.getId()).map(arg_0 -> ((DeviceGroupOtaPackageService)this.deviceGroupOtaPackageService).findDeviceGroupOtaPackageById(arg_0)).orElse(null);
        DeviceGroupOtaPackage savedDeviceGroupOtaPackage = this.deviceGroupOtaPackageService.saveDeviceGroupOtaPackage(tenantId, deviceGroupOtaPackage);
        this.otaPackageStateService.update(tenantId, savedDeviceGroupOtaPackage, oldDeviceGroupOtaPackage);
        this.autoCommit(user, EntityType.DEVICE, savedDeviceGroupOtaPackage.getGroupId());
        return savedDeviceGroupOtaPackage;
    }

    public void deleteDeviceGroupOtaPackage(TenantId tenantId, DeviceGroupOtaPackage deviceGroupOtaPackage) {
        this.deviceGroupOtaPackageService.deleteDeviceGroupOtaPackage(tenantId, deviceGroupOtaPackage);
        this.otaPackageStateService.update(tenantId, null, deviceGroupOtaPackage);
    }

    @ConstructorProperties(value={"otaPackageStateService", "deviceGroupOtaPackageService"})
    @Generated
    public DefaultTbDeviceGroupOtaPackageService(OtaPackageStateService otaPackageStateService, DeviceGroupOtaPackageService deviceGroupOtaPackageService) {
        this.otaPackageStateService = otaPackageStateService;
        this.deviceGroupOtaPackageService = deviceGroupOtaPackageService;
    }
}

