/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.entity.relation;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.entity.relation.TbEntityRelationService;

@Service
@TbCoreComponent
public class DefaultTbEntityRelationService
extends AbstractTbEntityService
implements TbEntityRelationService {
    private final RelationService relationService;

    public EntityRelation save(TenantId tenantId, CustomerId customerId, EntityRelation relation, User user) throws ThingsboardException {
        ActionType actionType = ActionType.RELATION_ADD_OR_UPDATE;
        try {
            EntityRelation savedRelation = this.relationService.saveRelation(tenantId, relation);
            this.logEntityActionService.logEntityRelationAction(tenantId, customerId, savedRelation, user, actionType, null, new Object[]{savedRelation});
            return savedRelation;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityRelationAction(tenantId, customerId, relation, user, actionType, e, new Object[]{relation});
            throw e;
        }
    }

    public EntityRelation delete(TenantId tenantId, CustomerId customerId, EntityRelation relation, User user) throws ThingsboardException {
        ActionType actionType = ActionType.RELATION_DELETED;
        try {
            EntityRelation found = this.relationService.deleteRelation(tenantId, relation.getFrom(), relation.getTo(), relation.getType(), relation.getTypeGroup());
            if (found == null) {
                throw new ThingsboardException("Requested item wasn't found!", ThingsboardErrorCode.ITEM_NOT_FOUND);
            }
            this.logEntityActionService.logEntityRelationAction(tenantId, customerId, found, user, actionType, null, new Object[]{found});
            return found;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityRelationAction(tenantId, customerId, relation, user, actionType, e, new Object[]{relation});
            throw e;
        }
    }

    public void deleteCommonRelations(TenantId tenantId, CustomerId customerId, EntityId entityId, User user) {
        try {
            this.relationService.deleteEntityCommonRelations(tenantId, entityId);
            this.logEntityActionService.logEntityAction(tenantId, entityId, null, customerId, ActionType.RELATIONS_DELETED, user, new Object[0]);
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, entityId, null, customerId, ActionType.RELATIONS_DELETED, user, e, new Object[0]);
            throw e;
        }
    }

    @ConstructorProperties(value={"relationService"})
    @Generated
    public DefaultTbEntityRelationService(RelationService relationService) {
        this.relationService = relationService;
    }
}

