/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.customer;

import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.GroupEntity;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.NameConflictStrategy;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.customer.TbCustomerService;
import org.thingsboard.server.service.security.model.SecurityUser;

@Service
public class DefaultTbCustomerService
extends AbstractTbEntityService
implements TbCustomerService {
    public Customer save(Customer customer, List<EntityGroup> entityGroups, SecurityUser user) throws Exception {
        return this.save(customer, entityGroups, NameConflictStrategy.DEFAULT, user);
    }

    public Customer save(Customer customer, List<EntityGroup> entityGroups, NameConflictStrategy nameConflictStrategy, SecurityUser user) throws Exception {
        ActionType actionType = customer.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = customer.getTenantId();
        try {
            Customer savedCustomer = (Customer)this.checkNotNull((Object)this.customerService.saveCustomer(customer, nameConflictStrategy));
            this.autoCommit((User)user, (EntityId)savedCustomer.getId());
            this.createOrUpdateGroupEntity(tenantId, (GroupEntity)savedCustomer, entityGroups, actionType, (User)user);
            return savedCustomer;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.CUSTOMER), (HasName)customer, actionType, (User)user, e, new Object[0]);
            throw e;
        }
    }

    public void delete(Customer customer, User user) {
        ActionType actionType = ActionType.DELETED;
        TenantId tenantId = customer.getTenantId();
        CustomerId customerId = customer.getId();
        try {
            this.customerService.deleteCustomer(tenantId, customerId);
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)customerId, (HasName)customer, customerId, actionType, user, new Object[]{customerId.toString()});
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.CUSTOMER), actionType, user, e, new Object[]{customerId.toString()});
            throw e;
        }
    }

    @Generated
    public DefaultTbCustomerService() {
    }
}

