/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.blob;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.blob.BlobEntityInfo;
import org.thingsboard.server.common.data.id.BlobEntityId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.blob.BlobEntityService;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.blob.TbBlobService;

@Service
public class DefaultTbBlobService
extends AbstractTbEntityService
implements TbBlobService {
    private final BlobEntityService blobEntityService;

    public void delete(BlobEntityInfo blobEntityInfo, User user) {
        TenantId tenantId = blobEntityInfo.getTenantId();
        BlobEntityId blobEntityId = blobEntityInfo.getId();
        try {
            this.blobEntityService.deleteBlobEntity(tenantId, blobEntityId);
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)blobEntityId, (HasName)blobEntityInfo, blobEntityInfo.getCustomerId(), ActionType.DELETED, user, new Object[]{blobEntityId.getId().toString()});
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.BLOB_ENTITY), ActionType.DELETED, user, e, new Object[]{blobEntityId.getId().toString()});
            throw e;
        }
    }

    @ConstructorProperties(value={"blobEntityService"})
    @Generated
    public DefaultTbBlobService(BlobEntityService blobEntityService) {
        this.blobEntityService = blobEntityService;
    }
}

