/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.alarm;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.ConstructorProperties;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmApiCallResult;
import org.thingsboard.server.common.data.alarm.AlarmAssignee;
import org.thingsboard.server.common.data.alarm.AlarmComment;
import org.thingsboard.server.common.data.alarm.AlarmCommentSubType;
import org.thingsboard.server.common.data.alarm.AlarmCommentType;
import org.thingsboard.server.common.data.alarm.AlarmCreateOrUpdateActiveRequest;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.alarm.AlarmUpdateRequest;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.alarm.TbAlarmCommentService;
import org.thingsboard.server.service.entitiy.alarm.TbAlarmService;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DefaultTbAlarmService
extends AbstractTbEntityService
implements TbAlarmService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbAlarmService.class);
    @Autowired
    protected TbAlarmCommentService alarmCommentService;

    public Alarm save(Alarm alarm, User user) throws ThingsboardException {
        ActionType actionType = alarm.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = alarm.getTenantId();
        try {
            AlarmApiCallResult result = alarm.getId() == null ? this.alarmSubscriptionService.createAlarm(AlarmCreateOrUpdateActiveRequest.fromAlarm((Alarm)alarm, (UserId)user.getId())) : this.alarmSubscriptionService.updateAlarm(AlarmUpdateRequest.fromAlarm((Alarm)alarm, (UserId)user.getId()));
            if (!result.isSuccessful()) {
                throw new ThingsboardException(ThingsboardErrorCode.ITEM_NOT_FOUND);
            }
            AlarmInfo resultAlarm = result.getAlarm();
            if (alarm.isAcknowledged() && !resultAlarm.isAcknowledged()) {
                resultAlarm = this.ack((Alarm)resultAlarm, alarm.getAckTs(), user);
            }
            if (alarm.isCleared() && !resultAlarm.isCleared()) {
                resultAlarm = this.clear((Alarm)resultAlarm, alarm.getClearTs(), user);
            }
            UserId newAssignee = alarm.getAssigneeId();
            UserId curAssignee = resultAlarm.getAssigneeId();
            if (newAssignee != null && !newAssignee.equals((Object)curAssignee)) {
                resultAlarm = this.assign((Alarm)resultAlarm, newAssignee, alarm.getAssignTs(), user);
            } else if (newAssignee == null && curAssignee != null) {
                resultAlarm = this.unassign(alarm, alarm.getAssignTs(), user);
            }
            if (result.isModified()) {
                this.logEntityActionService.logEntityAction(tenantId, alarm.getOriginator(), (HasName)resultAlarm, resultAlarm.getCustomerId(), actionType, user, new Object[0]);
            }
            return new Alarm((Alarm)resultAlarm);
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.ALARM), (HasName)alarm, actionType, user, e, new Object[0]);
            throw e;
        }
    }

    public AlarmInfo ack(Alarm alarm, User user) throws ThingsboardException {
        return this.ack(alarm, System.currentTimeMillis(), user);
    }

    public AlarmInfo ack(Alarm alarm, long ackTs, User user) throws ThingsboardException {
        AlarmApiCallResult result = this.alarmSubscriptionService.acknowledgeAlarm(alarm.getTenantId(), alarm.getId(), DefaultTbAlarmService.getOrDefault((long)ackTs));
        if (!result.isSuccessful()) {
            throw new ThingsboardException(ThingsboardErrorCode.ITEM_NOT_FOUND);
        }
        AlarmInfo alarmInfo = result.getAlarm();
        if (!result.isModified()) {
            throw new ThingsboardException("Alarm was already acknowledged!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        this.addSystemAlarmComment((Alarm)alarmInfo, user, AlarmCommentSubType.ACKED_BY_USER, "userName", user.getTitle());
        this.logEntityActionService.logEntityAction(alarm.getTenantId(), alarm.getOriginator(), (HasName)alarmInfo, alarmInfo.getCustomerId(), ActionType.ALARM_ACK, user, new Object[0]);
        return alarmInfo;
    }

    public AlarmInfo clear(Alarm alarm, User user) throws ThingsboardException {
        return this.clear(alarm, System.currentTimeMillis(), user);
    }

    public AlarmInfo clear(Alarm alarm, long clearTs, User user) throws ThingsboardException {
        AlarmApiCallResult result = this.alarmSubscriptionService.clearAlarm(alarm.getTenantId(), alarm.getId(), DefaultTbAlarmService.getOrDefault((long)clearTs), null);
        if (!result.isSuccessful()) {
            throw new ThingsboardException(ThingsboardErrorCode.ITEM_NOT_FOUND);
        }
        AlarmInfo alarmInfo = result.getAlarm();
        if (!result.isCleared()) {
            throw new ThingsboardException("Alarm was already cleared!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        this.addSystemAlarmComment((Alarm)alarmInfo, user, AlarmCommentSubType.CLEARED_BY_USER, "userName", user.getTitle());
        this.logEntityActionService.logEntityAction(alarm.getTenantId(), alarm.getOriginator(), (HasName)alarmInfo, alarmInfo.getCustomerId(), ActionType.ALARM_CLEAR, user, new Object[0]);
        return alarmInfo;
    }

    public AlarmInfo assign(Alarm alarm, UserId assigneeId, long assignTs, User user) throws ThingsboardException {
        AlarmApiCallResult result = this.alarmSubscriptionService.assignAlarm(alarm.getTenantId(), alarm.getId(), assigneeId, DefaultTbAlarmService.getOrDefault((long)assignTs));
        if (!result.isSuccessful()) {
            throw new ThingsboardException(ThingsboardErrorCode.ITEM_NOT_FOUND);
        }
        AlarmInfo alarmInfo = result.getAlarm();
        if (!result.isModified()) {
            throw new ThingsboardException("Alarm was already assigned to this user!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        AlarmAssignee assignee = alarmInfo.getAssignee();
        this.addSystemAlarmComment((Alarm)alarmInfo, user, AlarmCommentSubType.ASSIGNED_TO_USER, "userName", user.getTitle(), "assigneeName", assignee.getTitle());
        this.logEntityActionService.logEntityAction(alarm.getTenantId(), alarm.getOriginator(), (HasName)alarmInfo, alarmInfo.getCustomerId(), ActionType.ALARM_ASSIGNED, user, new Object[0]);
        return alarmInfo;
    }

    public AlarmInfo unassign(Alarm alarm, long unassignTs, User user) throws ThingsboardException {
        AlarmApiCallResult result = this.alarmSubscriptionService.unassignAlarm(alarm.getTenantId(), alarm.getId(), DefaultTbAlarmService.getOrDefault((long)unassignTs));
        if (!result.isSuccessful()) {
            throw new ThingsboardException(ThingsboardErrorCode.ITEM_NOT_FOUND);
        }
        AlarmInfo alarmInfo = result.getAlarm();
        if (!result.isModified()) {
            throw new ThingsboardException("Alarm was already unassigned!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        this.addSystemAlarmComment((Alarm)alarmInfo, user, AlarmCommentSubType.UNASSIGNED_BY_USER, "userName", user.getTitle());
        this.logEntityActionService.logEntityAction(alarm.getTenantId(), alarm.getOriginator(), (HasName)alarmInfo, alarmInfo.getCustomerId(), ActionType.ALARM_UNASSIGNED, user, new Object[0]);
        return alarmInfo;
    }

    public void unassignDeletedUserAlarms(TenantId tenantId, UserId userId, String userTitle, List<UUID> alarms, long unassignTs) {
        for (UUID alarmId : alarms) {
            log.trace("[{}] Unassigning alarm {} from user {}", new Object[]{tenantId, alarmId, userId});
            AlarmApiCallResult result = this.alarmSubscriptionService.unassignAlarm(tenantId, new AlarmId(alarmId), unassignTs);
            if (!result.isSuccessful()) {
                log.error("[{}] Cannot unassign alarm {} from user {}", new Object[]{tenantId, alarmId, userId});
                continue;
            }
            if (!result.isModified()) continue;
            this.addSystemAlarmComment((Alarm)result.getAlarm(), null, AlarmCommentSubType.UNASSIGNED_FROM_DELETED_USER, "userName", userTitle);
            this.logEntityActionService.logEntityAction(result.getAlarm().getTenantId(), result.getAlarm().getOriginator(), (HasName)result.getAlarm(), result.getAlarm().getCustomerId(), ActionType.ALARM_UNASSIGNED, null, new Object[0]);
        }
    }

    public boolean delete(Alarm alarm, User user) {
        boolean deleted;
        TenantId tenantId = alarm.getTenantId();
        AlarmId alarmId = alarm.getId();
        EntityId alarmOriginator = alarm.getOriginator();
        try {
            deleted = this.alarmSubscriptionService.deleteAlarm(tenantId, alarmId);
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(alarmOriginator.getEntityType()), ActionType.ALARM_DELETE, user, e, new Object[]{alarmId});
            throw e;
        }
        if (deleted) {
            this.logEntityActionService.logEntityAction(tenantId, alarmOriginator, (HasName)alarm, alarm.getCustomerId(), ActionType.ALARM_DELETE, user, new Object[]{alarmId});
        }
        return deleted;
    }

    private static long getOrDefault(long ts) {
        return ts > 0L ? ts : System.currentTimeMillis();
    }

    private void addSystemAlarmComment(Alarm alarm, User user, AlarmCommentSubType subType, String param, String value) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(1);
        params.put(param, value);
        this.addSystemAlarmComment(alarm, user, subType, params);
    }

    private void addSystemAlarmComment(Alarm alarm, User user, AlarmCommentSubType subType, String param, String value, String param2, String value2) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(2);
        params.put(param, value);
        params.put(param2, value2);
        this.addSystemAlarmComment(alarm, user, subType, params);
    }

    private void addSystemAlarmComment(Alarm alarm, User user, AlarmCommentSubType subType, Map<String, String> params) {
        ObjectNode commentNode = JacksonUtil.newObjectNode();
        commentNode.put("text", String.format(subType.getText(), params.values().toArray())).put("subtype", subType.name());
        params.forEach((arg_0, arg_1) -> ((ObjectNode)commentNode).put(arg_0, arg_1));
        AlarmComment alarmComment = AlarmComment.builder().alarmId(alarm.getId()).type(AlarmCommentType.SYSTEM).comment((JsonNode)commentNode).build();
        try {
            this.alarmCommentService.saveAlarmComment(alarm, alarmComment, user);
        }
        catch (ThingsboardException e) {
            log.error("Failed to save alarm comment", (Throwable)e);
        }
    }

    @ConstructorProperties(value={"alarmCommentService"})
    @Generated
    public DefaultTbAlarmService(TbAlarmCommentService alarmCommentService) {
        this.alarmCommentService = alarmCommentService;
    }
}

