/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import jakarta.annotation.PostConstruct;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.JobManager;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.ApiUsageState;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.server.common.data.TbResourceInfo;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.common.data.job.Job;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.notification.NotificationRequest;
import org.thingsboard.server.common.data.pat.ApiKey;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.common.data.scheduler.SchedulerEvent;
import org.thingsboard.server.common.data.scheduler.SchedulerEventInfo;
import org.thingsboard.server.common.data.secret.Secret;
import org.thingsboard.server.common.data.secret.SecretInfo;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.common.data.sync.vc.RepositorySettings;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgDataType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.ToDeviceActorNotificationMsg;
import org.thingsboard.server.common.msg.edge.EdgeEventUpdateMsg;
import org.thingsboard.server.common.msg.plugin.ComponentLifecycleMsg;
import org.thingsboard.server.common.msg.rule.engine.DeviceCredentialsUpdateNotificationMsg;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.dao.edge.EdgeSynchronizationManager;
import org.thingsboard.server.dao.eventsourcing.ActionEntityEvent;
import org.thingsboard.server.dao.eventsourcing.DeleteEntityEvent;
import org.thingsboard.server.dao.eventsourcing.RelationActionEvent;
import org.thingsboard.server.dao.eventsourcing.SaveEntityEvent;
import org.thingsboard.server.dao.secret.SecretService;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.dao.trendz.TrendzSyncService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.service.cf.CalculatedFieldCache;
import org.thingsboard.server.service.entitiy.EntityStateSourcingListener;
import org.thingsboard.server.service.scheduler.SchedulerService;
import org.thingsboard.server.service.sync.vc.EntitiesVersionControlService;
import org.thingsboard.server.service.sync.vc.GitVersionControlQueueService;

@Component
public class EntityStateSourcingListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityStateSourcingListener.class);
    private final TenantService tenantService;
    private final TbClusterService tbClusterService;
    private final EdgeSynchronizationManager edgeSynchronizationManager;
    private final JobManager jobManager;
    private final SecretService secretService;
    private final Optional<SchedulerService> schedulerService;
    private final Optional<GitVersionControlQueueService> gitServiceQueue;
    private final Optional<EntitiesVersionControlService> versionControlService;
    private final CalculatedFieldCache calculatedFieldCache;
    private final Optional<TrendzSyncService> trendzSyncService;

    @PostConstruct
    public void init() {
        log.debug("EntityStateSourcingListener initiated");
    }

    @TransactionalEventListener(fallbackExecution=true)
    public void handleEvent(SaveEntityEvent<?> event) {
        if (Boolean.FALSE.equals(event.getBroadcastEvent())) {
            log.trace("Ignoring event {}", event);
            return;
        }
        TenantId tenantId = event.getTenantId();
        EntityId entityId = event.getEntityId();
        if (entityId == null) {
            return;
        }
        EntityType entityType = entityId.getEntityType();
        log.debug("[{}][{}][{}] Handling entity save event: {}", new Object[]{tenantId, entityType, entityId, event});
        boolean isCreated = event.getCreated() != null && event.getCreated() != false;
        ComponentLifecycleEvent lifecycleEvent = isCreated ? ComponentLifecycleEvent.CREATED : ComponentLifecycleEvent.UPDATED;
        switch (3.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityType.ordinal()]) {
            case 1: {
                this.onAssetUpdate(event.getEntity(), event.getOldEntity());
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.tbClusterService.broadcastEntityStateChangeEvent(tenantId, entityId, lifecycleEvent);
                break;
            }
            case 5: {
                RuleChain ruleChain = (RuleChain)event.getEntity();
                if (!RuleChainType.CORE.equals((Object)ruleChain.getType())) break;
                this.tbClusterService.broadcastEntityStateChangeEvent(ruleChain.getTenantId(), (EntityId)ruleChain.getId(), lifecycleEvent);
                break;
            }
            case 6: {
                Tenant tenant = (Tenant)event.getEntity();
                this.onTenantUpdate(tenant, lifecycleEvent);
                break;
            }
            case 7: {
                TenantProfile tenantProfile = (TenantProfile)event.getEntity();
                this.onTenantProfileUpdate(tenantProfile, lifecycleEvent);
                break;
            }
            case 8: {
                this.onDeviceUpdate(event.getEntity(), event.getOldEntity());
                break;
            }
            case 9: {
                DeviceProfile deviceProfile = (DeviceProfile)event.getEntity();
                this.onDeviceProfileUpdate(deviceProfile, event.getOldEntity(), isCreated);
                break;
            }
            case 10: {
                this.onEdgeEvent(tenantId, entityId, event.getEntity(), lifecycleEvent);
                break;
            }
            case 11: {
                TbResource tbResource = (TbResource)event.getEntity();
                this.tbClusterService.onResourceChange((TbResourceInfo)tbResource, null);
                break;
            }
            case 12: {
                ApiUsageState apiUsageState = (ApiUsageState)event.getEntity();
                this.tbClusterService.onApiStateChange(apiUsageState, null);
                break;
            }
            case 13: {
                Integration integration = (Integration)event.getEntity();
                if (integration.isEdgeTemplate()) break;
                this.tbClusterService.broadcastEntityStateChangeEvent(tenantId, (EntityId)integration.getId(), lifecycleEvent);
                break;
            }
            case 14: {
                Converter converter = (Converter)event.getEntity();
                if (converter.isEdgeTemplate()) break;
                this.tbClusterService.broadcastEntityStateChangeEvent(tenantId, (EntityId)converter.getId(), lifecycleEvent);
                break;
            }
            case 15: {
                this.tbClusterService.onCustomerUpdated((Customer)event.getEntity(), (Customer)event.getOldEntity());
                break;
            }
            case 16: {
                if (!isCreated) {
                    this.tbClusterService.onUserUpdated((User)event.getEntity(), (User)event.getOldEntity());
                }
                this.tbClusterService.broadcastEntityStateChangeEvent(event.getTenantId(), event.getEntityId(), lifecycleEvent);
                break;
            }
            case 17: {
                this.onCalculatedFieldUpdate(event.getEntity(), event.getOldEntity());
                break;
            }
            case 18: {
                this.onJobUpdate((Job)event.getEntity());
                break;
            }
            case 19: {
                if (isCreated) break;
                Secret secret = (Secret)event.getEntity();
                Map entities = this.secretService.findEntitiesBySecret(tenantId, (SecretInfo)secret);
                entities.forEach((type, entityInfos) -> {
                    if (type == EntityType.RULE_CHAIN || type == EntityType.INTEGRATION) {
                        entityInfos.forEach(entityInfo -> this.tbClusterService.broadcastEntityStateChangeEvent(tenantId, entityInfo.getId(), lifecycleEvent));
                    } else if (type == EntityType.ADMIN_SETTINGS && this.gitServiceQueue.isPresent() && this.versionControlService.isPresent()) {
                        entityInfos.stream().filter(entityInfo -> "entitiesVersionControl".equals(entityInfo.getName())).findFirst().ifPresent(entityInfo -> {
                            RepositorySettings vcSettings = ((EntitiesVersionControlService)this.versionControlService.get()).getVersionControlSettings(tenantId);
                            ((GitVersionControlQueueService)this.gitServiceQueue.get()).initRepository(tenantId, vcSettings);
                        });
                    }
                });
                break;
            }
            case 20: {
                SchedulerEvent schedulerEvent = (SchedulerEvent)event.getEntity();
                if (isCreated) {
                    this.schedulerService.ifPresent(service -> service.onSchedulerEventAdded((SchedulerEventInfo)schedulerEvent));
                    break;
                }
                this.schedulerService.ifPresent(service -> service.onSchedulerEventUpdated((SchedulerEventInfo)schedulerEvent));
                break;
            }
            case 21: {
                if (isCreated) break;
                this.trendzSyncService.ifPresent(service -> service.performApiKeyRotationSync((ApiKey)event.getEntity(), (ApiKey)event.getOldEntity()));
                break;
            }
        }
    }

    @TransactionalEventListener(fallbackExecution=true)
    public void handleEvent(DeleteEntityEvent<?> event) {
        TenantId tenantId = event.getTenantId();
        EntityId entityId = event.getEntityId();
        if (entityId == null) {
            return;
        }
        EntityType entityType = entityId.getEntityType();
        if (entityType != EntityType.TENANT && !this.tenantExists(tenantId)) {
            log.debug("[{}] Ignoring DeleteEntityEvent because tenant does not exist: {}", (Object)tenantId, event);
            return;
        }
        log.debug("[{}][{}][{}] Handling entity deletion event: {}", new Object[]{tenantId, entityType, entityId, event});
        switch (3.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityType.ordinal()]) {
            case 1: {
                Asset asset = (Asset)event.getEntity();
                this.tbClusterService.onAssetDeleted(tenantId, asset, null);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 15: 
            case 16: {
                this.tbClusterService.broadcastEntityStateChangeEvent(tenantId, entityId, ComponentLifecycleEvent.DELETED);
                break;
            }
            case 22: {
                NotificationRequest request = (NotificationRequest)event.getEntity();
                if (!request.isScheduled()) break;
                this.tbClusterService.broadcastEntityStateChangeEvent(tenantId, entityId, ComponentLifecycleEvent.DELETED);
                break;
            }
            case 5: {
                RuleChain ruleChain = (RuleChain)event.getEntity();
                if (!RuleChainType.CORE.equals((Object)ruleChain.getType())) break;
                Set referencingRuleChainIds = (Set)JacksonUtil.fromString((String)event.getBody(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                if (referencingRuleChainIds != null) {
                    referencingRuleChainIds.forEach(referencingRuleChainId -> this.tbClusterService.broadcastEntityStateChangeEvent(tenantId, (EntityId)referencingRuleChainId, ComponentLifecycleEvent.UPDATED));
                }
                this.tbClusterService.broadcastEntityStateChangeEvent(tenantId, (EntityId)ruleChain.getId(), ComponentLifecycleEvent.DELETED);
                break;
            }
            case 6: {
                Tenant tenant = (Tenant)event.getEntity();
                this.onTenantDeleted(tenant);
                break;
            }
            case 7: {
                TenantProfile tenantProfile = (TenantProfile)event.getEntity();
                this.tbClusterService.onTenantProfileDelete(tenantProfile, TbQueueCallback.EMPTY);
                break;
            }
            case 8: {
                Device device = (Device)event.getEntity();
                this.tbClusterService.onDeviceDeleted(tenantId, device, TbQueueCallback.EMPTY);
                break;
            }
            case 9: {
                DeviceProfile deviceProfile = (DeviceProfile)event.getEntity();
                this.onDeviceProfileDelete(event.getTenantId(), event.getEntityId(), deviceProfile);
                break;
            }
            case 11: {
                TbResourceInfo tbResource = (TbResourceInfo)event.getEntity();
                this.tbClusterService.onResourceDeleted(tbResource, TbQueueCallback.EMPTY);
                break;
            }
            case 17: {
                CalculatedField calculatedField = (CalculatedField)event.getEntity();
                this.tbClusterService.onCalculatedFieldDeleted(calculatedField, TbQueueCallback.EMPTY);
                break;
            }
            case 13: {
                Integration integration = (Integration)event.getEntity();
                if (integration.isEdgeTemplate()) break;
                this.tbClusterService.broadcastEntityStateChangeEvent(integration.getTenantId(), (EntityId)integration.getId(), ComponentLifecycleEvent.DELETED);
                break;
            }
            case 14: {
                Converter converter = (Converter)event.getEntity();
                if (converter.isEdgeTemplate()) break;
                this.tbClusterService.broadcastEntityStateChangeEvent(tenantId, (EntityId)converter.getId(), ComponentLifecycleEvent.DELETED);
                break;
            }
            case 20: {
                this.schedulerService.ifPresent(service -> service.onSchedulerEventDeleted((SchedulerEventInfo)((SchedulerEvent)event.getEntity())));
                break;
            }
        }
    }

    @TransactionalEventListener(fallbackExecution=true)
    public void handleEvent(ActionEntityEvent<?> event) {
        TenantId tenantId = event.getTenantId();
        log.trace("[{}] ActionEntityEvent called: {}", (Object)tenantId, event);
        switch (3.$SwitchMap$org$thingsboard$server$common$data$audit$ActionType[event.getActionType().ordinal()]) {
            case 1: {
                Object object;
                if (event.getEntityId().getEntityType() == EntityType.DEVICE && (object = event.getEntity()) instanceof DeviceCredentials) {
                    DeviceCredentials deviceCredentials = (DeviceCredentials)object;
                    this.tbClusterService.pushMsgToCore((ToDeviceActorNotificationMsg)new DeviceCredentialsUpdateNotificationMsg(tenantId, (DeviceId)event.getEntityId(), deviceCredentials), null);
                    break;
                }
                if (event.getEntityId().getEntityType() != EntityType.USER) break;
                this.tbClusterService.broadcastEntityStateChangeEvent(event.getTenantId(), event.getEntityId(), ComponentLifecycleEvent.UPDATED);
                break;
            }
            case 2: {
                Object object = event.getEntity();
                if (!(object instanceof Device)) break;
                Device device = (Device)object;
                Tenant tenant = (Tenant)JacksonUtil.fromString((String)event.getBody(), Tenant.class);
                if (tenant != null) {
                    this.tbClusterService.onDeviceAssignedToTenant(tenant.getId(), device);
                }
                this.pushAssignedFromNotification(tenant, tenantId, device);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (event.getActionType() == ActionType.ALARM_DELETE && !this.tenantExists(tenantId)) {
                    return;
                }
                Alarm alarm = (Alarm)event.getEntity();
                if (!this.calculatedFieldCache.hasCalculatedFields(tenantId, alarm.getOriginator(), ctx -> ctx.getCfType() == CalculatedFieldType.ALARM)) break;
                TransportProtos.ToCalculatedFieldMsg msg = TransportProtos.ToCalculatedFieldMsg.newBuilder().setEventMsg(this.toProto(event)).build();
                this.tbClusterService.pushMsgToCalculatedFields(tenantId, alarm.getOriginator(), msg, (TbQueueCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    @TransactionalEventListener(fallbackExecution=true)
    public void handleEvent(RelationActionEvent relationEvent) {
        EntityRelation relation = relationEvent.getRelation();
        if (CalculatedField.isSupportedRefEntity((EntityId)relation.getFrom()) && CalculatedField.isSupportedRefEntity((EntityId)relation.getTo())) {
            if (relationEvent.getActionType() == ActionType.RELATION_ADD_OR_UPDATE) {
                this.tbClusterService.onRelationUpdated(relationEvent.getTenantId(), relation, TbQueueCallback.EMPTY);
            } else if (relationEvent.getActionType() == ActionType.RELATION_DELETED) {
                this.tbClusterService.onRelationDeleted(relationEvent.getTenantId(), relation, TbQueueCallback.EMPTY);
            }
        }
    }

    private void onTenantUpdate(Tenant tenant, ComponentLifecycleEvent lifecycleEvent) {
        this.tbClusterService.onTenantChange(tenant, null);
        this.tbClusterService.broadcastEntityStateChangeEvent(tenant.getId(), (EntityId)tenant.getId(), lifecycleEvent);
    }

    private void onTenantDeleted(Tenant tenant) {
        this.tbClusterService.onTenantDelete(tenant, null);
        this.tbClusterService.broadcastEntityStateChangeEvent(tenant.getId(), (EntityId)tenant.getId(), ComponentLifecycleEvent.DELETED);
    }

    private void onTenantProfileUpdate(TenantProfile tenantProfile, ComponentLifecycleEvent lifecycleEvent) {
        this.tbClusterService.onTenantProfileChange(tenantProfile, null);
        this.tbClusterService.broadcastEntityStateChangeEvent(TenantId.SYS_TENANT_ID, (EntityId)tenantProfile.getId(), lifecycleEvent);
    }

    private void onDeviceProfileUpdate(DeviceProfile deviceProfile, Object oldEntity, boolean isCreated) {
        DeviceProfile oldDeviceProfile = null;
        if (!isCreated) {
            oldDeviceProfile = this.getOldDeviceProfile(oldEntity);
        }
        this.tbClusterService.onDeviceProfileChange(deviceProfile, oldDeviceProfile, null);
    }

    private DeviceProfile getOldDeviceProfile(Object oldEntity) {
        return oldEntity instanceof DeviceProfile ? (DeviceProfile)oldEntity : null;
    }

    private void onDeviceProfileDelete(TenantId tenantId, EntityId entityId, DeviceProfile deviceProfile) {
        this.tbClusterService.onDeviceProfileDelete(deviceProfile, null);
        this.tbClusterService.broadcastEntityStateChangeEvent(tenantId, entityId, ComponentLifecycleEvent.DELETED);
    }

    private void onDeviceUpdate(Object entity, Object oldEntity) {
        Device device = (Device)entity;
        Device oldDevice = null;
        if (oldEntity instanceof Device) {
            oldDevice = (Device)oldEntity;
        }
        this.tbClusterService.onDeviceUpdated(device, oldDevice);
    }

    private void onAssetUpdate(Object entity, Object oldEntity) {
        Asset asset = (Asset)entity;
        Asset oldAsset = null;
        if (oldEntity instanceof Asset) {
            oldAsset = (Asset)oldEntity;
        }
        this.tbClusterService.onAssetUpdated(asset, oldAsset);
    }

    private void onEdgeEvent(TenantId tenantId, EntityId entityId, Object entity, ComponentLifecycleEvent lifecycleEvent) {
        if (entity instanceof Edge) {
            if (entityId.equals(this.edgeSynchronizationManager.getEdgeId().get())) {
                return;
            }
            this.tbClusterService.onEdgeStateChangeEvent(new ComponentLifecycleMsg(tenantId, entityId, lifecycleEvent));
        } else if (entity instanceof EdgeEvent) {
            EdgeEvent edgeEvent = (EdgeEvent)entity;
            this.tbClusterService.onEdgeEventUpdate(new EdgeEventUpdateMsg(tenantId, edgeEvent.getEdgeId()));
        }
    }

    private void onCalculatedFieldUpdate(Object entity, Object oldEntity) {
        CalculatedField calculatedField = (CalculatedField)entity;
        CalculatedField oldCalculatedField = null;
        if (oldEntity instanceof CalculatedField) {
            oldCalculatedField = (CalculatedField)oldEntity;
        }
        this.tbClusterService.onCalculatedFieldUpdated(calculatedField, oldCalculatedField, TbQueueCallback.EMPTY);
    }

    private void onJobUpdate(Job job) {
        ComponentLifecycleEvent event;
        this.jobManager.onJobUpdate(job);
        if (job.getResult().getCancellationTs() > 0L) {
            event = ComponentLifecycleEvent.STOPPED;
        } else if (job.getResult().getGeneralError() != null) {
            event = ComponentLifecycleEvent.FAILED;
        } else {
            return;
        }
        ComponentLifecycleMsg msg = ComponentLifecycleMsg.builder().tenantId(job.getTenantId()).entityId((EntityId)job.getId()).event(event).info((JsonNode)JacksonUtil.newObjectNode().put("tasksKey", job.getConfiguration().getTasksKey())).build();
        this.tbClusterService.broadcast(msg);
    }

    private void pushAssignedFromNotification(Tenant currentTenant, TenantId newTenantId, Device assignedDevice) {
        String data = JacksonUtil.toString((Object)JacksonUtil.valueToTree((Object)assignedDevice));
        if (data != null) {
            TbMsg tbMsg = TbMsg.newMsg().type(TbMsgType.ENTITY_ASSIGNED_FROM_TENANT).originator((EntityId)assignedDevice.getId()).customerId(assignedDevice.getCustomerId()).copyMetaData(this.getMetaDataForAssignedFrom(currentTenant)).dataType(TbMsgDataType.JSON).data(data).build();
            this.tbClusterService.pushMsgToRuleEngine(newTenantId, (EntityId)assignedDevice.getId(), tbMsg, null);
        }
    }

    private boolean tenantExists(TenantId tenantId) {
        return tenantId.isSysTenantId() || this.tenantService.tenantExists(tenantId);
    }

    private TbMsgMetaData getMetaDataForAssignedFrom(Tenant tenant) {
        TbMsgMetaData metaData = new TbMsgMetaData();
        metaData.putValue("assignedFromTenantId", tenant.getId().getId().toString());
        metaData.putValue("assignedFromTenantName", tenant.getName());
        return metaData;
    }

    private TransportProtos.EntityActionEventProto toProto(ActionEntityEvent<?> event) {
        return TransportProtos.EntityActionEventProto.newBuilder().setTenantId(ProtoUtils.toProto((EntityId)event.getTenantId())).setEntityId(ProtoUtils.toProto((EntityId)event.getEntityId())).setAction(event.getActionType().name()).setEntity(event.getEntity() != null ? JacksonUtil.toString((Object)event.getEntity()) : "").build();
    }

    @ConstructorProperties(value={"tenantService", "tbClusterService", "edgeSynchronizationManager", "jobManager", "secretService", "schedulerService", "gitServiceQueue", "versionControlService", "calculatedFieldCache", "trendzSyncService"})
    @Generated
    public EntityStateSourcingListener(TenantService tenantService, TbClusterService tbClusterService, EdgeSynchronizationManager edgeSynchronizationManager, JobManager jobManager, SecretService secretService, Optional<SchedulerService> schedulerService, Optional<GitVersionControlQueueService> gitServiceQueue, Optional<EntitiesVersionControlService> versionControlService, CalculatedFieldCache calculatedFieldCache, Optional<TrendzSyncService> trendzSyncService) {
        this.tenantService = tenantService;
        this.tbClusterService = tbClusterService;
        this.edgeSynchronizationManager = edgeSynchronizationManager;
        this.jobManager = jobManager;
        this.secretService = secretService;
        this.schedulerService = schedulerService;
        this.gitServiceQueue = gitServiceQueue;
        this.versionControlService = versionControlService;
        this.calculatedFieldCache = calculatedFieldCache;
        this.trendzSyncService = trendzSyncService;
    }
}

