/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.service.action.EntityActionService;
import org.thingsboard.server.service.entitiy.TbLogEntityActionService;

@Service
public class DefaultTbLogEntityActionService
implements TbLogEntityActionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbLogEntityActionService.class);
    private final EntityActionService entityActionService;

    public <I extends EntityId> void logEntityAction(TenantId tenantId, I entityId, ActionType actionType, User user, Exception e, Object ... additionalInfo) {
        this.logEntityAction(tenantId, entityId, null, null, actionType, user, e, additionalInfo);
    }

    public <E extends HasName, I extends EntityId> void logEntityAction(TenantId tenantId, I entityId, E entity, ActionType actionType, User user, Object ... additionalInfo) {
        this.logEntityAction(tenantId, entityId, entity, null, actionType, user, null, additionalInfo);
    }

    public <E extends HasName, I extends EntityId> void logEntityAction(TenantId tenantId, I entityId, E entity, ActionType actionType, User user, Exception e, Object ... additionalInfo) {
        this.logEntityAction(tenantId, entityId, entity, null, actionType, user, e, additionalInfo);
    }

    public <E extends HasName, I extends EntityId> void logEntityAction(TenantId tenantId, I entityId, E entity, CustomerId customerId, ActionType actionType, User user, Object ... additionalInfo) {
        this.logEntityAction(tenantId, entityId, entity, customerId, actionType, user, null, additionalInfo);
    }

    public <E extends HasName, I extends EntityId> void logEntityAction(TenantId tenantId, I entityId, E entity, CustomerId customerId, ActionType actionType, User user, Exception e, Object ... additionalInfo) {
        if (user != null) {
            this.entityActionService.logEntityAction(user, entityId, entity, customerId, actionType, e, additionalInfo);
        } else if (e == null) {
            this.entityActionService.pushEntityActionToRuleEngine(entityId, entity, tenantId, customerId, actionType, additionalInfo);
        }
    }

    public void logEntityRelationAction(TenantId tenantId, CustomerId customerId, EntityRelation relation, User user, ActionType actionType, Exception e, Object ... additionalInfo) {
        this.logEntityAction(tenantId, relation.getFrom(), null, customerId, actionType, user, e, additionalInfo);
        this.logEntityAction(tenantId, relation.getTo(), null, customerId, actionType, user, e, additionalInfo);
    }

    @ConstructorProperties(value={"entityActionService"})
    @Generated
    public DefaultTbLogEntityActionService(EntityActionService entityActionService) {
        this.entityActionService = entityActionService;
    }
}

