/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.GroupEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.alarm.AlarmService;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.dao.entity.EntityService;
import org.thingsboard.server.dao.group.EntityGroupService;
import org.thingsboard.server.dao.model.ModelConstants;
import org.thingsboard.server.service.entitiy.TbLogEntityActionService;
import org.thingsboard.server.service.sync.vc.EntitiesVersionControlService;
import org.thingsboard.server.service.telemetry.AlarmSubscriptionService;

public abstract class AbstractTbEntityService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractTbEntityService.class);
    @Autowired
    private Environment env;
    @Autowired(required=false)
    protected TbLogEntityActionService logEntityActionService;
    @Autowired(required=false)
    protected EdgeService edgeService;
    @Autowired
    protected AlarmService alarmService;
    @Autowired
    @Lazy
    protected AlarmSubscriptionService alarmSubscriptionService;
    @Autowired
    protected CustomerService customerService;
    @Autowired
    protected TbClusterService tbClusterService;
    @Autowired
    protected EntityGroupService entityGroupService;
    @Autowired(required=false)
    @Lazy
    private EntitiesVersionControlService vcService;
    @Autowired
    protected EntityService entityService;

    protected boolean isTestProfile() {
        return Set.of(this.env.getActiveProfiles()).contains("test");
    }

    protected <T> T checkNotNull(T reference) throws ThingsboardException {
        return (T)this.checkNotNull(reference, "Requested item wasn't found!");
    }

    protected <T> T checkNotNull(T reference, String notFoundMessage) throws ThingsboardException {
        if (reference == null) {
            throw new ThingsboardException(notFoundMessage, ThingsboardErrorCode.ITEM_NOT_FOUND);
        }
        return reference;
    }

    protected <T> T checkNotNull(Optional<T> reference) throws ThingsboardException {
        return (T)this.checkNotNull(reference, "Requested item wasn't found!");
    }

    protected <T> T checkNotNull(Optional<T> reference, String notFoundMessage) throws ThingsboardException {
        if (reference.isPresent()) {
            return reference.get();
        }
        throw new ThingsboardException(notFoundMessage, ThingsboardErrorCode.ITEM_NOT_FOUND);
    }

    protected <I extends EntityId> I emptyId(EntityType entityType) {
        return (I)EntityIdFactory.getByTypeAndUuid((EntityType)entityType, (UUID)ModelConstants.NULL_UUID);
    }

    protected <I extends EntityId, T extends GroupEntity<I>> void createOrUpdateGroupEntity(TenantId tenantId, T entity, List<EntityGroup> entityGroups, ActionType actionType, User user) {
        EntityId entityId = (EntityId)entity.getId();
        CustomerId customerId = entity.getCustomerId();
        if (entityGroups != null && actionType == ActionType.ADDED) {
            for (EntityGroup entityGroup : entityGroups) {
                EntityGroupId entityGroupId = entityGroup.getId();
                this.entityGroupService.addEntityToEntityGroup(tenantId, entityGroupId, entityId);
                this.logEntityActionService.logEntityAction(tenantId, entityId, entity, customerId, ActionType.ADDED_TO_ENTITY_GROUP, user, new Object[]{entityId.toString(), entityGroupId.toString(), entityGroup.getName()});
            }
        }
        this.logEntityActionService.logEntityAction(tenantId, entityId, entity, customerId, actionType, user, new Object[0]);
    }

    protected ListenableFuture<UUID> autoCommit(User user, EntityId entityId) {
        if (this.vcService != null) {
            return this.vcService.autoCommit(user, entityId);
        }
        return Futures.immediateFailedFuture((Throwable)new RuntimeException("Operation not supported!"));
    }

    protected ListenableFuture<UUID> autoCommit(User user, EntityType entityType, List<UUID> entityIds) {
        if (this.vcService != null) {
            return this.vcService.autoCommit(user, entityType, entityIds);
        }
        return Futures.immediateFailedFuture((Throwable)new RuntimeException("Operation not supported!"));
    }

    protected ListenableFuture<UUID> autoCommit(User user, EntityType entityType, EntityGroupId groupId) throws Exception {
        if (this.vcService != null) {
            return this.vcService.autoCommit(user, entityType, groupId);
        }
        return Futures.immediateFailedFuture((Throwable)new RuntimeException("Operation not supported!"));
    }
}

