/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.thingsboard.server.common.data.HasTenantId;

public abstract class AbstractEtagCacheService<K extends HasTenantId> {
    public final Cache<K, String> etagCache;

    public AbstractEtagCacheService(int cacheTtl, int cacheMaxSize) {
        this.etagCache = Caffeine.newBuilder().expireAfterAccess((long)cacheTtl, TimeUnit.MINUTES).maximumSize((long)cacheMaxSize).build();
    }

    public String getETag(K cacheKey) {
        return (String)this.etagCache.getIfPresent(cacheKey);
    }

    public void putETag(K cacheKey, String etag) {
        this.etagCache.put(cacheKey, (Object)etag);
    }

    public void invalidateByFilter(Predicate<K> predicate) {
        Set keysToInvalidate = this.etagCache.asMap().keySet().stream().filter(predicate).collect(Collectors.toSet());
        this.etagCache.invalidateAll(keysToInvalidate);
    }
}

