/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edqs;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.queue.discovery.TopicService;
import org.thingsboard.server.queue.edqs.EdqsConfig;
import org.thingsboard.server.queue.kafka.KafkaAdmin;
import org.thingsboard.server.service.edqs.EdqsSyncService;

@Service
@ConditionalOnExpression(value="'${queue.edqs.sync.enabled:true}' == 'true' && '${queue.type:null}' == 'kafka'")
public class KafkaEdqsSyncService
extends EdqsSyncService {
    private final boolean syncNeeded;

    public KafkaEdqsSyncService(KafkaAdmin kafkaAdmin, TopicService topicService, EdqsConfig edqsConfig) {
        this.syncNeeded = kafkaAdmin.areAllTopicsEmpty(IntStream.range(0, edqsConfig.getPartitions()).mapToObj(partition -> TopicPartitionInfo.builder().topic(topicService.buildTopicName(edqsConfig.getEventsTopic())).partition(Integer.valueOf(partition)).build().getFullTopicName()).collect(Collectors.toSet()));
    }

    public boolean isSyncNeeded() {
        return this.syncNeeded;
    }
}

