/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edqs;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.GeneratedMessageV3;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.UUID;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.edqs.query.EdqsRequest;
import org.thingsboard.server.common.data.edqs.query.EdqsResponse;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.edqs.EdqsApiService;
import org.thingsboard.server.edqs.state.EdqsPartitionService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueRequestTemplate;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.provider.EdqsClientQueueFactory;

@Service
@ConditionalOnExpression(value="'${queue.edqs.api.supported:true}' == 'true' && ('${service.type:null}' == 'monolith' || '${service.type:null}' == 'tb-core')")
public class DefaultEdqsApiService
implements EdqsApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultEdqsApiService.class);
    private final EdqsPartitionService edqsPartitionService;
    private final EdqsClientQueueFactory queueFactory;
    private TbQueueRequestTemplate<TbProtoQueueMsg<TransportProtos.ToEdqsMsg>, TbProtoQueueMsg<TransportProtos.FromEdqsMsg>> requestTemplate;

    @PostConstruct
    private void init() {
        this.requestTemplate = this.queueFactory.createEdqsRequestTemplate();
        this.requestTemplate.init();
    }

    public ListenableFuture<EdqsResponse> processRequest(TenantId tenantId, CustomerId customerId, EdqsRequest request) {
        TransportProtos.ToEdqsMsg.Builder requestMsg = TransportProtos.ToEdqsMsg.newBuilder().setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).setTs(System.currentTimeMillis()).setRequestMsg(TransportProtos.EdqsRequestMsg.newBuilder().setValue(JacksonUtil.toString((Object)request)).build());
        if (customerId != null && !customerId.isNullUid()) {
            requestMsg.setCustomerIdMSB(customerId.getId().getMostSignificantBits());
            requestMsg.setCustomerIdLSB(customerId.getId().getLeastSignificantBits());
        }
        UUID key = UUID.randomUUID();
        Integer partition = this.edqsPartitionService.resolvePartition(tenantId, (Object)key);
        ListenableFuture resultFuture = this.requestTemplate.send((TbQueueMsg)new TbProtoQueueMsg(key, (GeneratedMessageV3)requestMsg.build()), partition);
        return Futures.transform((ListenableFuture)resultFuture, msg -> {
            TransportProtos.EdqsResponseMsg responseMsg = ((TransportProtos.FromEdqsMsg)msg.getValue()).getResponseMsg();
            return (EdqsResponse)JacksonUtil.fromString((String)responseMsg.getValue(), EdqsResponse.class);
        }, (Executor)MoreExecutors.directExecutor());
    }

    public boolean isSupported() {
        return true;
    }

    @PreDestroy
    private void stop() {
        this.requestTemplate.stop();
    }

    @ConstructorProperties(value={"edqsPartitionService", "queueFactory"})
    @Generated
    public DefaultEdqsApiService(EdqsPartitionService edqsPartitionService, EdqsClientQueueFactory queueFactory) {
        this.edqsPartitionService = edqsPartitionService;
        this.queueFactory = queueFactory;
    }
}

