/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.wl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.domain.DomainInfo;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.wl.WhiteLabeling;
import org.thingsboard.server.common.data.wl.WhiteLabelingType;
import org.thingsboard.server.dao.domain.DomainService;
import org.thingsboard.server.dao.wl.WhiteLabelingService;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.OAuth2DomainUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.edge.v1.WhiteLabelingProto;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.wl.WhiteLabelingEdgeProcessor;

@Component
@TbCoreComponent
public class WhiteLabelingEdgeProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WhiteLabelingEdgeProcessor.class);
    @Autowired
    protected WhiteLabelingService whiteLabelingService;
    @Autowired
    protected DomainService domainService;

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        try {
            switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[edgeEvent.getAction().ordinal()]) {
                case 1: 
                case 2: {
                    CustomerId customerId;
                    EntityId entityId = (EntityId)JacksonUtil.convertValue((Object)edgeEvent.getBody(), EntityId.class);
                    if (entityId == null) {
                        return null;
                    }
                    TenantId tenantId = EntityType.TENANT.equals((Object)entityId.getEntityType()) ? (TenantId)entityId : edgeEvent.getTenantId();
                    WhiteLabeling whiteLabeling = this.whiteLabelingService.findByEntityId(tenantId, customerId = EntityType.CUSTOMER.equals((Object)entityId.getEntityType()) ? new CustomerId(entityId.getId()) : null, this.getWhiteLabelingType(edgeEvent.getType()));
                    if (whiteLabeling == null) {
                        return null;
                    }
                    UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
                    WhiteLabelingProto whiteLabelingProto = EdgeMsgConstructorUtils.constructWhiteLabeling((UpdateMsgType)msgType, (WhiteLabeling)whiteLabeling);
                    DownlinkMsg.Builder builder = DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).setWhiteLabelingProto(whiteLabelingProto);
                    if (WhiteLabelingType.LOGIN.equals((Object)whiteLabeling.getType()) && whiteLabeling.getDomainId() != null) {
                        DomainInfo domainInfo = this.domainService.findDomainInfoById(tenantId, whiteLabeling.getDomainId());
                        OAuth2DomainUpdateMsg oAuth2DomainUpdateMsg = EdgeMsgConstructorUtils.constructOAuth2DomainUpdateMsg((UpdateMsgType)UpdateMsgType.ENTITY_CREATED_RPC_MESSAGE, (DomainInfo)domainInfo);
                        builder.addOAuth2DomainUpdateMsg(oAuth2DomainUpdateMsg);
                    }
                    return builder.build();
                }
                case 3: {
                    WhiteLabeling whiteLabeling = (WhiteLabeling)JacksonUtil.convertValue((Object)edgeEvent.getBody(), WhiteLabeling.class);
                    WhiteLabelingProto whiteLabelingProto = EdgeMsgConstructorUtils.constructWhiteLabeling((UpdateMsgType)UpdateMsgType.ENTITY_DELETED_RPC_MESSAGE, (WhiteLabeling)whiteLabeling);
                    return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).setWhiteLabelingProto(whiteLabelingProto).build();
                }
            }
        }
        catch (Exception e) {
            log.error("Can't process white labeling msg [{}]", (Object)edgeEvent, (Object)e);
        }
        return null;
    }

    private WhiteLabelingType getWhiteLabelingType(EdgeEventType type) {
        return switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventType[type.ordinal()]) {
            case 1 -> WhiteLabelingType.GENERAL;
            case 2 -> WhiteLabelingType.MAIL_TEMPLATES;
            case 3 -> WhiteLabelingType.LOGIN;
            default -> null;
        };
    }

    public ListenableFuture<Void> processEntityNotification(TenantId tenantId, TransportProtos.EdgeNotificationMsgProto edgeNotificationMsg) {
        EdgeEventActionType actionType = EdgeEventActionType.valueOf((String)edgeNotificationMsg.getAction());
        EdgeEventType type = EdgeEventType.valueOf((String)edgeNotificationMsg.getType());
        EntityId entityId = EntityIdFactory.getByEdgeEventTypeAndUuid((EdgeEventType)EdgeEventType.valueOf((String)edgeNotificationMsg.getEntityType()), (UUID)new UUID(edgeNotificationMsg.getEntityIdMSB(), edgeNotificationMsg.getEntityIdLSB()));
        EdgeId sourceEdgeId = this.safeGetEdgeId(edgeNotificationMsg.getOriginatorEdgeIdMSB(), edgeNotificationMsg.getOriginatorEdgeIdLSB());
        JsonNode body = actionType.equals((Object)EdgeEventActionType.DELETED) ? JacksonUtil.toJsonNode((String)edgeNotificationMsg.getBody()) : JacksonUtil.valueToTree((Object)entityId);
        switch (1.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityId.getEntityType().ordinal()]) {
            case 1: {
                List futures = new ArrayList();
                if (TenantId.SYS_TENANT_ID.equals((Object)tenantId)) {
                    PageDataIterable tenantIds = new PageDataIterable(link -> this.edgeCtx.getTenantService().findTenantsIds(link), 1024);
                    for (TenantId tenantId1 : tenantIds) {
                        futures.addAll(this.processActionForAllEdgesByTenantId(tenantId1, type, actionType, null, body, sourceEdgeId, null));
                    }
                } else {
                    futures = this.processActionForAllEdgesByTenantId(tenantId, type, actionType, null, body, sourceEdgeId, null);
                }
                return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)this.dbCallbackExecutorService);
            }
            case 2: {
                List edgesByCustomerId = this.edgeCtx.getCustomersHierarchyEdgeService().findAllEdgesInHierarchyByCustomerId(tenantId, new CustomerId(entityId.getId()));
                if (edgesByCustomerId != null) {
                    for (EdgeId edgeId : edgesByCustomerId) {
                        this.saveEdgeEvent(tenantId, edgeId, type, actionType, null, body);
                    }
                }
                return Futures.immediateFuture(null);
            }
        }
        return Futures.immediateFuture(null);
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.WHITE_LABELING;
    }
}

