/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.user;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.HasOwnerId;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.security.UserCredentials;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.exception.DataValidationException;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.edge.v1.UserCredentialsUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UserUpdateMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.user.BaseUserProcessor;
import org.thingsboard.server.service.edge.rpc.processor.user.UserEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.user.UserProcessor;

@Component
@TbCoreComponent
public class UserEdgeProcessor
extends BaseUserProcessor
implements UserProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserEdgeProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processUserMsgFromEdge(TenantId tenantId, Edge edge, UserUpdateMsg userUpdateMsg, EdgeVersion edgeVersion) {
        log.trace("[{}] executing processUserMsgFromEdge [{}] from edge [{}]", new Object[]{tenantId, userUpdateMsg, edge.getId()});
        UserId userId = new UserId(new UUID(userUpdateMsg.getIdMSB(), userUpdateMsg.getIdLSB()));
        try {
            ListenableFuture entityGroupId;
            this.edgeSynchronizationManager.getEdgeId().set(edge.getId());
            entityGroupId = switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[userUpdateMsg.getMsgType().ordinal()]) {
                case 1, 2 -> {
                    this.saveOrUpdateUser(tenantId, userId, userUpdateMsg, edge);
                    yield Futures.immediateFuture(null);
                }
                case 3 -> {
                    if (userUpdateMsg.hasEntityGroupIdMSB() && userUpdateMsg.hasEntityGroupIdLSB()) {
                        entityGroupId = new EntityGroupId(new UUID(userUpdateMsg.getEntityGroupIdMSB(), userUpdateMsg.getEntityGroupIdLSB()));
                        this.edgeCtx.getEntityGroupService().removeEntityFromEntityGroup(tenantId, (EntityGroupId)entityGroupId, (EntityId)userId);
                        yield Futures.immediateFuture(null);
                    }
                    if (edgeVersion.getNumber() >= 13) {
                        this.deleteUserAndPushEntityDeletedEventToRuleEngine(tenantId, userId, edge);
                    }
                    yield Futures.immediateFuture(null);
                }
                default -> this.handleUnsupportedMsgType(userUpdateMsg.getMsgType());
            };
            return entityGroupId;
        }
        catch (ThingsboardException | DataValidationException e) {
            if (e.getMessage().contains("limit reached")) {
                log.warn("[{}] Number of allowed users violated {}", new Object[]{tenantId, userUpdateMsg, e});
                ListenableFuture listenableFuture = Futures.immediateFuture(null);
                return listenableFuture;
            }
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)e);
            return listenableFuture;
        }
        finally {
            this.edgeSynchronizationManager.getEdgeId().remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processUserCredentialsMsgFromEdge(TenantId tenantId, Edge edge, UserCredentialsUpdateMsg userCredentialsUpdateMsg) {
        log.debug("[{}] Executing processUserCredentialsMsgFromEdge, userCredentialsUpdateMsg [{}]", (Object)tenantId, (Object)userCredentialsUpdateMsg);
        try {
            this.edgeSynchronizationManager.getEdgeId().set(edge.getId());
            super.updateUserCredentials(tenantId, userCredentialsUpdateMsg);
        }
        finally {
            this.edgeSynchronizationManager.getEdgeId().remove();
        }
        return Futures.immediateFuture(null);
    }

    private void saveOrUpdateUser(TenantId tenantId, UserId userId, UserUpdateMsg userUpdateMsg, Edge edge) throws ThingsboardException {
        Pair resultPair = super.saveOrUpdateUser(tenantId, userId, userUpdateMsg);
        boolean isCreated = (Boolean)resultPair.getFirst();
        if (isCreated) {
            this.createRelationFromEdge(tenantId, edge.getId(), (EntityId)userId);
            this.pushUserCreatedEventToRuleEngine(tenantId, edge, userId);
        }
        this.addUserToEdgeAllUserGroup(tenantId, edge, userId);
        boolean userEmailUpdated = (Boolean)resultPair.getSecond();
        if (userEmailUpdated) {
            this.saveEdgeEvent(tenantId, edge.getId(), EdgeEventType.USER, EdgeEventActionType.UPDATED, (EntityId)userId, null);
        }
    }

    private void addUserToEdgeAllUserGroup(TenantId tenantId, Edge edge, UserId userId) {
        User user = this.edgeCtx.getUserService().findUserById(tenantId, userId);
        this.addEntityToEdgeAllGroup(tenantId, edge, (HasOwnerId)user);
    }

    private void pushUserCreatedEventToRuleEngine(TenantId tenantId, Edge edge, UserId userId) {
        try {
            User user = this.edgeCtx.getUserService().findUserById(tenantId, userId);
            if (user != null) {
                String userAsString = JacksonUtil.toString((Object)user);
                TbMsgMetaData msgMetaData = this.getEdgeActionTbMsgMetaData(edge, user.getCustomerId());
                this.pushEntityEventToRuleEngine(tenantId, (EntityId)userId, user.getCustomerId(), TbMsgType.ENTITY_CREATED, userAsString, msgMetaData);
            }
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to push user action to rule engine: {}", new Object[]{tenantId, userId, TbMsgType.ENTITY_CREATED.name(), e});
        }
    }

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        UserId userId = new UserId(edgeEvent.getEntityId());
        EntityGroupId entityGroupId = edgeEvent.getEntityGroupId() != null ? new EntityGroupId(edgeEvent.getEntityGroupId()) : null;
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[edgeEvent.getAction().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                User user = this.edgeCtx.getUserService().findUserById(edgeEvent.getTenantId(), userId);
                if (user == null) break;
                UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
                DownlinkMsg.Builder builder = DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addUserUpdateMsg(EdgeMsgConstructorUtils.constructUserUpdatedMsg((UpdateMsgType)msgType, (User)user, (EntityGroupId)entityGroupId));
                UserCredentials userCredentialsByUserId = this.edgeCtx.getUserService().findUserCredentialsByUserId(edgeEvent.getTenantId(), userId);
                if (userCredentialsByUserId != null) {
                    builder.addUserCredentialsUpdateMsg(EdgeMsgConstructorUtils.constructUserCredentialsUpdatedMsg((UserCredentials)userCredentialsByUserId));
                }
                return builder.build();
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addUserUpdateMsg(EdgeMsgConstructorUtils.constructUserDeleteMsg((UserId)userId, (EntityGroupId)entityGroupId)).build();
            }
            case 9: {
                UserCredentials userCredentialsByUserId = this.edgeCtx.getUserService().findUserCredentialsByUserId(edgeEvent.getTenantId(), userId);
                if (userCredentialsByUserId == null) break;
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addUserCredentialsUpdateMsg(EdgeMsgConstructorUtils.constructUserCredentialsUpdatedMsg((UserCredentials)userCredentialsByUserId)).build();
            }
        }
        return null;
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.USER;
    }

    protected void setCustomerId(TenantId tenantId, CustomerId customerId, User user, UserUpdateMsg userUpdateMsg) {
        CustomerId customerUUID = user.getCustomerId() != null ? user.getCustomerId() : customerId;
        user.setCustomerId(customerUUID);
    }
}

