/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.translation;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.translation.CustomTranslation;
import org.thingsboard.server.gen.edge.v1.CustomTranslationUpdateMsg;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.translation.CustomTranslationEdgeProcessor;

@Component
@TbCoreComponent
public class CustomTranslationEdgeProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomTranslationEdgeProcessor.class);

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        DownlinkMsg result = null;
        try {
            CustomTranslation customTranslation = (CustomTranslation)JacksonUtil.treeToValue((JsonNode)edgeEvent.getBody(), CustomTranslation.class);
            if (customTranslation == null) {
                return null;
            }
            UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
            CustomTranslationUpdateMsg customTranslationMsg = EdgeMsgConstructorUtils.constructCustomTranslationMsg((UpdateMsgType)msgType, (CustomTranslation)customTranslation);
            result = DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).setCustomTranslationUpdateMsg(customTranslationMsg).build();
        }
        catch (Exception e) {
            log.error("Can't process custom translation msg [{}]", (Object)edgeEvent, (Object)e);
        }
        return result;
    }

    public ListenableFuture<Void> processEntityNotification(TenantId tenantId, TransportProtos.EdgeNotificationMsgProto edgeNotificationMsg) {
        EdgeEventType type = EdgeEventType.valueOf((String)edgeNotificationMsg.getType());
        EntityId entityId = EntityIdFactory.getByEdgeEventTypeAndUuid((EdgeEventType)EdgeEventType.valueOf((String)edgeNotificationMsg.getEntityType()), (UUID)new UUID(edgeNotificationMsg.getEntityIdMSB(), edgeNotificationMsg.getEntityIdLSB()));
        EdgeId sourceEdgeId = this.safeGetEdgeId(edgeNotificationMsg.getOriginatorEdgeIdMSB(), edgeNotificationMsg.getOriginatorEdgeIdLSB());
        EdgeEventActionType actionType = EdgeEventActionType.valueOf((String)edgeNotificationMsg.getAction());
        switch (1.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityId.getEntityType().ordinal()]) {
            case 1: {
                List futures = new ArrayList();
                if (TenantId.SYS_TENANT_ID.equals((Object)tenantId)) {
                    PageData tenantsIds;
                    PageLink pageLink = new PageLink(1000);
                    do {
                        tenantsIds = this.edgeCtx.getTenantService().findTenantsIds(pageLink);
                        for (TenantId tenantId1 : tenantsIds.getData()) {
                            futures.addAll(this.processActionForAllEdgesByTenantId(tenantId1, type, actionType, entityId, JacksonUtil.toJsonNode((String)edgeNotificationMsg.getBody()), sourceEdgeId, null));
                        }
                        pageLink = pageLink.nextPageLink();
                    } while (tenantsIds.hasNext());
                } else {
                    futures = this.processActionForAllEdgesByTenantId(tenantId, type, actionType, entityId, JacksonUtil.toJsonNode((String)edgeNotificationMsg.getBody()), sourceEdgeId, null);
                }
                return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)this.dbCallbackExecutorService);
            }
            case 2: {
                List edgesByCustomerId = this.edgeCtx.getCustomersHierarchyEdgeService().findAllEdgesInHierarchyByCustomerId(tenantId, new CustomerId(entityId.getId()));
                if (edgesByCustomerId == null) break;
                for (EdgeId edgeId : edgesByCustomerId) {
                    this.saveEdgeEvent(tenantId, edgeId, type, actionType, entityId, JacksonUtil.toJsonNode((String)edgeNotificationMsg.getBody()));
                }
                break;
            }
        }
        return Futures.immediateFuture(null);
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.CUSTOM_TRANSLATION;
    }
}

