/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.scheduler;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.SchedulerEventId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.scheduler.SchedulerEvent;
import org.thingsboard.server.common.data.scheduler.SchedulerEventInfo;
import org.thingsboard.server.dao.service.DataValidator;
import org.thingsboard.server.gen.edge.v1.SchedulerEventUpdateMsg;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

public abstract class BaseSchedulerEventProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseSchedulerEventProcessor.class);
    @Autowired
    private DataValidator<SchedulerEvent> schedulerEventValidator;

    protected Boolean saveOrUpdateSchedulerEvent(TenantId tenantId, SchedulerEventId schedulerEventId, SchedulerEventUpdateMsg schedulerEventUpdateMsg) {
        boolean created = false;
        try {
            SchedulerEvent schedulerEvent = (SchedulerEvent)JacksonUtil.fromString((String)schedulerEventUpdateMsg.getEntity(), SchedulerEvent.class, (boolean)true);
            if (schedulerEvent == null) {
                throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] schedulerEventUpdateMsg {" + String.valueOf(schedulerEventUpdateMsg) + "} cannot be converted to scheduler event");
            }
            SchedulerEvent existingSchedulerEvent = this.edgeCtx.getSchedulerEventService().findSchedulerEventById(tenantId, schedulerEventId);
            if (existingSchedulerEvent == null) {
                created = true;
                schedulerEvent.setId(null);
            }
            this.schedulerEventValidator.validate((BaseData)schedulerEvent, SchedulerEventInfo::getTenantId);
            if (created) {
                this.updateEnabledBasedOnCreationRules(schedulerEvent);
                schedulerEvent.setId((UUIDBased)schedulerEventId);
            } else {
                schedulerEvent.setEnabled(existingSchedulerEvent.isEnabled());
            }
            this.edgeCtx.getSchedulerEventService().saveSchedulerEvent(schedulerEvent, false);
        }
        catch (Exception e) {
            log.error("[{}] Failed to process scheduler event update msg [{}]", new Object[]{tenantId, schedulerEventUpdateMsg, e});
            throw e;
        }
        return created;
    }

    private void updateEnabledBasedOnCreationRules(SchedulerEvent newSchedulerEvent) {
        boolean isEnabled = newSchedulerEvent.isEnabled() && this.isEnabledDuringCreation();
        newSchedulerEvent.setEnabled(isEnabled);
    }

    protected abstract boolean isEnabledDuringCreation();

    protected abstract void setCustomerId(TenantId var1, CustomerId var2, SchedulerEvent var3);
}

