/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.rule;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainMetaData;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.exception.DataValidationException;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.RuleChainMetadataUpdateMsg;
import org.thingsboard.server.gen.edge.v1.RuleChainUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.rule.BaseRuleChainProcessor;
import org.thingsboard.server.service.edge.rpc.processor.rule.RuleChainEdgeProcessor;

@Component
@TbCoreComponent
public class RuleChainEdgeProcessor
extends BaseRuleChainProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleChainEdgeProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processRuleChainMsgFromEdge(TenantId tenantId, Edge edge, RuleChainUpdateMsg ruleChainUpdateMsg) {
        log.trace("[{}] executing processRuleChainMsgFromEdge [{}] from edge [{}]", new Object[]{tenantId, ruleChainUpdateMsg, edge.getName()});
        RuleChainId ruleChainId = new RuleChainId(new UUID(ruleChainUpdateMsg.getIdMSB(), ruleChainUpdateMsg.getIdLSB()));
        try {
            this.edgeSynchronizationManager.getEdgeId().set(edge.getId());
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[ruleChainUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    ListenableFuture listenableFuture = this.saveOrUpdateRuleChain(tenantId, ruleChainId, ruleChainUpdateMsg, edge);
                    return listenableFuture;
                }
                case 3: {
                    RuleChain ruleChainToDelete = this.edgeCtx.getRuleChainService().findRuleChainById(tenantId, ruleChainId);
                    if (ruleChainToDelete != null) {
                        this.edgeCtx.getRuleChainService().unassignRuleChainFromEdge(tenantId, ruleChainId, edge.getId(), false);
                    }
                    ListenableFuture listenableFuture = Futures.immediateFuture(null);
                    return listenableFuture;
                }
            }
            ListenableFuture listenableFuture = this.handleUnsupportedMsgType(ruleChainUpdateMsg.getMsgType());
            return listenableFuture;
        }
        catch (DataValidationException e) {
            if (e.getMessage().contains("limit reached")) {
                log.warn("[{}] Number of allowed rule chains violated {}", new Object[]{tenantId, ruleChainUpdateMsg, e});
                ListenableFuture listenableFuture = Futures.immediateFuture(null);
                return listenableFuture;
            }
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)e);
            return listenableFuture;
        }
        finally {
            this.edgeSynchronizationManager.getEdgeId().remove();
        }
    }

    private ListenableFuture<Void> saveOrUpdateRuleChain(TenantId tenantId, RuleChainId ruleChainId, RuleChainUpdateMsg ruleChainUpdateMsg, Edge edge) {
        try {
            Boolean isRoot;
            Pair resultPair = super.saveOrUpdateRuleChain(tenantId, ruleChainId, ruleChainUpdateMsg, RuleChainType.EDGE);
            Boolean created = (Boolean)resultPair.getFirst();
            if (created.booleanValue()) {
                this.createRelationFromEdge(tenantId, edge.getId(), (EntityId)ruleChainId);
                this.pushRuleChainCreatedEventToRuleEngine(tenantId, edge, ruleChainId, ruleChainUpdateMsg.getEntity());
                this.edgeCtx.getRuleChainService().assignRuleChainToEdge(tenantId, ruleChainId, edge.getId());
            }
            if ((isRoot = (Boolean)resultPair.getSecond()).booleanValue()) {
                edge = this.edgeCtx.getEdgeService().findEdgeById(tenantId, edge.getId());
                this.edgeCtx.getEdgeService().setEdgeRootRuleChain(tenantId, edge, ruleChainId);
            }
        }
        catch (Exception e) {
            log.error("Failed to save or update rule chain", (Throwable)e);
            return Futures.immediateFailedFuture((Throwable)e);
        }
        return Futures.immediateFuture(null);
    }

    private void pushRuleChainCreatedEventToRuleEngine(TenantId tenantId, Edge edge, RuleChainId ruleChainId, String ruleChainAsString) {
        try {
            TbMsgMetaData msgMetaData = this.getEdgeActionTbMsgMetaData(edge, null);
            this.pushEntityEventToRuleEngine(tenantId, (EntityId)ruleChainId, null, TbMsgType.ENTITY_CREATED, ruleChainAsString, msgMetaData);
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to push rule chain action to rule engine: {}", new Object[]{tenantId, ruleChainId, TbMsgType.ENTITY_CREATED.name(), e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processRuleChainMetadataMsgFromEdge(TenantId tenantId, Edge edge, RuleChainMetadataUpdateMsg ruleChainMetadataUpdateMsg) {
        log.trace("[{}] executing processRuleChainMetadataMsgFromEdge [{}] from edge [{}]", new Object[]{tenantId, ruleChainMetadataUpdateMsg, edge.getName()});
        try {
            this.edgeSynchronizationManager.getEdgeId().set(edge.getId());
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[ruleChainMetadataUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    this.saveOrUpdateRuleChainMetadata(tenantId, ruleChainMetadataUpdateMsg);
                    ListenableFuture listenableFuture = Futures.immediateFuture(null);
                    return listenableFuture;
                }
            }
            ListenableFuture listenableFuture = this.handleUnsupportedMsgType(ruleChainMetadataUpdateMsg.getMsgType());
            return listenableFuture;
        }
        catch (Exception e) {
            String errMsg = String.format("Can't process rule chain metadata update msg %s", ruleChainMetadataUpdateMsg);
            log.error(errMsg, (Throwable)e);
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)new RuntimeException(errMsg, e));
            return listenableFuture;
        }
        finally {
            this.edgeSynchronizationManager.getEdgeId().remove();
        }
    }

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        RuleChainId ruleChainId = new RuleChainId(edgeEvent.getEntityId());
        DownlinkMsg downlinkMsg = null;
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[edgeEvent.getAction().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                RuleChain ruleChain = this.edgeCtx.getRuleChainService().findRuleChainById(edgeEvent.getTenantId(), ruleChainId);
                if (ruleChain == null) break;
                boolean isRoot = false;
                if (edgeEvent.getBody() != null && edgeEvent.getBody().get("isRoot") != null) {
                    try {
                        isRoot = Boolean.parseBoolean(edgeEvent.getBody().get("isRoot").asText());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!isRoot) {
                    Edge edge = this.edgeCtx.getEdgeService().findEdgeById(edgeEvent.getTenantId(), edgeEvent.getEdgeId());
                    isRoot = edge.getRootRuleChainId().equals((Object)ruleChainId);
                }
                UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
                RuleChainUpdateMsg ruleChainUpdateMsg = EdgeMsgConstructorUtils.constructRuleChainUpdatedMsg((UpdateMsgType)msgType, (RuleChain)ruleChain, (boolean)isRoot);
                DownlinkMsg.Builder builder = DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addRuleChainUpdateMsg(ruleChainUpdateMsg);
                RuleChainMetaData ruleChainMetaData = this.edgeCtx.getRuleChainService().loadRuleChainMetaData(edgeEvent.getTenantId(), ruleChainId);
                RuleChainMetadataUpdateMsg ruleChainMetadataUpdateMsg = EdgeMsgConstructorUtils.constructRuleChainMetadataUpdatedMsg((UpdateMsgType)msgType, (RuleChainMetaData)ruleChainMetaData, (EdgeVersion)edgeVersion);
                builder.addRuleChainMetadataUpdateMsg(ruleChainMetadataUpdateMsg);
                downlinkMsg = builder.build();
                break;
            }
            case 4: 
            case 5: {
                downlinkMsg = DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addRuleChainUpdateMsg(EdgeMsgConstructorUtils.constructRuleChainDeleteMsg((RuleChainId)ruleChainId)).build();
            }
        }
        return downlinkMsg;
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.RULE_CHAIN;
    }
}

