/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.report;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.ReportTemplateId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.report.ReportTemplate;
import org.thingsboard.server.exception.DataValidationException;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.ReportTemplateUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.report.BaseReportTemplateProcessor;
import org.thingsboard.server.service.edge.rpc.processor.report.ReportTemplateEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.report.ReportTemplateProcessor;

@Component
@TbCoreComponent
public class ReportTemplateEdgeProcessor
extends BaseReportTemplateProcessor
implements ReportTemplateProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportTemplateEdgeProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processReportTemplateMsgFromEdge(TenantId tenantId, Edge edge, ReportTemplateUpdateMsg reportTemplateUpdateMsg) {
        log.trace("[{}] executing processReportTemplateMsgFromEdge [{}] from edge [{}]", new Object[]{tenantId, reportTemplateUpdateMsg, edge.getId()});
        ReportTemplateId reportTemplateId = new ReportTemplateId(new UUID(reportTemplateUpdateMsg.getIdMSB(), reportTemplateUpdateMsg.getIdLSB()));
        try {
            this.edgeSynchronizationManager.getEdgeId().set(edge.getId());
            ListenableFuture listenableFuture = switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[reportTemplateUpdateMsg.getMsgType().ordinal()]) {
                case 1, 2 -> {
                    this.saveOrUpdateReportTemplate(tenantId, reportTemplateId, reportTemplateUpdateMsg, edge);
                    yield Futures.immediateFuture(null);
                }
                case 3 -> {
                    this.deleteReportTemplate(tenantId, reportTemplateId);
                    yield Futures.immediateFuture(null);
                }
                default -> this.handleUnsupportedMsgType(reportTemplateUpdateMsg.getMsgType());
            };
            return listenableFuture;
        }
        catch (DataValidationException e) {
            log.warn("[{}] Failed to process ReportTemplateUpdateMsg from Edge [{}]", new Object[]{tenantId, reportTemplateUpdateMsg, e});
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)e);
            return listenableFuture;
        }
        finally {
            this.edgeSynchronizationManager.getEdgeId().remove();
        }
    }

    private void saveOrUpdateReportTemplate(TenantId tenantId, ReportTemplateId reportTemplateId, ReportTemplateUpdateMsg reportTemplateUpdateMsg, Edge edge) {
        Boolean created = super.saveOrUpdateReportTemplate(tenantId, reportTemplateId, reportTemplateUpdateMsg);
        if (created.booleanValue()) {
            this.pushReportTemplateCreatedEventToRuleEngine(tenantId, edge, reportTemplateId);
        }
    }

    private void pushReportTemplateCreatedEventToRuleEngine(TenantId tenantId, Edge edge, ReportTemplateId reportTemplateId) {
        ReportTemplate reportTemplate = this.edgeCtx.getReportTemplateService().findReportTemplateById(tenantId, reportTemplateId);
        this.pushReportTemplateEventToRuleEngine(tenantId, edge, reportTemplate, TbMsgType.ENTITY_CREATED);
    }

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        ReportTemplateId reportTemplateId = new ReportTemplateId(edgeEvent.getEntityId());
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[edgeEvent.getAction().ordinal()]) {
            case 1: 
            case 2: {
                ReportTemplate reportTemplate = this.edgeCtx.getReportTemplateService().findReportTemplateById(edgeEvent.getTenantId(), reportTemplateId);
                if (reportTemplate == null) break;
                UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
                ReportTemplateUpdateMsg reportTemplateUpdateMsg = EdgeMsgConstructorUtils.constructReportTemplateUpdatedMsg((UpdateMsgType)msgType, (ReportTemplate)reportTemplate);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addReportTemplateUpdateMsg(reportTemplateUpdateMsg).build();
            }
            case 3: {
                ReportTemplateUpdateMsg reportTemplateUpdateMsg = EdgeMsgConstructorUtils.constructReportTemplateDeleteMsg((ReportTemplateId)reportTemplateId);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addReportTemplateUpdateMsg(reportTemplateUpdateMsg).build();
            }
        }
        return null;
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.REPORT_TEMPLATE;
    }
}

