/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.oauth2;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.domain.DomainInfo;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.DomainId;
import org.thingsboard.server.common.data.id.OAuth2ClientId;
import org.thingsboard.server.common.data.oauth2.OAuth2Client;
import org.thingsboard.server.dao.domain.DomainService;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.OAuth2ClientUpdateMsg;
import org.thingsboard.server.gen.edge.v1.OAuth2DomainUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.oauth2.DomainEdgeProcessor;

@Component
@TbCoreComponent
public class DomainEdgeProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DomainEdgeProcessor.class);
    @Autowired
    private DomainService domainService;

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        DomainId domainId = new DomainId(edgeEvent.getEntityId());
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[edgeEvent.getAction().ordinal()]) {
            case 1: 
            case 2: {
                DomainInfo domainInfo = this.domainService.findDomainInfoById(edgeEvent.getTenantId(), domainId);
                if (domainInfo == null || !domainInfo.isPropagateToEdge()) break;
                UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
                OAuth2DomainUpdateMsg oAuth2DomainUpdateMsg = EdgeMsgConstructorUtils.constructOAuth2DomainUpdateMsg((UpdateMsgType)msgType, (DomainInfo)domainInfo);
                DownlinkMsg.Builder builder = DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addOAuth2DomainUpdateMsg(oAuth2DomainUpdateMsg);
                domainInfo.getOauth2ClientInfos().forEach(clientInfo -> {
                    OAuth2Client oauth2Client = this.edgeCtx.getOAuth2ClientService().findOAuth2ClientById(edgeEvent.getTenantId(), (OAuth2ClientId)clientInfo.getId());
                    OAuth2ClientUpdateMsg oAuth2ClientUpdateMsg = EdgeMsgConstructorUtils.constructOAuth2ClientUpdateMsg((UpdateMsgType)msgType, (OAuth2Client)oauth2Client);
                    builder.addOAuth2ClientUpdateMsg(oAuth2ClientUpdateMsg);
                });
                return builder.build();
            }
            case 3: {
                OAuth2DomainUpdateMsg oAuth2DomainUpdateMsg = EdgeMsgConstructorUtils.constructOAuth2DomainDeleteMsg((DomainId)domainId);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addOAuth2DomainUpdateMsg(oAuth2DomainUpdateMsg).build();
            }
        }
        return null;
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.DOMAIN;
    }
}

