/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.notification;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.NotificationTemplateId;
import org.thingsboard.server.common.data.notification.template.NotificationTemplate;
import org.thingsboard.server.dao.notification.NotificationTemplateService;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.NotificationTemplateUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.notification.NotificationTemplateEdgeProcessor;

@Component
@TbCoreComponent
public class NotificationTemplateEdgeProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotificationTemplateEdgeProcessor.class);
    @Autowired
    private NotificationTemplateService notificationTemplateService;

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        NotificationTemplateId notificationTemplateId = new NotificationTemplateId(edgeEvent.getEntityId());
        DownlinkMsg downlinkMsg = null;
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[edgeEvent.getAction().ordinal()]) {
            case 1: 
            case 2: {
                NotificationTemplate notificationTemplate = this.notificationTemplateService.findNotificationTemplateById(edgeEvent.getTenantId(), notificationTemplateId);
                if (notificationTemplate == null) break;
                UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
                NotificationTemplateUpdateMsg notificationTemplateUpdateMsg = EdgeMsgConstructorUtils.constructNotificationTemplateUpdateMsg((UpdateMsgType)msgType, (NotificationTemplate)notificationTemplate);
                downlinkMsg = DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addNotificationTemplateUpdateMsg(notificationTemplateUpdateMsg).build();
                break;
            }
            case 3: {
                NotificationTemplateUpdateMsg notificationTemplateUpdateMsg = EdgeMsgConstructorUtils.constructNotificationTemplateDeleteMsg((NotificationTemplateId)notificationTemplateId);
                downlinkMsg = DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addNotificationTemplateUpdateMsg(notificationTemplateUpdateMsg).build();
            }
        }
        return downlinkMsg;
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.NOTIFICATION_TEMPLATE;
    }
}

