/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.entityview;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.HasOwnerId;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.exception.DataValidationException;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.EntityViewUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.entityview.BaseEntityViewProcessor;
import org.thingsboard.server.service.edge.rpc.processor.entityview.EntityViewEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.entityview.EntityViewProcessor;

@Component
@TbCoreComponent
public class EntityViewEdgeProcessor
extends BaseEntityViewProcessor
implements EntityViewProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityViewEdgeProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processEntityViewMsgFromEdge(TenantId tenantId, Edge edge, EntityViewUpdateMsg entityViewUpdateMsg, EdgeVersion edgeVersion) {
        log.trace("[{}] executing processEntityViewMsgFromEdge [{}] from edge [{}]", new Object[]{tenantId, entityViewUpdateMsg, edge.getId()});
        EntityViewId entityViewId = new EntityViewId(new UUID(entityViewUpdateMsg.getIdMSB(), entityViewUpdateMsg.getIdLSB()));
        try {
            ListenableFuture entityGroupId;
            this.edgeSynchronizationManager.getEdgeId().set(edge.getId());
            entityGroupId = switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[entityViewUpdateMsg.getMsgType().ordinal()]) {
                case 1, 2 -> {
                    this.saveOrUpdateEntityView(tenantId, entityViewId, entityViewUpdateMsg, edge);
                    yield Futures.immediateFuture(null);
                }
                case 3 -> {
                    if (entityViewUpdateMsg.hasEntityGroupIdMSB() && entityViewUpdateMsg.hasEntityGroupIdLSB()) {
                        entityGroupId = new EntityGroupId(new UUID(entityViewUpdateMsg.getEntityGroupIdMSB(), entityViewUpdateMsg.getEntityGroupIdLSB()));
                        this.edgeCtx.getEntityGroupService().removeEntityFromEntityGroup(tenantId, (EntityGroupId)entityGroupId, (EntityId)entityViewId);
                    } else if (edgeVersion.getNumber() >= 13) {
                        this.deleteEntityView(tenantId, edge, entityViewId);
                    } else {
                        this.removeEntityViewFromEdgeAllEntityViewGroup(tenantId, edge, entityViewId);
                    }
                    yield Futures.immediateFuture(null);
                }
                default -> this.handleUnsupportedMsgType(entityViewUpdateMsg.getMsgType());
            };
            return entityGroupId;
        }
        catch (ThingsboardException | DataValidationException e) {
            if (e.getMessage().contains("limit reached")) {
                log.warn("[{}] Number of allowed entity views violated {}", new Object[]{tenantId, entityViewUpdateMsg, e});
                ListenableFuture listenableFuture = Futures.immediateFuture(null);
                return listenableFuture;
            }
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)e);
            return listenableFuture;
        }
        finally {
            this.edgeSynchronizationManager.getEdgeId().remove();
        }
    }

    private void saveOrUpdateEntityView(TenantId tenantId, EntityViewId entityViewId, EntityViewUpdateMsg entityViewUpdateMsg, Edge edge) throws ThingsboardException {
        Pair resultPair = super.saveOrUpdateEntityView(tenantId, entityViewId, entityViewUpdateMsg);
        Boolean created = (Boolean)resultPair.getFirst();
        if (created.booleanValue()) {
            this.createRelationFromEdge(tenantId, edge.getId(), (EntityId)entityViewId);
            this.pushEntityViewCreatedEventToRuleEngine(tenantId, edge, entityViewId);
        }
        this.addEntityViewToEdgeAllEntityViewGroup(tenantId, edge, entityViewId);
        Boolean assetNameUpdated = (Boolean)resultPair.getSecond();
        if (assetNameUpdated.booleanValue()) {
            this.saveEdgeEvent(tenantId, edge.getId(), EdgeEventType.ENTITY_VIEW, EdgeEventActionType.UPDATED, (EntityId)entityViewId, null);
        }
    }

    private void pushEntityViewCreatedEventToRuleEngine(TenantId tenantId, Edge edge, EntityViewId entityViewId) {
        EntityView entityView = this.edgeCtx.getEntityViewService().findEntityViewById(tenantId, entityViewId);
        this.pushEntityEventToRuleEngine(tenantId, edge, (HasId)entityView, TbMsgType.ENTITY_CREATED);
    }

    private void addEntityViewToEdgeAllEntityViewGroup(TenantId tenantId, Edge edge, EntityViewId entityViewId) {
        EntityView entityView = this.edgeCtx.getEntityViewService().findEntityViewById(tenantId, entityViewId);
        this.addEntityToEdgeAllGroup(tenantId, edge, (HasOwnerId)entityView);
    }

    private void removeEntityViewFromEdgeAllEntityViewGroup(TenantId tenantId, Edge edge, EntityViewId entityViewId) {
        EntityView entityViewToDelete = this.edgeCtx.getEntityViewService().findEntityViewById(tenantId, entityViewId);
        this.removeEntityFromEdgeAllGroup(tenantId, edge, (HasOwnerId)entityViewToDelete);
    }

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        EntityViewId entityViewId = new EntityViewId(edgeEvent.getEntityId());
        EntityGroupId entityGroupId = edgeEvent.getEntityGroupId() != null ? new EntityGroupId(edgeEvent.getEntityGroupId()) : null;
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[edgeEvent.getAction().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                EntityView entityView = this.edgeCtx.getEntityViewService().findEntityViewById(edgeEvent.getTenantId(), entityViewId);
                if (entityView == null) break;
                UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
                EntityViewUpdateMsg entityViewUpdateMsg = EdgeMsgConstructorUtils.constructEntityViewUpdatedMsg((UpdateMsgType)msgType, (EntityView)entityView, (EntityGroupId)entityGroupId);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addEntityViewUpdateMsg(entityViewUpdateMsg).build();
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addEntityViewUpdateMsg(EdgeMsgConstructorUtils.constructEntityViewDeleteMsg((EntityViewId)entityViewId, (EntityGroupId)entityGroupId)).build();
            }
        }
        return null;
    }

    protected void setCustomerId(TenantId tenantId, CustomerId customerId, EntityView entityView, EntityViewUpdateMsg entityViewUpdateMsg) {
        CustomerId customerUUID = entityView.getCustomerId() != null ? entityView.getCustomerId() : customerId;
        entityView.setCustomerId(customerUUID);
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.ENTITY_VIEW;
    }
}

